/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.badge;

import io.docops.docopsextensionssupport.badge.BadgeControllerKt;
import io.docops.docopsextensionssupport.badge.BadgeFormatException;
import io.docops.docopsextensionssupport.badge.DocOpsBadgeGenerator;
import io.docops.docopsextensionssupport.badge.FormBadge;
import io.docops.docopsextensionssupport.svgsupport.SvgToPng;
import io.docops.docopsextensionssupport.web.panel.PanelGeneratorKt;
import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import jakarta.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\tH\u0017J\u001a\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0001\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\n\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\tH\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0012\u0010\u0018\u001a\u00020\t2\b\b\u0001\u0010\u0019\u001a\u00020\tH\u0017J\u0012\u0010\u001a\u001a\u00020\u00132\b\b\u0001\u0010\u0019\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/docops/docopsextensionssupport/badge/BadgeController;", "", "docOpsBadgeGenerator", "Lio/docops/docopsextensionssupport/badge/DocOpsBadgeGenerator;", "(Lio/docops/docopsextensionssupport/badge/DocOpsBadgeGenerator;)V", "badges", "Lorg/springframework/http/ResponseEntity;", "", "payload", "", "type", "getBadgeByForm", "", "badge", "Lio/docops/docopsextensionssupport/badge/FormBadge;", "servletResponse", "Ljakarta/servlet/http/HttpServletResponse;", "getBadgeParams", "getXY", "", "originalSvg", "makeBadgeAndSource", "txt", "svg", "textBox", "text", "textLen", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nBadgeController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BadgeController.kt\nio/docops/docopsextensionssupport/badge/BadgeController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,356:1\n1855#2,2:357\n*S KotlinDebug\n*F\n+ 1 BadgeController.kt\nio/docops/docopsextensionssupport/badge/BadgeController\n*L\n218#1:357,2\n*E\n"})
public class BadgeController {
    @NotNull
    private final DocOpsBadgeGenerator docOpsBadgeGenerator;

    @Autowired
    public BadgeController(@NotNull DocOpsBadgeGenerator docOpsBadgeGenerator) {
        Intrinsics.checkNotNullParameter((Object)docOpsBadgeGenerator, (String)"docOpsBadgeGenerator");
        this.docOpsBadgeGenerator = docOpsBadgeGenerator;
    }

    @PutMapping(value={"/badge/item"}, produces={"image/svg+xml"})
    @ResponseBody
    @Counted(value="docops.badge.put", description="Number of times create a badge using put method")
    @Timed(value="docops.badge.put", percentiles={0.5, 0.9}, description="Time taken to create a badge using put method")
    public void getBadgeByForm(@RequestBody @NotNull FormBadge badge, @NotNull HttpServletResponse servletResponse) {
        Intrinsics.checkNotNullParameter((Object)badge, (String)"badge");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        String fillColor = badge.getMessageColor();
        if (fillColor == null) {
            fillColor = "GREEN";
        }
        String logo = "";
        if (badge.getLogo() != null) {
            logo = badge.getLogo();
        }
        String string = badge.getLabel();
        String string2 = badge.getMessage();
        String string3 = badge.getLabelColor();
        Intrinsics.checkNotNull((Object)string3);
        String string4 = badge.getMessageColor();
        Intrinsics.checkNotNull((Object)string4);
        String string5 = badge.getFontColor();
        Intrinsics.checkNotNull((Object)string5);
        String svg = this.docOpsBadgeGenerator.createBadge(string, string2, string3, string4, "", logo, string5);
        String badgeSource = StringsKt.trimIndent((String)("\n[badge]\n----\n" + badge.getLabel() + "|" + badge.getMessage() + "|" + badge.getUrl() + "|" + badge.getLabelColor() + "|" + fillColor + "|" + badge.getLogo() + "|" + badge.getFontColor() + "|\n----\n"));
        String contents = this.makeBadgeAndSource(badgeSource, svg);
        servletResponse.setContentType("text/html");
        servletResponse.setCharacterEncoding("UTF-8");
        servletResponse.setStatus(200);
        PrintWriter writer = servletResponse.getWriter();
        writer.print(contents);
        writer.flush();
    }

    @NotNull
    public String makeBadgeAndSource(@NotNull String txt, @NotNull String svg) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        Intrinsics.checkNotNullParameter((Object)svg, (String)"svg");
        return StringsKt.trimIndent((String)("\n        <div id='imageblock'>\n        " + svg + "\n        </div>\n        <br/>\n        <h3>Badge Source</h3>\n        <div class='pure-u-1 pure-u-md-20-24'>\n        <pre>\n        <code class=\"asciidoc\">\n" + txt + "\n        </code>\n        </pre>\n        <script>\n        var badgeSource = `" + txt + "`;\n        </script>\n        </div>\n    "));
    }

    @GetMapping(value={"/text/{text}"})
    @ResponseBody
    public float textLen(@PathVariable(required=true) @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return DocOpsBadgeGenerator.measureText$default((DocOpsBadgeGenerator)this.docOpsBadgeGenerator, (String)text, (int)0, (int)2, null) * 100.0f;
    }

    @GetMapping(value={"/text/box/{text}"}, produces={"image/svg+xml"})
    @ResponseBody
    @NotNull
    public String textBox(@PathVariable(required=true) @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        float len = DocOpsBadgeGenerator.measureText$default((DocOpsBadgeGenerator)this.docOpsBadgeGenerator, (String)text, (int)0, (int)2, null) * 100.0f + (float)10;
        String svg = StringsKt.trimIndent((String)("\n            <svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + len + "\" height=\"120\"\n     viewBox=\"0 0 " + len + " 120\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n     <defs>\n     <filter id=\"filter\">\n            <feMorphology in=\"SourceAlpha\" operator=\"dilate\" radius=\"2\" result=\"OUTLINE\"/>\n            <feComposite operator=\"out\" in=\"OUTLINE\" in2=\"SourceAlpha\"/>\n        </filter>\n        <style>\n            .filtered {\n                filter: url(#filter);\n                fill: black;\n                font-family: 'Ultra', serif;\n                font-size: 100px;\n            }\n        </style>\n     </defs>\n     <g transform=\"translate(0,0)\" cursor=\"pointer\" font-family=\"Arial,DejaVu Sans,sans-serif\" font-size=\"110\">\n        <rect x=\"0\" y=\"0\" width=\"" + len + "\" height=\"110\" fill=\"#000000\" rx=\"18\" ry=\"18\" stroke=\"green\" stroke-width=\"5\"/>\n        <text text-anchor=\"middle\" fill=\"#ffffff\" x=\"" + len / (float)2 + "\" y=\"90\"   textLength=\"" + (len - (float)10) + "\">" + text + "</text>\n    </g>\n     </svg>\n        "));
        return svg;
    }

    @GetMapping(value={"/badge/item"}, produces={"image/svg+xml", "image/png"})
    @Counted(value="docops.badge.get", description="Number of times create a badge using get method")
    @Timed(value="docops.badge.get", percentiles={0.5, 0.9}, description="Time taken to create a badge using get method")
    @NotNull
    public ResponseEntity<byte[]> getBadgeParams(@RequestParam(name="payload") @NotNull String payload, @RequestParam(name="type", required=false, defaultValue="SVG") @NotNull String type, @NotNull HttpServletResponse servletResponse) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)servletResponse, (String)"servletResponse");
        String string = URLDecoder.decode(payload, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        String data = PanelGeneratorKt.uncompressString((String)string);
        String[] stringArray = new String[]{"|"};
        List split = StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (split.size() < 6) {
            System.out.println((Object)data);
            throw new BadgeFormatException("Badge Format invalid, expecting 5 pipe delimited values [" + data + "]");
        }
        String message = (String)split.get(1);
        String label = (String)split.get(0);
        String mcolor = "GREEN";
        String color = ((Object)StringsKt.trim((CharSequence)((String)split.get(3)))).toString();
        String c = ((Object)StringsKt.trim((CharSequence)((String)split.get(4)))).toString();
        if (((CharSequence)c).length() > 0) {
            mcolor = c;
        }
        String logo = "";
        if (Intrinsics.areEqual((Object)"SVG", (Object)type)) {
            logo = ((Object)StringsKt.trim((CharSequence)((String)split.get(5)))).toString();
        }
        String fontColor = "#ffffff";
        if (split.size() == 7) {
            fontColor = (String)split.get(6);
        }
        String output = this.docOpsBadgeGenerator.createBadge(label, message, color, mcolor, (String)split.get(1), logo, fontColor);
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(new MediaType("image", "svg+xml", StandardCharsets.UTF_8));
        if (Intrinsics.areEqual((Object)"SVG", (Object)type)) {
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(new MediaType("image", "svg+xml", StandardCharsets.UTF_8));
            String string2 = output;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            responseEntity = new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        } else {
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(MediaType.IMAGE_PNG);
            Pair res = BadgeControllerKt.findHeightWidth((String)output);
            byte[] baos = new SvgToPng().toPngFromSvg(output, res);
            responseEntity = new ResponseEntity((Object)baos, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        return responseEntity;
    }

    @PostMapping(value={"/badges"}, consumes={"*/*"}, produces={"image/svg+xml", "image/png"})
    @Timed(value="docops.badges.post")
    @NotNull
    public ResponseEntity<byte[]> badges(@RequestBody @NotNull String payload, @RequestParam(name="type", required=false, defaultValue="SVG") @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String data = URLDecoder.decode(payload, "UTF-8");
        List lines = new ArrayList();
        float x = 0.0f;
        float y = 0.0f;
        float buffer = 5.0f;
        StringBuilder str = new StringBuilder();
        int count = 0;
        Intrinsics.checkNotNull((Object)data);
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)data);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"|"};
            List split = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String link = "";
            if (split.size() > 2) {
                link = (String)split.get(2);
            }
            if (split.size() != 6) {
                throw new BadgeFormatException("Badge Format invalid, expecting 5 pipe delimited values [" + data + "]");
            }
            String message = (String)split.get(1);
            String label = (String)split.get(0);
            String mcolor = "GREEN";
            String color = ((Object)StringsKt.trim((CharSequence)((String)split.get(3)))).toString();
            String c = ((Object)StringsKt.trim((CharSequence)((String)split.get(4)))).toString();
            if (((CharSequence)c).length() > 0) {
                mcolor = c;
            }
            String logo = "";
            if (Intrinsics.areEqual((Object)"SVG", (Object)type)) {
                logo = ((Object)StringsKt.trim((CharSequence)((String)split.get(5)))).toString();
            }
            String output = DocOpsBadgeGenerator.createBadge$default((DocOpsBadgeGenerator)this.docOpsBadgeGenerator, (String)label, (String)message, (String)color, (String)mcolor, null, null, null, (int)112, null);
            output = StringsKt.replace$default((String)output, (String)"id='m'", (String)("id='m" + count + "'"), (boolean)false, (int)4, null);
            int n = count;
            count = n + 1;
            output = StringsKt.replace$default((String)output, (String)"url(#m4)", (String)("url(#m" + n + ")"), (boolean)false, (int)4, null);
            str.append(StringsKt.trimMargin$default((String)("<g transform=\"translate(" + x + ", " + y + ")\">\n                " + output + "\n                </g>\n            "), null, (int)1, null));
            x += buffer + this.getXY(output);
        }
        String output = StringsKt.trimIndent((String)("\n            <svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + x + "\" height=\"20\">\n            " + str + "\n            </svg>\n        "));
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(new MediaType("image", "svg+xml", StandardCharsets.UTF_8));
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(new MediaType("image", "svg+xml", StandardCharsets.UTF_8));
        String string = output;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    public float getXY(@NotNull String originalSvg) {
        Intrinsics.checkNotNullParameter((Object)originalSvg, (String)"originalSvg");
        Pair hw = BadgeControllerKt.findHeightWidth((String)originalSvg);
        return Float.parseFloat((String)hw.getSecond());
    }
}

