/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.button;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.docops.docopsextensionssupport.button.ButtonController;
import io.docops.docopsextensionssupport.button.ButtonDisplay;
import io.docops.docopsextensionssupport.button.Buttons;
import io.docops.docopsextensionssupport.button.shape.ButtonShape;
import io.docops.docopsextensionssupport.svgsupport.SvgToPng;
import io.docops.docopsextensionssupport.web.panel.PanelGeneratorKt;
import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u0017\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0012J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017J\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\f2\b\b\u0001\u0010\u0018\u001a\u00020\fH\u0017J\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\fH\u0017J \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0017\u001a\u00020\f2\b\u0010\u0018\u001a\u0004\u0018\u00010\fH\u0012J,\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\fH\u0017J,\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\f2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\fH\u0017J\"\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\b\b\u0001\u0010\u0017\u001a\u00020\f2\b\b\u0001\u0010\u0018\u001a\u00020\fH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/docops/docopsextensionssupport/button/ButtonController;", "", "applicationContext", "Lorg/springframework/context/ApplicationContext;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "(Lorg/springframework/context/ApplicationContext;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "themeMap", "", "", "createResponse", "Lorg/springframework/http/ResponseEntity;", "", "buttons", "Lio/docops/docopsextensionssupport/button/Buttons;", "useDark", "", "type", "fromJsonToButton", "fromJsonToButtonForm", "payload", "theme", "fromJsonToButtonFormPng", "fromRequestParameter", "getButtons", "getButtonsPng", "themeItem", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nButtonController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ButtonController.kt\nio/docops/docopsextensionssupport/button/ButtonController\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n+ 5 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,296:1\n13309#2,2:297\n79#3,5:299\n113#3,7:304\n79#3,5:312\n113#3,7:317\n79#3,5:324\n113#3,6:329\n119#3:336\n79#3,5:337\n113#3,6:342\n119#3:349\n79#3,5:351\n113#3,7:356\n79#3,5:363\n113#3,6:368\n119#3:377\n96#4:311\n96#4:335\n96#4:348\n96#4:350\n96#4:374\n96#4:375\n113#5:376\n*S KotlinDebug\n*F\n+ 1 ButtonController.kt\nio/docops/docopsextensionssupport/button/ButtonController\n*L\n49#1:297,2\n66#1:299,5\n66#1:304,7\n137#1:312,5\n137#1:317,7\n168#1:324,5\n168#1:329,6\n168#1:336\n202#1:337,5\n202#1:342,6\n202#1:349\n244#1:351,5\n244#1:356,7\n276#1:363,5\n276#1:368,6\n276#1:377\n94#1:311\n170#1:335\n204#1:348\n236#1:350\n277#1:374\n279#1:375\n288#1:376\n*E\n"})
public class ButtonController {
    @NotNull
    private final ApplicationContext applicationContext;
    @NotNull
    private final ObjectMapper objectMapper;
    private final Logger log;
    @NotNull
    private final Map<String, String> themeMap;

    @Autowired
    public ButtonController(@NotNull ApplicationContext applicationContext, @NotNull ObjectMapper objectMapper) {
        Resource[] themeList;
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        this.applicationContext = applicationContext;
        this.objectMapper = objectMapper;
        this.log = LoggerFactory.getLogger(ButtonController.class);
        this.themeMap = new LinkedHashMap();
        Resource[] resourceArray = this.applicationContext.getResources("classpath:static/buttondisplay/*.json");
        Intrinsics.checkNotNullExpressionValue((Object)resourceArray, (String)"getResources(...)");
        Resource[] themes = themeList = resourceArray;
        boolean bl = false;
        Resource[] $this$forEach$iv = themes;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String string;
            String string2;
            Resource element$iv;
            Resource it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            Map map = this.themeMap;
            Intrinsics.checkNotNull((Object)it.getFilename());
            Intrinsics.checkNotNullExpressionValue((Object)it.getContentAsString(Charset.defaultCharset()), (String)"getContentAsString(...)");
            map.put(string2, string);
        }
    }

    @Timed(value="docops.button.put.fromJsonToButtonForm.time", percentiles={0.5, 0.9}, description="Creating a Button using Form Submission")
    @Counted(value="docops.button.put.fromJsonToButtonForm.count", description="Success Fail count of fromJsonToButtonForm")
    @PutMapping(value={"/buttons/form"})
    @ResponseBody
    @NotNull
    public ResponseEntity<byte[]> fromJsonToButtonForm(@RequestParam(name="payload") @NotNull String payload, @RequestParam(name="theme", required=false) @NotNull String theme) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        ResponseEntity result$iv$iv = this.fromRequestParameter(payload, theme);
        TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.log.info("fromJsonToButtonForm executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms ");
        return (ResponseEntity)timing2.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private ResponseEntity<byte[]> fromRequestParameter(String payload, String theme) {
        try {
            void this_$iv;
            String it;
            String newPayload = null;
            newPayload = "{}";
            String themeStr = null;
            themeStr = "";
            String string = theme;
            if (string != null) {
                it = string;
                boolean bl = false;
                if (((CharSequence)it).length() > 0) {
                    Object v = this.themeMap.get(theme);
                    Intrinsics.checkNotNull(v);
                    themeStr = v;
                    Map themeNode2 = (Map)this.objectMapper.readValue(themeStr, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    Map payloadNode2 = (Map)this.objectMapper.readValue(payload, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    payloadNode2.replace("theme", themeNode2);
                    String string2 = this.objectMapper.writeValueAsString((Object)payloadNode2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"writeValueAsString(...)");
                    newPayload = string2;
                } else {
                    newPayload = payload;
                }
            }
            it = (Json)Json.Default;
            String string$iv = newPayload;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            Buttons buttons = (Buttons)this_$iv.decodeFromString((DeserializationStrategy)Buttons.Companion.serializer(), string$iv);
            buttons.setUseDark(true);
            ButtonShape buttonShape = buttons.createSVGShape();
            String imgSrc = buttonShape.drawShape("SVG");
            String div = StringsKt.trimIndent((String)("\n                <div id='imageblock'>\n                " + imgSrc + "\n                </div>\n                <div id=\"themeBox\"  data-hx-swap-oob=\"true\">" + themeStr + "</div>\n            "));
            HttpHeaders headers = new HttpHeaders();
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(new MediaType("image", "svg+xml", StandardCharsets.UTF_8));
            String string3 = div;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string3.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    private ResponseEntity<byte[]> createResponse(Buttons buttons, boolean useDark, String type) {
        buttons.setUseDark(useDark);
        ButtonShape buttonShape = buttons.createSVGShape();
        String imgSrc = buttonShape.drawShape(type);
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(new MediaType("image", "svg+xml", StandardCharsets.UTF_8));
        String string = imgSrc;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
    }

    @Timed(value="Docops.ButtonController.put.fromJsonToButton.time", description="Creating a Button using Form Submission JSON")
    @Counted(value="Docops.ButtonController.put.fromJsonToButton.count", description="Success Fail count of fromJsonToButton")
    @PutMapping(value={"/buttons"})
    @ResponseBody
    @NotNull
    public ResponseEntity<byte[]> fromJsonToButton(@RequestBody @NotNull Buttons buttons) {
        Intrinsics.checkNotNullParameter((Object)buttons, (String)"buttons");
        try {
            boolean $i$f$measureTimedValue = false;
            TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            ResponseEntity result$iv$iv = this.createResponse(buttons, true, "SVG");
            TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
            this.log.info("fromJsonToButton executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms ");
            return (ResponseEntity)timing2.getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Timed(value="docops.button.get.getButtons.time", percentiles={0.5, 0.9}, description="Creating a Button using http get")
    @Counted(value="docops.button.get.getButtons.count", description="Success Fail count of getButtons")
    @GetMapping(value={"/buttons"})
    @ResponseBody
    @NotNull
    public ResponseEntity<byte[]> getButtons(@RequestParam(name="payload") @NotNull String payload, @RequestParam(name="useDark", defaultValue="false") boolean useDark, @RequestParam(name="type", defaultValue="SVG") @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String data = null;
        data = "";
        try {
            void this_$iv;
            boolean $i$f$measureTimedValue = false;
            TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            String string = URLDecoder.decode(payload, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
            data = PanelGeneratorKt.uncompressString((String)string);
            Json json = (Json)Json.Default;
            String string$iv = data;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            Buttons content = (Buttons)this_$iv.decodeFromString((DeserializationStrategy)Buttons.Companion.serializer(), string$iv);
            ResponseEntity result$iv$iv = this.createResponse(content, useDark, type);
            TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
            this.log.info("getButtons executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms ");
            return (ResponseEntity)timing2.getValue();
        }
        catch (Exception e) {
            this.log.info("Data received after uncompressed: -> " + data);
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Timed(value="docops.button.get.getButtonsPng.time", description="Creating a Button as PNG using http get")
    @Counted(value="docops.button.get.getButtonsPng.count", description="Success Fail count of getButtonsPng")
    @GetMapping(value={"/buttons/png"})
    @ResponseBody
    @NotNull
    public ResponseEntity<byte[]> getButtonsPng(@RequestParam(name="payload") @NotNull String payload, @RequestParam(name="useDark", defaultValue="false") boolean useDark, @RequestParam(name="type", defaultValue="PDF") @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String data = null;
        data = "";
        try {
            void this_$iv;
            boolean $i$f$measureTimedValue = false;
            TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            String string = URLDecoder.decode(payload, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
            data = PanelGeneratorKt.uncompressString((String)string);
            Json json = (Json)Json.Default;
            String string$iv = data;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            Buttons buttons = (Buttons)this_$iv.decodeFromString((DeserializationStrategy)Buttons.Companion.serializer(), string$iv);
            ButtonShape buttonShape = buttons.createSVGShape();
            buttons.setUseDark(true);
            String imgSrc = buttonShape.drawShape("PDF");
            HttpHeaders headers = new HttpHeaders();
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(new MediaType("image", "png", StandardCharsets.UTF_8));
            byte[] png = new SvgToPng().toPngFromSvg(imgSrc, new Pair((Object)String.valueOf(buttonShape.height()), (Object)String.valueOf(buttonShape.width())));
            ResponseEntity result$iv$iv = new ResponseEntity((Object)png, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
            TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
            this.log.info("getButtonsPng executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms ");
            return (ResponseEntity)timing2.getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Timed(value="docops.button.put.fromJsonToButtonFormPng.time", description="Creating a Button as PNG using http put")
    @Counted(value="docops.button.put.fromJsonToButtonFormPng.count", description="Success Fail count of fromJsonToButtonFormPng")
    @PutMapping(value={"/buttons/form/png"})
    @ResponseBody
    @NotNull
    public ResponseEntity<String> fromJsonToButtonFormPng(@RequestParam(name="payload") @NotNull String payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        Buttons buttons = (Buttons)this_$iv.decodeFromString((DeserializationStrategy)Buttons.Companion.serializer(), payload);
        buttons.setUseDark(true);
        ButtonShape buttonShape = buttons.createSVGShape();
        String imgSrc = buttonShape.drawShape("PDF");
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(new MediaType("image", "png", StandardCharsets.UTF_8));
        try {
            boolean $i$f$measureTimedValue = false;
            TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            byte[] png = new SvgToPng().toPngFromSvg(imgSrc, new Pair((Object)String.valueOf(buttonShape.height()), (Object)String.valueOf(buttonShape.width())));
            String str = StringsKt.trimIndent((String)("\n                <div>\n                <img src=\"data:image/png;base64," + Base64.getEncoder().encodeToString(png) + "\" alt=\"image from button\"/>\n                </div>\n            "));
            ResponseEntity result$iv$iv = new ResponseEntity((Object)str, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
            TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
            this.log.info("fromJsonToButtonFormPng executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms ");
            return (ResponseEntity)timing2.getValue();
        }
        catch (Exception e) {
            System.out.println((Object)imgSrc);
            throw e;
        }
    }

    @Timed(value="docops.button.put.themeItem.time", description="Updating button theme using http put")
    @Counted(value="docops.button.put.themeItem.count", description="Success Fail count of themeItem")
    @PutMapping(value={"button/theme"})
    @NotNull
    public ResponseEntity<String> themeItem(@RequestParam(name="payload") @NotNull String payload, @RequestParam(name="theme") @NotNull String theme) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        Buttons buttons = (Buttons)this_$iv.decodeFromString((DeserializationStrategy)Buttons.Companion.serializer(), payload);
        buttons.setUseDark(true);
        this_$iv = (Json)Json.Default;
        Object v = this.themeMap.get(theme);
        Intrinsics.checkNotNull(v);
        String string$iv = (String)v;
        boolean $i$f$decodeFromString2 = false;
        this_$iv.getSerializersModule();
        buttons.setTheme((ButtonDisplay)this_$iv.decodeFromString((DeserializationStrategy)BuiltinSerializersKt.getNullable((KSerializer)ButtonDisplay.Companion.serializer()), string$iv));
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(MediaType.APPLICATION_JSON);
        Json prettyJson2 = JsonKt.Json$default(null, (Function1)((Function1)themeItem.timing.1.prettyJson.1.INSTANCE), (int)1, null);
        StringFormat $this$encodeToString$iv = (StringFormat)prettyJson2;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        String json = $this$encodeToString$iv.encodeToString((SerializationStrategy)Buttons.Companion.serializer(), (Object)buttons);
        ResponseEntity result$iv$iv = new ResponseEntity((Object)json, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.log.info("themItem executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms ");
        return (ResponseEntity)timing2.getValue();
    }
}

