/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.button;

import java.awt.Color;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u000bH\u0002\u001a\u0018\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"buildGradientDef", "", "color", "id", "getResourceFromUrl", "url", "gradientFromColor", "", "randomColor", "", "shade", "Ljava/awt/Color;", "tint", "factor", "", "docops-extension-server"})
public final class ButtonKt {
    @NotNull
    public static final String buildGradientDef(@NotNull String color, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Map m = ButtonKt.gradientFromColor((String)color);
        return "\n           <linearGradient id=\"btn_" + id + "\" x2=\"1\" y2=\"1\">\n            <stop class=\"stop1\" offset=\"0%\" stop-color=\"" + m.get("color1") + "\"/>\n            <stop class=\"stop2\" offset=\"50%\" stop-color=\"" + m.get("color2") + "\"/>\n            <stop class=\"stop3\" offset=\"100%\" stop-color=\"" + m.get("color3") + "\"/>\n            </linearGradient> \n        ";
    }

    @NotNull
    public static final String getResourceFromUrl(@NotNull String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.ofSeconds(20L)).build();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).timeout(Duration.ofMinutes(1L)).build();
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            string = response.body();
            Intrinsics.checkNotNull((Object)string);
        }
        catch (Exception e) {
            e.printStackTrace();
            string = "";
        }
        return string;
    }

    @NotNull
    public static final Map<String, String> gradientFromColor(@NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Color decoded = Color.decode(color);
        Intrinsics.checkNotNull((Object)decoded);
        String tinted1 = ButtonKt.tint((Color)decoded, (double)0.5);
        String tinted2 = ButtonKt.tint((Color)decoded, (double)0.25);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"color1", (Object)tinted1), TuplesKt.to((Object)"color2", (Object)tinted2), TuplesKt.to((Object)"color3", (Object)color)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private static final String shade(Color color) {
        double rs = (double)color.getRed() * 0.5;
        double gs = (double)color.getGreen() * 0.5;
        double bs = (double)color.getBlue() * 0.5;
        String string = Integer.toString((int)rs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = Integer.toString((int)gs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = Integer.toString((int)bs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return "#" + string + string2 + string3;
    }

    private static final String tint(Color color, double factor) {
        double rs = (double)color.getRed() + factor * (double)(255 - color.getRed());
        double gs = (double)color.getGreen() + factor * (double)(255 - color.getGreen());
        double bs = (double)color.getBlue() + factor * (double)(255 - color.getBlue());
        String string = Integer.toString((int)rs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = Integer.toString((int)gs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = Integer.toString((int)bs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return "#" + string + string2 + string3;
    }

    public static final void randomColor() {
        int color = (int)(Math.random() * (double)0xFFFFFF) | 0xFF000000;
    }
}

