/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.diagram;

import io.docops.docopsextensionssupport.diagram.ConnectorMaker;
import io.docops.docopsextensionssupport.diagram.Connectors;
import io.docops.docopsextensionssupport.web.panel.PanelGeneratorKt;
import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/connector"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J@\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\b\b\u0001\u0010\u0010\u001a\u00020\u00072\b\b\u0001\u0010\t\u001a\u00020\u00072\b\b\u0001\u0010\u0011\u001a\u00020\u00072\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u0012\u001a\u00020\u0007H\u0017J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/docops/docopsextensionssupport/diagram/BoxyController;", "", "()V", "log", "Lorg/apache/commons/logging/Log;", "kotlin.jvm.PlatformType", "fromRequestToConnector", "", "contents", "scale", "", "useDark", "", "getConnector", "Lorg/springframework/http/ResponseEntity;", "", "payload", "type", "outlineColor", "makeDiag", "httpServletRequest", "Ljakarta/servlet/http/HttpServletRequest;", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nBoxyController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoxyController.kt\nio/docops/docopsextensionssupport/diagram/BoxyController\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,155:1\n79#2,5:156\n113#2,7:161\n79#2,5:169\n113#2,7:174\n96#3:168\n*S KotlinDebug\n*F\n+ 1 BoxyController.kt\nio/docops/docopsextensionssupport/diagram/BoxyController\n*L\n62#1:156,5\n62#1:161,7\n142#1:169,5\n142#1:174,7\n117#1:168\n*E\n"})
public class BoxyController {
    private final Log log = LogFactory.getLog(BoxyController.class);

    @PutMapping(value={"/"})
    @ResponseBody
    @Counted(value="docops.boxy.put")
    @Timed(value="docops.boxy.put", percentiles={0.5, 0.9}, description="Creating a Button using http put")
    @NotNull
    public ResponseEntity<byte[]> makeDiag(@NotNull HttpServletRequest httpServletRequest) {
        Intrinsics.checkNotNullParameter((Object)httpServletRequest, (String)"httpServletRequest");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        String contents = httpServletRequest.getParameter("content");
        String title = "title";
        CharSequence charSequence = contents;
        if (charSequence == null || charSequence.length() == 0) {
            contents = StreamUtils.copyToString((InputStream)((InputStream)httpServletRequest.getInputStream()), (Charset)Charset.defaultCharset());
            String string = httpServletRequest.getParameter("title");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParameter(...)");
            title = string;
        }
        String scale = httpServletRequest.getParameter("scale");
        String useDarkInput = httpServletRequest.getParameter("useDark");
        String string = contents;
        Intrinsics.checkNotNull((Object)string);
        Intrinsics.checkNotNull((Object)scale);
        String svg = this.fromRequestToConnector(string, Float.parseFloat(scale), Intrinsics.areEqual((Object)"on", (Object)useDarkInput));
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(MediaType.parseMediaType((String)"text/html"));
        String div = StringsKt.trimIndent((String)("\n        <div class=\"collapse collapse-arrow border-base-300\">\n            <input type=\"radio\" name=\"my-accordion-2\" checked=\"checked\" />\n            <div class=\"collapse-title text-xl font-small\">\n                Image\n            </div>\n            <div class=\"collapse-content\">\n                <div id='imageblock'>\n                " + svg + "\n                </div>\n            </div>\n        </div>\n        <div class=\"collapse collapse-arrow border-base-300\">\n            <input type=\"radio\" name=\"my-accordion-2\" />\n            <div class=\"collapse-title text-xl font-small\">\n                Click to View Source\n            </div>\n            <div class=\"collapse-content\">\n                <h3>Adr Source</h3>\n                <div>\n                <pre>\n                <code class=\"kotlin\">\n                 " + contents + "\n                </code>\n                </pre>\n                </div>\n                <script>\n                var adrSource = `[diag,scale=\"0.7\",role=\"center\"]\\n----\\n" + contents + "\\n----`;\n                document.querySelectorAll('pre code').forEach((el) => {\n                    hljs.highlightElement(el);\n                });\n                </script>\n            </div>\n        </div>\n        "));
        byte[] byArray = div.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ResponseEntity result$iv$iv = new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        TimedValue timings = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.log.info((Object)("makeDiag executed in " + Duration.getInWholeMilliseconds-impl((long)timings.getDuration-UwyO8pc()) + "ms "));
        return (ResponseEntity)timings.getValue();
    }

    @NotNull
    public String fromRequestToConnector(@NotNull String contents, float scale, boolean useDark) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        Connectors connectors = (Connectors)this_$iv.decodeFromString((DeserializationStrategy)Connectors.Companion.serializer(), contents);
        ConnectorMaker maker = new ConnectorMaker(connectors.getConnectors(), useDark);
        String svg = maker.makeConnectorImage(scale);
        return svg;
    }

    @GetMapping(value={"/"})
    @ResponseBody
    @Timed(value="docops.connector.get", percentiles={0.5, 0.9}, description="Creating a connector diagram using http get")
    @NotNull
    public ResponseEntity<byte[]> getConnector(@RequestParam(name="payload") @NotNull String payload, @RequestParam(name="scale", defaultValue="1.0") @NotNull String scale, @RequestParam(value="type", required=false, defaultValue="SVG") @NotNull String type, @RequestParam(name="useDark", defaultValue="false") boolean useDark, @RequestParam(name="outlineColor", defaultValue="#37cdbe") @NotNull String outlineColor) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)outlineColor, (String)"outlineColor");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        String string = URLDecoder.decode(payload, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        String data = PanelGeneratorKt.uncompressString((String)string);
        String svg = this.fromRequestToConnector(data, Float.parseFloat(scale), useDark);
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(MediaType.parseMediaType((String)"image/svg+xml"));
        byte[] byArray = svg.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ResponseEntity result$iv$iv = new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.log.info((Object)("getConnector executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms "));
        return (ResponseEntity)timing2.getValue();
    }
}

