/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.diagram;

import io.docops.docopsextensionssupport.diagram.Connector;
import io.docops.docopsextensionssupport.support.ColorUtilKt;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.CharRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u000bH\u0002J\"\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\b\u0002\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\b\b\u0002\u0010\u0017\u001a\u00020\u0015J\b\u0010\u001a\u001a\u00020\u000bH\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lio/docops/docopsextensionssupport/diagram/ConnectorMaker;", "", "connectors", "", "Lio/docops/docopsextensionssupport/diagram/Connector;", "useDark", "", "(Ljava/util/List;Z)V", "alphabets", "", "baseColors", "", "bgColor", "colors", "getConnectors", "()Ljava/util/List;", "getUseDark", "()Z", "defs", "head", "height", "", "width", "scale", "makeBody", "makeConnectorImage", "tail", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nConnectorMaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectorMaker.kt\nio/docops/docopsextensionssupport/diagram/ConnectorMaker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n1864#2,2:188\n1864#2,3:190\n1866#2:193\n*S KotlinDebug\n*F\n+ 1 ConnectorMaker.kt\nio/docops/docopsextensionssupport/diagram/ConnectorMaker\n*L\n134#1:188,2\n138#1:190,3\n134#1:193\n*E\n"})
public final class ConnectorMaker {
    @NotNull
    private final List<Connector> connectors;
    private final boolean useDark;
    @NotNull
    private final List<Character> alphabets;
    @NotNull
    private final List<String> colors;
    @NotNull
    private String bgColor;
    @NotNull
    private final List<String> baseColors;

    public ConnectorMaker(@NotNull List<Connector> connectors, boolean useDark) {
        Intrinsics.checkNotNullParameter(connectors, (String)"connectors");
        this.connectors = connectors;
        this.useDark = useDark;
        this.alphabets = CollectionsKt.toMutableList((Iterable)((Iterable)new CharRange('A', 'Z')));
        this.colors = new ArrayList();
        this.bgColor = "#fcfcfc";
        Object[] objectArray = new String[]{"#E14D2A", "#82CD47", "#687EFF", "#C02739", "#FEC260", "#e9d3ff", "#7fc0b7"};
        this.baseColors = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public /* synthetic */ ConnectorMaker(List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(list, bl);
    }

    @NotNull
    public final List<Connector> getConnectors() {
        return this.connectors;
    }

    public final boolean getUseDark() {
        return this.useDark;
    }

    @NotNull
    public final String makeConnectorImage(float scale) {
        if (this.useDark) {
            this.bgColor = "#111111";
        }
        StringBuilder sb = new StringBuilder();
        float width = (float)(this.connectors.size() * 250) + (float)(this.connectors.size() * 46);
        sb.append(this.head(110.0f, width, scale));
        sb.append(this.defs());
        sb.append("<g>");
        sb.append("<rect width=\"100%\" height=\"100%\" fill=\"" + this.bgColor + "\"/>");
        sb.append(this.makeBody());
        sb.append("</g>");
        sb.append(this.tail());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String makeConnectorImage$default(ConnectorMaker connectorMaker, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = 1.0f;
        }
        return connectorMaker.makeConnectorImage(f);
    }

    private final String head(float height, float width, float scale) {
        return StringsKt.trimIndent((String)("\n        <svg xmlns=\"http://www.w3.org/2000/svg\" width=\"" + width * scale + "\" height=\"" + height * scale + "\"\n     viewBox=\"0 0 " + width + " " + height + "\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"diag\">\n    "));
    }

    static /* synthetic */ String head$default(ConnectorMaker connectorMaker, float f, float f2, float f3, int n, Object object) {
        if ((n & 4) != 0) {
            f3 = 1.0f;
        }
        return connectorMaker.head(f, f2, f3);
    }

    private final String tail() {
        return "</svg>";
    }

    private final String defs() {
        StringBuilder grad = new StringBuilder();
        int i = 0;
        int n = this.connectors.size();
        if (i <= n) {
            while (true) {
                String choiceColor = "";
                choiceColor = i > 6 ? ColorUtilKt.getRandomColorHex() : (String)this.baseColors.get(i);
                this.colors.add(choiceColor);
                Map gradient = ColorUtilKt.gradientFromColor((String)choiceColor);
                grad.append(StringsKt.trimIndent((String)("\n           <linearGradient id=\"grad" + i + "\" x2=\"0%\" y2=\"100%\">\n            <stop class=\"stop1\" offset=\"0%\" stop-color=\"" + gradient.get("color1") + "\"/>\n            <stop class=\"stop2\" offset=\"50%\" stop-color=\"" + gradient.get("color2") + "\"/>\n            <stop class=\"stop3\" offset=\"100%\" stop-color=\"" + gradient.get("color3") + "\"/>\n            </linearGradient> \n            ")));
                if (i == n) break;
                ++i;
            }
        }
        return StringsKt.trimIndent((String)("\n            <defs>\n            " + grad + "\n        <filter id=\"filter\">\n            <feMorphology in=\"SourceAlpha\" operator=\"dilate\" radius=\"2\" result=\"OUTLINE\"/>\n            <feComposite operator=\"out\" in=\"OUTLINE\" in2=\"SourceAlpha\"/>\n        </filter>\n        <filter id=\"poly\" x=\"0\" y=\"0\" width=\"200%\" height=\"200%\">\n            <feOffset result=\"offOut\" in=\"SourceGraphic\" dx=\"10\" dy=\"15\" />\n            <feGaussianBlur result=\"blurOut\" in=\"offOut\" stdDeviation=\"5\" />\n            <feBlend in=\"SourceGraphic\" in2=\"blurOut\" mode=\"normal\" />\n        </filter>\n        <filter id=\"shadow2\">\n            <feDropShadow\n                    dx=\"-0.8\"\n                    dy=\"-0.8\"\n                    stdDeviation=\"0\"\n                    flood-color=\"pink\"\n                    flood-opacity=\"0.5\" />\n        </filter>\n        <style>\n            .shadowed {\n                -webkit-filter: drop-shadow( 3px 3px 2px rgba(0, 0, 0, .3));\n                filter: drop-shadow( 3px 3px 2px rgba(0, 0, 0, .3));\n            }\n            .filtered {\n                filter: url(#filter);\n                fill: black;\n                font-family: 'Ultra', serif;\n                font-size: 100px;\n\n            }\n            .filtered-small {\n                filter: url(#filter);\n                fill: black;\n                font-family: 'Ultra', serif;\n                font-size: 14px;\n\n            }\n\n            .glass:after,.glass:before{content:\"\";display:block;position:absolute}.glass{overflow:hidden;color:#fff;text-shadow:0\n            1px 2px rgba(0,0,0,.7);background-image:radial-gradient(circle at\n            center,rgba(0,167,225,.25),rgba(0,110,149,.5));box-shadow:0 5px 10px rgba(0,0,0,.75),inset 0 0 0 2px\n            rgba(0,0,0,.3),inset 0 -6px 6px -3px\n            rgba(0,129,174,.2);position:relative}.glass:after{background:rgba(0,167,225,.2);z-index:0;height:100%;width:100%;top:0;left:0;backdrop-filter:blur(3px)\n            saturate(400%);-webkit-backdrop-filter:blur(3px) saturate(400%)}.glass:before{width:calc(100% -\n            4px);height:35px;background-image:linear-gradient(rgba(255,255,255,.7),rgba(255,255,255,0));top:2px;left:2px;border-radius:30px\n            30px 200px 200px;opacity:.7}.glass:hover{text-shadow:0 1px 2px\n            rgba(0,0,0,.9)}.glass:hover:before{opacity:1}.glass:active{text-shadow:0 0 2px rgba(0,0,0,.9);box-shadow:0\n            3px 8px rgba(0,0,0,.75),inset 0 0 0 2px rgba(0,0,0,.3),inset 0 -6px 6px -3px\n            rgba(0,129,174,.2)}.glass:active:before{height:25px}\n\n            .boxText {\n                font-size:24px;\n                font-family: 'Inter var', system-ui, 'Helvetica Neue', Helvetica, Arial, sans-serif;\n                font-variant: small-caps;\n                font-weight: bold;\n            }\n        </style>\n        <polygon id=\"ppoint\" points=\"0,5 1.6666666666666667,2.5 0,0 5,2.5\" stroke-width=\"7\" />\n        <rect id=\"bbox\" class=\"shadowed\"  width=\"250\" height=\"90\" ry=\"18\" rx=\"18\"  />\n        <path id=\"hconnector\" d=\"M260,50.0 h34\" stroke-width=\"3\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n        <path id=\"vconnector\" d=\"M135,100 v34\" stroke-width=\"3\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n        <rect />\n        </defs>\n        "));
    }

    /*
     * WARNING - void declaration
     */
    private final String makeBody() {
        StringBuilder sb = new StringBuilder();
        int x = 0;
        Iterable $this$forEachIndexed$iv = this.connectors;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void conn;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Connector connector = (Connector)item$iv;
            int i = n;
            boolean bl = false;
            List lines = conn.textToLines();
            StringBuilder str = new StringBuilder("<text x=\"135\" y=\"" + conn.getStart() + "\" text-anchor=\"middle\" class=\"filtered glass boxText\">");
            Iterable $this$forEachIndexed$iv2 = lines;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void content;
                int n2;
                if ((n2 = index$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv2;
                int j = n2;
                boolean bl2 = false;
                String dy = "";
                if (j > 0) {
                    dy = "dy=\"24\"";
                }
                str.append("<tspan x=\"135\" " + dy + ">" + (String)content + "</tspan>");
            }
            str.append("</text>");
            if (i == CollectionsKt.getLastIndex((List)this.connectors)) {
                sb.append(StringsKt.trimIndent((String)("\n             <g transform=\"translate(" + x + ",0)\" >\n                <use href=\"#bbox\" x=\"10\" y=\"10\" fill=\"url(#grad" + i + ")\"/>\n                " + str + "\n            </g>\n                ")));
            } else {
                sb.append(StringsKt.trimIndent((String)("\n            <g transform=\"translate(" + x + ",0)\" >\n                <use href=\"#bbox\" x=\"10\" y=\"10\" fill=\"url(#grad" + i + ")\"/>\n                " + str + "\n                <use href=\"#hconnector\" stroke=\"" + this.colors.get(i) + "\" fill=\"url(#grad" + i + ")\"/>\n                <g transform=\"translate(297,47)\"><use href=\"#ppoint\" fill=\"url(#grad" + i + ")\" stroke-width=\"7\" stroke=\"url(#grad" + i + ")\"/></g>\n                <rect x=\"270\" y=\"13\" height=\"24\" width=\"24\" fill=\"url(#grad" + i + ")\" rx=\"5\" ry=\"5\"/>\n                <text x=\"282\" y=\"29\" fill=\"#111111\" text-anchor=\"middle\" class=\"filtered-small glass\">" + this.alphabets.get(i) + "</text>\n            </g>\n\n            ")));
            }
            x += 300;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

