/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.releasestrategy;

import freemarker.template.Template;
import io.docops.asciidoctorj.extension.adr.AdrBlockProcessorKt;
import io.docops.docopsextensionssupport.releasestrategy.Release;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseController;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseEnum;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseRoadMapMaker;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseStrategy;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseStrategyKt;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseTimelineGroupedMaker;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseTimelineMaker;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseTimelineSummaryMaker;
import io.docops.docopsextensionssupport.releasestrategy.SelectedStrategy;
import io.docops.docopsextensionssupport.web.panel.PanelGeneratorKt;
import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import io.micrometer.observation.annotation.Observed;
import jakarta.servlet.http.HttpServletRequest;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ProblemDetail;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.ErrorResponseException;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

/*
 * Exception performing whole class analysis ignored.
 */
@Controller
@RequestMapping(value={"/api/release"})
@Observed(name="release.controller")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u000bH\u0016J.\u0010\u0011\u001a\u00020\u000b2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010\u0014\u001a\u00020\u000b2\b\b\u0001\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0017J\u001a\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\r2\b\b\u0002\u0010\u001b\u001a\u00020\u000fH\u0012J\u001a\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0016J6\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\b\b\u0001\u0010 \u001a\u00020\u000b2\b\b\u0001\u0010!\u001a\u00020\u000b2\b\b\u0001\u0010\u0010\u001a\u00020\u000b2\b\b\u0001\u0010\"\u001a\u00020\u000fH\u0017J\u0016\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\u0006\u0010\u0016\u001a\u00020\u0017H\u0012J\u0018\u0010&\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0012J&\u0010'\u001a\u00020\u000b2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020\u000b2\b\b\u0001\u0010!\u001a\u00020\u000bH\u0017J&\u0010(\u001a\u00020\u000b2\b\b\u0001\u0010\u0012\u001a\u00020\u00132\b\b\u0001\u0010 \u001a\u00020\u000b2\b\b\u0001\u0010!\u001a\u00020\u000bH\u0017J\u0012\u0010)\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\rH\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lio/docops/docopsextensionssupport/releasestrategy/ReleaseController;", "", "freeMarkerConfigurer", "Lorg/springframework/web/servlet/view/freemarker/FreeMarkerConfigurer;", "(Lorg/springframework/web/servlet/view/freemarker/FreeMarkerConfigurer;)V", "getFreeMarkerConfigurer", "()Lorg/springframework/web/servlet/view/freemarker/FreeMarkerConfigurer;", "log", "Lorg/apache/commons/logging/Log;", "kotlin.jvm.PlatformType", "createRoadMap", "", "releaseStrategy", "Lio/docops/docopsextensionssupport/releasestrategy/ReleaseStrategy;", "isPdf", "", "animate", "createStrategy", "model", "Lorg/springframework/ui/ModelMap;", "title", "style", "servletRequest", "Ljakarta/servlet/http/HttpServletRequest;", "createTimelineGrouped", "createTimelineSummarySvg", "release", "pdf", "createTimelineSvg", "getRelease", "Lorg/springframework/http/ResponseEntity;", "", "payload", "type", "useDark", "getReleaseTypes", "", "Lio/docops/docopsextensionssupport/releasestrategy/Release;", "makeFilledView", "prefill", "prefillFromJson", "putStrategy", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nReleaseController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReleaseController.kt\nio/docops/docopsextensionssupport/releasestrategy/ReleaseController\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,290:1\n79#2,5:291\n113#2,6:296\n119#2:303\n79#2,5:304\n113#2,6:309\n119#2:316\n79#2,5:317\n113#2,6:322\n119#2:329\n79#2,5:330\n113#2,7:335\n79#2,5:342\n113#2,7:347\n96#3:302\n96#3:315\n96#3:328\n1855#4,2:354\n766#4:358\n857#4,2:359\n1855#4,2:361\n113#5:356\n113#5:357\n*S KotlinDebug\n*F\n+ 1 ReleaseController.kt\nio/docops/docopsextensionssupport/releasestrategy/ReleaseController\n*L\n71#1:291,5\n71#1:296,6\n71#1:303\n125#1:304,5\n125#1:309,6\n125#1:316\n147#1:317,5\n147#1:322,6\n147#1:329\n166#1:330,5\n166#1:335,7\n212#1:342,5\n212#1:347,7\n73#1:302\n127#1:315\n148#1:328\n244#1:354,2\n271#1:358\n271#1:359,2\n272#1:361,2\n249#1:356\n251#1:357\n*E\n"})
public class ReleaseController {
    @NotNull
    private final FreeMarkerConfigurer freeMarkerConfigurer;
    private final Log log;

    @Autowired
    public ReleaseController(@NotNull FreeMarkerConfigurer freeMarkerConfigurer) {
        Intrinsics.checkNotNullParameter((Object)freeMarkerConfigurer, (String)"freeMarkerConfigurer");
        this.freeMarkerConfigurer = freeMarkerConfigurer;
        this.log = LogFactory.getLog(ReleaseController.class);
    }

    @NotNull
    public FreeMarkerConfigurer getFreeMarkerConfigurer() {
        return this.freeMarkerConfigurer;
    }

    @GetMapping(value={"/"}, produces={"image/png", "image/svg+xml"})
    @Counted(value="docops.release.get")
    @Timed(value="docops.release.get", percentiles={0.5, 0.9}, description="Creating a release diagram using http get")
    @NotNull
    public ResponseEntity<byte[]> getRelease(@RequestParam(name="payload") @NotNull String payload, @RequestParam(value="type", required=false, defaultValue="PDF") @NotNull String type, @RequestParam(value="animate", required=false, defaultValue="ON") @NotNull String animate, @RequestParam(name="useDark", defaultValue="false") boolean useDark) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)animate, (String)"animate");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        String string = URLDecoder.decode(payload, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        String data = PanelGeneratorKt.uncompressString((String)string);
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        ReleaseStrategy release = (ReleaseStrategy)this_$iv.decodeFromString((DeserializationStrategy)ReleaseStrategy.Companion.serializer(), data);
        release.setUseDark(useDark);
        boolean isPdf = Intrinsics.areEqual((Object)"PDF", (Object)type);
        String output = "";
        switch (release.getStyle()) {
            case "TL": {
                output = this.createTimelineSvg(release, isPdf);
                break;
            }
            case "TLS": {
                output = this.createTimelineSummarySvg(release, isPdf);
                break;
            }
            case "R": {
                output = this.createRoadMap(release, isPdf, animate);
                break;
            }
            case "TLG": {
                output = this.createTimelineGrouped(release, isPdf);
            }
        }
        if (StringsKt.equals((String)"XLS", (String)type, (boolean)true)) {
            headers = new HttpHeaders();
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(MediaType.parseMediaType((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"));
            responseEntity = new ResponseEntity((Object)ReleaseStrategyKt.excel((ReleaseStrategy)release, (String)output), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        } else {
            headers = new HttpHeaders();
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(MediaType.parseMediaType((String)"image/svg+xml"));
            byte[] byArray = output.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            responseEntity = new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        ResponseEntity result$iv$iv = responseEntity;
        TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.log.info((Object)("getRelease executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms "));
        return (ResponseEntity)timing2.getValue();
    }

    @GetMapping(value={"/prefill"}, produces={"text/html"})
    @ResponseBody
    @Counted(value="docops.release.get.prefill")
    @Timed(value="docops.release.get.prefill", percentiles={0.5, 0.9}, description="Creating a release diagram from prefilled data using http get")
    @NotNull
    public String prefill(@ModelAttribute @NotNull ModelMap model, @RequestParam(name="payload") @NotNull String payload, @RequestParam(value="type", required=false, defaultValue="PDF") @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        String string = URLDecoder.decode(payload, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        String data = PanelGeneratorKt.uncompressString((String)string);
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        ReleaseStrategy release = (ReleaseStrategy)this_$iv.decodeFromString((DeserializationStrategy)ReleaseStrategy.Companion.serializer(), data);
        String result$iv$iv = this.makeFilledView(model, release);
        TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.log.info((Object)("prefill executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms "));
        return (String)timing2.getValue();
    }

    @PutMapping(value={"prefill"}, produces={"text/html"})
    @ResponseBody
    @Counted(value="docops.release.put.json")
    @Timed(value="docops.release.put.json", percentiles={0.5, 0.9}, description="Creating a release diagram from prefilled data using http put")
    @NotNull
    public String prefillFromJson(@ModelAttribute @NotNull ModelMap model, @RequestParam(name="payload") @NotNull String payload, @RequestParam(value="type", required=false, defaultValue="PDF") @NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        Json this_$iv = (Json)Json.Default;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        ReleaseStrategy release = (ReleaseStrategy)this_$iv.decodeFromString((DeserializationStrategy)ReleaseStrategy.Companion.serializer(), payload);
        String result$iv$iv = this.makeFilledView(model, release);
        TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.log.info((Object)("prefillFromJson executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms "));
        return (String)timing2.getValue();
    }

    @PutMapping(value={"/"}, produces={"image/svg+xml"})
    @ResponseBody
    @Counted(value="docops.release.put")
    @Timed(value="docops.release.put", percentiles={0.5, 0.9}, description="Creating a release diagram using http put")
    @NotNull
    public String putStrategy(@RequestBody @NotNull ReleaseStrategy releaseStrategy) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        String result$iv$iv = switch (releaseStrategy.getStyle()) {
            case "TL" -> ReleaseController.createTimelineSvg$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (int)2, null);
            case "TLS" -> ReleaseController.createTimelineSummarySvg$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (int)2, null);
            case "R" -> ReleaseController.createRoadMap$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (String)"ON", (int)2, null);
            case "TLG" -> ReleaseController.createTimelineGrouped$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (int)2, null);
            default -> {
                ProblemDetail v1 = ProblemDetail.forStatusAndDetail((HttpStatusCode)((HttpStatusCode)HttpStatus.BAD_REQUEST), (String)("Unknown Release Strategy style " + releaseStrategy.getStyle()));
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"forStatusAndDetail(...)");
                ProblemDetail pb = v1;
                throw new ErrorResponseException((HttpStatusCode)HttpStatus.BAD_REQUEST, pb, null);
            }
        };
        TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.log.info((Object)("putStrategy executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms "));
        return (String)timing2.getValue();
    }

    @PutMapping(value={"/build"}, produces={"text/html"})
    @ResponseBody
    @Counted(value="docops.release.put.build")
    @Timed(value="docops.release.put.build", percentiles={0.5, 0.9}, description="Creating a release strategy diagram using http put")
    @NotNull
    public String createStrategy(@ModelAttribute @NotNull ModelMap model, @RequestParam(value="title") @NotNull String title, @RequestParam(value="style") @NotNull String style, @NotNull HttpServletRequest servletRequest) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)servletRequest, (String)"servletRequest");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        this.getReleaseTypes(servletRequest);
        List releases = this.getReleaseTypes(servletRequest);
        ReleaseStrategy releaseStrategy = new ReleaseStrategy(title, releases, style, 0.0f, 0, null, false, 120, null);
        String result$iv$iv = this.makeFilledView(model, releaseStrategy);
        TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.log.info((Object)("createStrategy executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms "));
        return (String)timing2.getValue();
    }

    private String makeFilledView(ModelMap model, ReleaseStrategy releaseStrategy) {
        ((Map)model).put("releaseStrategy", releaseStrategy);
        String svg = "";
        switch (releaseStrategy.getStyle()) {
            case "TL": {
                svg = ReleaseController.createTimelineSvg$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (int)2, null);
                break;
            }
            case "TLS": {
                svg = ReleaseController.createTimelineSummarySvg$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (int)2, null);
                break;
            }
            case "R": {
                svg = ReleaseController.createRoadMap$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (String)"ON", (int)2, null);
                break;
            }
            case "TLG": {
                svg = ReleaseController.createTimelineGrouped$default((ReleaseController)this, (ReleaseStrategy)releaseStrategy, (boolean)false, (int)2, null);
            }
        }
        ((Map)model).put("svg", svg);
        Object object = (Map)model;
        String string = "bsvg";
        Base64.Encoder encoder = Base64.getEncoder();
        String string2 = svg;
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        string2 = encoder.encodeToString(byArray);
        object.put(string, string2);
        List selectedStrategy = new ArrayList();
        Iterable $this$forEach$iv = (Iterable)ReleaseEnum.getEntries();
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            ReleaseEnum it = (ReleaseEnum)element$iv;
            boolean bl = false;
            selectedStrategy.add(new SelectedStrategy(it.name(), false));
        }
        Json format2 = JsonKt.Json$default(null, (Function1)((Function1)makeFilledView.format.1.INSTANCE), (int)1, null);
        ((Map)model).put("releaseTypes", ReleaseEnum.getEntries());
        Map $i$f$forEach22 = (Map)model;
        String string3 = "sourceJson";
        Object $this$encodeToString$iv = (StringFormat)format2;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        $this$encodeToString$iv = $this$encodeToString$iv.encodeToString((SerializationStrategy)ReleaseStrategy.Companion.serializer(), (Object)releaseStrategy);
        $i$f$forEach22.put(string3, $this$encodeToString$iv);
        ((Map)model).put("styles", ReleaseStrategyKt.styles((ReleaseStrategy)releaseStrategy));
        StringFormat $this$encodeToString$iv2 = (StringFormat)Json.Default;
        boolean $i$f$encodeToString2 = false;
        $this$encodeToString$iv2.getSerializersModule();
        String json = $this$encodeToString$iv2.encodeToString((SerializationStrategy)ReleaseStrategy.Companion.serializer(), (Object)releaseStrategy);
        ((Map)model).put("getUrl", "api/release/?payload=" + AdrBlockProcessorKt.compressString((String)json) + "&type=svg");
        ((Map)model).put("prefill", "api/release/prefill?payload=" + AdrBlockProcessorKt.compressString((String)json) + "&type=svg");
        StringWriter writer = new StringWriter();
        Template tpl = this.getFreeMarkerConfigurer().getConfiguration().getTemplate("release/filled.ftlh");
        tpl.process((Object)model, (Writer)writer);
        String string4 = writer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
        return string4;
    }

    @NotNull
    public String createTimelineSvg(@NotNull ReleaseStrategy releaseStrategy, boolean isPdf) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        return new ReleaseTimelineMaker().make(releaseStrategy, isPdf);
    }

    public static /* synthetic */ String createTimelineSvg$default(ReleaseController releaseController, ReleaseStrategy releaseStrategy, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createTimelineSvg");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return releaseController.createTimelineSvg(releaseStrategy, bl);
    }

    private String createTimelineSummarySvg(ReleaseStrategy release, boolean pdf) {
        return new ReleaseTimelineSummaryMaker().make(release, pdf);
    }

    static /* synthetic */ String createTimelineSummarySvg$default(ReleaseController releaseController, ReleaseStrategy releaseStrategy, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createTimelineSummarySvg");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return releaseController.createTimelineSummarySvg(releaseStrategy, bl);
    }

    @NotNull
    public String createTimelineGrouped(@NotNull ReleaseStrategy releaseStrategy, boolean isPdf) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        return new ReleaseTimelineGroupedMaker().make(releaseStrategy, isPdf);
    }

    public static /* synthetic */ String createTimelineGrouped$default(ReleaseController releaseController, ReleaseStrategy releaseStrategy, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createTimelineGrouped");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return releaseController.createTimelineGrouped(releaseStrategy, bl);
    }

    @NotNull
    public String createRoadMap(@NotNull ReleaseStrategy releaseStrategy, boolean isPdf, @NotNull String animate) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        Intrinsics.checkNotNullParameter((Object)animate, (String)"animate");
        return new ReleaseRoadMapMaker().make(releaseStrategy, isPdf, animate);
    }

    public static /* synthetic */ String createRoadMap$default(ReleaseController releaseController, ReleaseStrategy releaseStrategy, boolean bl, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: createRoadMap");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            string = "ON";
        }
        return releaseController.createRoadMap(releaseStrategy, bl, string);
    }

    /*
     * WARNING - void declaration
     */
    private List<Release> getReleaseTypes(HttpServletRequest servletRequest) {
        String[] it;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String addLine = servletRequest.getParameter("addLine");
        String addType = servletRequest.getParameter("addType");
        List releases = new ArrayList();
        Enumeration enumeration = servletRequest.getParameterNames();
        Intrinsics.checkNotNullExpressionValue((Object)enumeration, (String)"getParameterNames(...)");
        ArrayList arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        Object[] objectArray = (Object[])arrayList;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String[])element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            if (!StringsKt.startsWith$default((String)it, (String)"type_", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List types = (List)destination$iv$iv;
        Iterable $this$forEach$iv = types;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it2 = (String)element$iv;
            boolean bl = false;
            String string = servletRequest.getParameter(it2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParameter(...)");
            ReleaseEnum type = ReleaseEnum.valueOf((String)string);
            Intrinsics.checkNotNull((Object)it2);
            it = new String[]{"type_"};
            List splitType = StringsKt.split$default((CharSequence)it2, (String[])it, (boolean)false, (int)0, (int)6, null);
            String dateEntry = servletRequest.getParameter("date_" + splitType.get(1));
            String goal = servletRequest.getParameter("goal_" + splitType.get(1));
            String[] stringArray = servletRequest.getParameterValues("line_" + splitType.get(1));
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getParameterValues(...)");
            List lineArr = ArraysKt.toMutableList((Object[])stringArray);
            if (addLine != null && ((CharSequence)addLine).length() > 0 && Intrinsics.areEqual((Object)addLine, (Object)("line_" + splitType.get(1)))) {
                lineArr.add("");
            }
            Intrinsics.checkNotNull((Object)dateEntry);
            Intrinsics.checkNotNull((Object)goal);
            releases.add(new Release(type, lineArr, dateEntry, true, goal, false, 32, null));
        }
        if (addType != null && Intrinsics.areEqual((Object)addType, (Object)"increase")) {
            objectArray = new String[]{""};
            releases.add(new Release(ReleaseEnum.M1, CollectionsKt.mutableListOf((Object[])objectArray), "TBD", false, "Our goal is ...", false, 40, null));
        }
        return releases;
    }
}

