/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.releasestrategy;

import io.docops.docopsextensionssupport.releasestrategy.Release;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseStrategy;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseStrategyKt;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseTimelineMakerKt;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000b\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0004J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0004J0\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0018\u0010\u0018\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u001a\u001a\u00020\u0004H\u0004J \u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0004H\u0004\u00a8\u0006\u001c"}, d2={"Lio/docops/docopsextensionssupport/releasestrategy/ReleaseTimelineGroupedMaker;", "", "()V", "buildReleaseItem", "", "release", "Lio/docops/docopsextensionssupport/releasestrategy/Release;", "currentIndex", "", "isPdf", "", "row", "id", "releaseStrategy", "Lio/docops/docopsextensionssupport/releasestrategy/ReleaseStrategy;", "defs", "scale", "", "determineHeight", "determineWidth", "head", "width", "height", "title", "make", "shadeColor", "tail", "titleFill", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nReleaseTimelineGroupedMaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReleaseTimelineGroupedMaker.kt\nio/docops/docopsextensionssupport/releasestrategy/ReleaseTimelineGroupedMaker\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,244:1\n215#2:245\n216#2:249\n215#2,2:253\n1864#3,3:246\n1864#3,3:250\n*S KotlinDebug\n*F\n+ 1 ReleaseTimelineGroupedMaker.kt\nio/docops/docopsextensionssupport/releasestrategy/ReleaseTimelineGroupedMaker\n*L\n46#1:245\n46#1:249\n139#1:253,2\n47#1:246,3\n82#1:250,3\n*E\n"})
public class ReleaseTimelineGroupedMaker {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public String make(@NotNull ReleaseStrategy releaseStrategy, boolean isPdf) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = string;
        int width = this.determineWidth(releaseStrategy);
        int height = this.determineHeight(releaseStrategy);
        StringBuilder str = new StringBuilder(this.head(width, height, id, releaseStrategy.getTitle(), releaseStrategy.getScale()));
        str.append(this.defs(isPdf, id, releaseStrategy.getScale()));
        String titleFill = "#000000";
        if (releaseStrategy.getUseDark()) {
            titleFill = "#fcfcfc";
        }
        str.append(this.title(releaseStrategy.getTitle(), width, titleFill));
        int row = 0;
        Map $this$forEach$iv = ReleaseStrategyKt.grouped((ReleaseStrategy)releaseStrategy);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            char t2 = ((Character)entry.getKey()).charValue();
            List u = (List)entry.getValue();
            Iterable $this$forEachIndexed$iv = u;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void release;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Release release2 = (Release)item$iv;
                int index = n;
                boolean bl2 = false;
                str.append(this.buildReleaseItem((Release)release, index, isPdf, row, id, releaseStrategy));
            }
            ++row;
        }
        str.append("</g>");
        str.append(this.tail());
        String string2 = str.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String buildReleaseItem(@NotNull Release release, int currentIndex, boolean isPdf, int row, @NotNull String id, @NotNull ReleaseStrategy releaseStrategy) {
        Intrinsics.checkNotNullParameter((Object)release, (String)"release");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        int startY = 60;
        if (row > 0) {
            startY = row * 240 + 60;
        }
        int startX = 0;
        if (currentIndex > 0) {
            startX = currentIndex * 425 - 20 * currentIndex;
        }
        String goal = (String)release.getLines().get(0);
        StringBuilder lineText = new StringBuilder();
        int lineStart = 0;
        lineStart = 25;
        Iterable $this$forEachIndexed$iv = release.getLines();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            lineText.append(StringsKt.trimIndent((String)("\n                <tspan x=\"" + lineStart + "\" dy=\"10\" class=\"entry\" font-size=\"12px\" font-weight=\"normal\"\n                   font-family=\"Arial, 'Helvetica Neue', Helvetica, sans-serif\" text-anchor=\"start\">- " + (String)s + "</tspan>\n            ")));
            if (index <= 7) {
                lineStart += 10;
                continue;
            }
            lineStart -= 10;
        }
        int x = 200;
        String anchor = "text-anchor=\"middle\"";
        if (isPdf) {
            x = 15;
            anchor = "";
        }
        String completed = "";
        if (release.getCompleted()) {
            completed = "<use xlink:href=\"#completedCheck\" x=\"405\" y=\"65\" width=\"24\" height=\"24\"/>";
        }
        return StringsKt.trimIndent((String)("\n         <g transform=\"translate(" + startX + "," + startY + ")\" class=\"" + this.shadeColor(release) + "\">\n             <text text-anchor=\"middle\" x=\"200\" y=\"-12\" class=\"milestoneTLG\">" + release.getDate() + "</text>\n             <path d=\"m 0,0 h 400 v 200 h -400 l 0,0 l 100,-100 z\" stroke=\"" + ReleaseTimelineMakerKt.strokeColor((Release)release) + "\" fill=\"#fcfcfc\"/>\n             <path d=\"m 400,0 v 200 l 100,-100 z\" fill=\"" + ReleaseTimelineMakerKt.strokeColor((Release)release) + "\" stroke=\"" + ReleaseTimelineMakerKt.strokeColor((Release)release) + "\" />\n            <text x=\"410\" y=\"110\" class=\"milestoneTLG\" font-size=\"36px\" fill=\"#fcfcfc\">" + release.getType() + "</text>\n            " + completed + "\n            <text " + anchor + " x=\"" + x + "\" y=\"12\" class=\"milestoneTLG lines\" font-size=\"12px\" font-family='Arial, \"Helvetica Neue\", Helvetica, sans-serif' font-weight=\"bold\">" + release.getGoal() + "\n                " + lineText + "\n            </text>\n        </g>\n        "));
    }

    private final String shadeColor(Release release) {
        return StringsKt.startsWith$default((String)release.getType().toString(), (String)"M", (boolean)false, (int)2, null) ? "shadM" : (StringsKt.startsWith$default((String)release.getType().toString(), (String)"R", (boolean)false, (int)2, null) ? "shadR" : (StringsKt.startsWith$default((String)release.getType().toString(), (String)"G", (boolean)false, (int)2, null) ? "shadG" : ""));
    }

    protected final int determineWidth(@NotNull ReleaseStrategy releaseStrategy) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        Map groups = ReleaseStrategyKt.grouped((ReleaseStrategy)releaseStrategy);
        int maxLen = 0;
        Map $this$forEach$iv = groups;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            char t2 = ((Character)entry.getKey()).charValue();
            List u = (List)entry.getValue();
            maxLen = Math.max(maxLen, u.size());
        }
        return maxLen * 550;
    }

    protected final int determineHeight(@NotNull ReleaseStrategy releaseStrategy) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        return ReleaseStrategyKt.grouped((ReleaseStrategy)releaseStrategy).size() * 260;
    }

    @NotNull
    protected final String head(int width, int height, @NotNull String id, @NotNull String title, float scale) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        return StringsKt.trimIndent((String)("\n        <svg width=\"" + (float)width * scale + "\" height=\"" + (float)height * scale + "\" viewBox='0 0 " + (float)width * scale + "  " + (float)height * scale + "' xmlns='http://www.w3.org/2000/svg' role='img'\n            aria-label='Docops: Release Strategy' id=\"ID" + id + "\">\n            <desc>https://docops.io/extension</desc>\n            <title>" + title + "</title>\n        "));
    }

    @NotNull
    protected final String title(@NotNull String title, int width, @NotNull String titleFill) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)titleFill, (String)"titleFill");
        return StringsKt.trimIndent((String)("\n        <text x=\"" + width / 2 + "\" y=\"18\" fill=\"" + titleFill + "\" text-anchor=\"middle\"  font-size=\"18px\" font-family=\"Arial, Helvetica, sans-serif\">" + title + "</text>\n    "));
    }

    @NotNull
    protected final String tail() {
        return "</svg>";
    }

    @NotNull
    protected final String defs(boolean isPdf, @NotNull String id, float scale) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String style = "";
        if (!isPdf) {
            style = StringsKt.trimIndent((String)("\n                <style>\n            #ID" + id + " .shadM {\n                fill: #6cadde;\n                filter: drop-shadow(0 2mm 1mm #6cadde);\n            }\n            #ID" + id + " .shadR {\n                fill: #C766A0;\n                filter: drop-shadow(0 2mm 1mm #C766A0);\n            }\n\n            #ID" + id + " .shadG {\n                fill: #136e33;\n                filter: drop-shadow(0 2mm 1mm #136e33);\n            }\n            #ID" + id + " .milestone {\n                font-family: Arial, \"Helvetica Neue\", Helvetica, sans-serif;\n                font-weight: bold;\n            }\n            #ID" + id + " .lines {\n                font-size: 10px;\n            }\n\n            #ID" + id + " .milestone > .entry {\n                text-anchor: start;\n                font-weight: normal;\n            }\n        </style>\n            "));
        }
        return StringsKt.trimIndent((String)("\n             <defs>\n             <filter id=\"Bevel2\" filterUnits=\"objectBoundingBox\" x=\"-10%\" y=\"-10%\" width=\"150%\" height=\"150%\">\n                 <feGaussianBlur in=\"SourceAlpha\" stdDeviation=\"0.5\" result=\"blur\"/>\n                 <feSpecularLighting in=\"blur\" surfaceScale=\"5\" specularConstant=\"0.5\" specularExponent=\"10\" result=\"specOut\" lighting-color=\"white\">\n                     <fePointLight x=\"-5000\" y=\"-10000\" z=\"0000\"/>\n                 </feSpecularLighting>\n                 <feComposite in=\"specOut\" in2=\"SourceAlpha\" operator=\"in\" result=\"specOut2\"/>\n                 <feComposite in=\"SourceGraphic\" in2=\"specOut2\" operator=\"arithmetic\" k1=\"0\" k2=\"1\" k3=\"1\" k4=\"0\" result=\"litPaint\" />\n             </filter>\n             <linearGradient id=\"ID0756d7d2-2648-4a67-89af-c133b3a8d4c9\" x2=\"1\" y2=\"1\">\n                 <stop class=\"stop1\" offset=\"0%\" stop-color=\"#a48bdb\">\n                     <animate attributeName=\"stop-color\"\n                              values=\"#a48bdb;#7651c9;#4918B8;#a48bdb;#7651c9;#4918B8;\" dur=\"20s\" repeatCount=\"indefinite\">\n                     </animate>\n                 </stop>\n                 <stop class=\"stop2\" offset=\"50%\" stop-color=\"#7651c9\">\n                     <animate attributeName=\"stop-color\"\n                              values=\"#a48bdb;#7651c9;#4918B8;#a48bdb;#7651c9;#4918B8;\" dur=\"20s\" repeatCount=\"indefinite\">\n                     </animate>\n                 </stop>\n                 <stop class=\"stop3\" offset=\"100%\" stop-color=\"#4918B8\">\n                     <animate attributeName=\"stop-color\"\n                              values=\"#a48bdb;#7651c9;#4918B8;#a48bdb;#7651c9;#4918B8;\" dur=\"20s\" repeatCount=\"indefinite\">\n                     </animate>\n                 </stop>\n                 <animateTransform attributeName=\"gradientTransform\" type=\"rotate\" values=\"360 .5 .5;0 .5 .5\"\n                                   dur=\"10s\" repeatCount=\"indefinite\" />\n             </linearGradient>\n             <linearGradient id=\"shadM_rect\" x2=\"0%\" y2=\"100%\">\n                 <stop class=\"stop1\" offset=\"0%\" stop-color=\"#b5d6ee\"/>\n                 <stop class=\"stop2\" offset=\"50%\" stop-color=\"#90c1e6\"/>\n                 <stop class=\"stop3\" offset=\"100%\" stop-color=\"#6cadde\"/>\n            </linearGradient>\n            <linearGradient id=\"shadR_rect\" x2=\"0%\" y2=\"100%\">\n                <stop class=\"stop1\" offset=\"0%\" stop-color=\"#e3b2cf\"/>\n                <stop class=\"stop2\" offset=\"50%\" stop-color=\"#d58cb7\"/>\n                <stop class=\"stop3\" offset=\"100%\" stop-color=\"#C766A0\"/>\n            </linearGradient>\n            <linearGradient id=\"shadG_rect\" x2=\"0%\" y2=\"100%\">\n                <stop class=\"stop1\" offset=\"0%\" stop-color=\"#89b699\"/>\n                <stop class=\"stop2\" offset=\"50%\" stop-color=\"#4e9266\"/>\n                <stop class=\"stop3\" offset=\"100%\" stop-color=\"#136e33\"/>\n            </linearGradient>\n             " + style + "\n         </defs>\n         <g transform='scale(" + scale + ")'>\n         "));
    }
}

