/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.releasestrategy;

import io.docops.asciidoc.utils.StringFunctionsKt;
import io.docops.docopsextensionssupport.releasestrategy.Release;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseStrategy;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseTimelineMakerKt;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J(\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J(\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0004J\b\u0010\u0017\u001a\u00020\u0004H\u0004J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0004H\u0004\u00a8\u0006\u0019"}, d2={"Lio/docops/docopsextensionssupport/releasestrategy/ReleaseTimelineMaker;", "", "()V", "buildReleaseItem", "", "release", "Lio/docops/docopsextensionssupport/releasestrategy/Release;", "currentIndex", "", "isPdf", "", "id", "defs", "scale", "", "releaseStrategy", "Lio/docops/docopsextensionssupport/releasestrategy/ReleaseStrategy;", "determineWidth", "head", "width", "title", "make", "shadeColor", "tail", "titleFill", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nReleaseTimelineMaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReleaseTimelineMaker.kt\nio/docops/docopsextensionssupport/releasestrategy/ReleaseTimelineMaker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,258:1\n1864#2,3:259\n1864#2,3:262\n1864#2,3:265\n*S KotlinDebug\n*F\n+ 1 ReleaseTimelineMaker.kt\nio/docops/docopsextensionssupport/releasestrategy/ReleaseTimelineMaker\n*L\n47#1:259,3\n63#1:262,3\n169#1:265,3\n*E\n"})
public class ReleaseTimelineMaker {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public String make(@NotNull ReleaseStrategy releaseStrategy, boolean isPdf) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        float width = this.determineWidth(releaseStrategy);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = string;
        StringBuilder str = new StringBuilder(this.head(width, id, releaseStrategy.getTitle(), releaseStrategy.getScale()));
        str.append(this.defs(isPdf, id, releaseStrategy.getScale(), releaseStrategy));
        String titleFill = "#000000";
        if (releaseStrategy.getUseDark()) {
            titleFill = "#fcfcfc";
        }
        str.append(this.title(releaseStrategy.getTitle(), width, titleFill));
        Iterable $this$forEachIndexed$iv = releaseStrategy.getReleases();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void release;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Release release2 = (Release)item$iv;
            int index = n;
            boolean bl = false;
            str.append(this.buildReleaseItem((Release)release, index, isPdf, id));
        }
        str.append("</g>");
        str.append(this.tail());
        String string2 = str.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final String buildReleaseItem(Release release, int currentIndex, boolean isPdf, String id) {
        int startX = 0;
        if (currentIndex > 0) {
            startX = currentIndex * 425 - 20 * currentIndex;
        }
        StringBuilder lineText = new StringBuilder();
        int lineStart = 0;
        lineStart = 25;
        Iterable $this$forEachIndexed$iv = release.getLines();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            lineText.append(StringsKt.trimIndent((String)("\n                <tspan x=\"" + lineStart + "\" dy=\"10\" class=\"entry\" font-size=\"10px\" font-weight=\"normal\"\n                   font-family=\"Arial, 'Helvetica Neue', Helvetica, sans-serif\" text-anchor=\"start\">- " + StringFunctionsKt.escapeXml((String)s) + "</tspan>\n            ")));
            if (index <= 7) {
                lineStart += 10;
                continue;
            }
            lineStart -= 10;
        }
        int x = 200;
        String anchor = "text-anchor=\"middle\"";
        if (isPdf) {
            x = 15;
            anchor = "";
        }
        String completed = "";
        if (release.getCompleted()) {
            completed = "<use xlink:href=\"#completedCheck\" x=\"405\" y=\"65\" width=\"24\" height=\"24\"/>";
        }
        return StringsKt.trimIndent((String)("\n         <g transform=\"translate(" + startX + ",60)\" class=\"" + this.shadeColor(release) + "\">\n             <text text-anchor=\"middle\" x=\"200\" y=\"-12\" class=\"milestoneTL\">" + release.getDate() + "</text>\n             <path d=\"m 0,0 h 400 v 200 h -400 l 0,0 l 100,-100 z\" stroke=\"" + ReleaseTimelineMakerKt.strokeColor((Release)release) + "\" fill=\"#fcfcfc\"/>\n             <path d=\"m 400,0 v 200 l 100,-100 z\" fill=\"" + ReleaseTimelineMakerKt.strokeColor((Release)release) + "\" stroke=\"" + ReleaseTimelineMakerKt.strokeColor((Release)release) + "\" />\n            <text x=\"410\" y=\"110\" class=\"milestoneTL\" font-size=\"36px\" fill=\"#fcfcfc\">" + release.getType() + "</text>\n            " + completed + "\n            <text " + anchor + " x=\"" + x + "\" y=\"12\" class=\"milestoneTL lines\" font-size=\"10px\" font-family='Arial, \"Helvetica Neue\", Helvetica, sans-serif' font-weight=\"bold\">" + StringFunctionsKt.escapeXml((String)release.getGoal()) + "\n                " + lineText + "\n            </text>\n        </g>\n        "));
    }

    @NotNull
    protected final String shadeColor(@NotNull Release release) {
        Intrinsics.checkNotNullParameter((Object)release, (String)"release");
        return StringsKt.startsWith$default((String)release.getType().toString(), (String)"M", (boolean)false, (int)2, null) ? "shadM" : (StringsKt.startsWith$default((String)release.getType().toString(), (String)"R", (boolean)false, (int)2, null) ? "shadR" : (StringsKt.startsWith$default((String)release.getType().toString(), (String)"G", (boolean)false, (int)2, null) ? "shadG" : ""));
    }

    protected final float determineWidth(@NotNull ReleaseStrategy releaseStrategy) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        return (float)(releaseStrategy.getReleases().size() * 410 + releaseStrategy.getReleases().size() * 20 + 80) * releaseStrategy.getScale();
    }

    private final String head(float width, String id, String title, float scale) {
        float height = (float)270 * scale;
        return StringsKt.trimIndent((String)("\n            <svg width=\"" + width + "\" height=\"" + height + "\" viewBox='0 0 " + width + " " + height + "' xmlns='http://www.w3.org/2000/svg' xmlns:xlink=\"http://www.w3.org/1999/xlink\" role='img'\n            aria-label='Docops: Release Strategy' id=\"ID" + id + "\">\n            <desc>https://docops.io/extension</desc>\n            <title>" + StringFunctionsKt.escapeXml((String)title) + "</title>\n        "));
    }

    @NotNull
    protected final String title(@NotNull String title, float width, @NotNull String titleFill) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)titleFill, (String)"titleFill");
        return StringsKt.trimIndent((String)("\n        <text x=\"" + width / (float)2 + "\" y=\"18\" fill=\"" + titleFill + "\" text-anchor=\"middle\"  font-size=\"20px\" font-family=\"Arial, Helvetica, sans-serif\">" + StringFunctionsKt.escapeXml((String)title) + "</text>\n    "));
    }

    @NotNull
    protected final String tail() {
        return "</svg>";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final String defs(boolean isPdf, @NotNull String id, float scale, @NotNull ReleaseStrategy releaseStrategy) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        String style = "";
        if (!isPdf) {
            style = StringsKt.trimIndent((String)("\n                <style>\n            #ID" + id + " .shadM { fill: " + releaseStrategy.getDisplayConfig().getColors().get(0) + "; filter: drop-shadow(0 1mm 1mm " + releaseStrategy.getDisplayConfig().getColors().get(0) + "); }\n            #ID" + id + " .shadR { fill: " + releaseStrategy.getDisplayConfig().getColors().get(1) + "; filter: drop-shadow(0 1mm 1mm " + releaseStrategy.getDisplayConfig().getColors().get(1) + "); }\n\n            #ID" + id + " .shadG { fill: " + releaseStrategy.getDisplayConfig().getColors().get(2) + "; filter: drop-shadow(0 1mm 1mm " + releaseStrategy.getDisplayConfig().getColors().get(2) + "); }\n            #ID" + id + " .milestoneTL { font-family: Arial, \"Helvetica Neue\", Helvetica, sans-serif; font-weight: bold; }\n            #ID" + id + " .lines { font-size: 10px; }\n\n            #ID" + id + " .milestoneTL > .entry { text-anchor: start; font-weight: normal; }\n            .raise { pointer-events: bounding-box; opacity: 1; filter: drop-shadow(3px 1px 2px rgb(0 0 0 / 0.4)); }\n\n            .raise:hover { stroke: gold; stroke-width: 3px; opacity: 0.9; }\n            \n        </style>\n            <script>\n             function strategyShowItem(item) {\n                 var elem = document.querySelector(\"#\"+item);\n                 var display = elem.getAttribute(\"visibility\");\n                 if(\"hidden\" === display) {\n                     elem.setAttribute(\"visibility\", \"\")\n                 } else {\n                     elem.setAttribute(\"visibility\", \"hidden\")\n                 }\n             }\n             </script>\n            "));
        }
        StringBuilder colors = new StringBuilder();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)0, (Object)"M"), TuplesKt.to((Object)1, (Object)"R"), TuplesKt.to((Object)2, (Object)"G")};
        Map shades = MapsKt.mutableMapOf((Pair[])pairArray);
        Iterable $this$forEachIndexed$iv = releaseStrategy.getDisplayConfig().getColors();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            colors.append(ReleaseTimelineMakerKt.gradientColorFromColor((String)s, (String)("shad" + shades.get(index) + "_rect")));
        }
        return StringsKt.trimIndent((String)("\n             <defs>\n             <filter id=\"Bevel2\" filterUnits=\"objectBoundingBox\" x=\"-10%\" y=\"-10%\" width=\"150%\" height=\"150%\">\n                 <feGaussianBlur in=\"SourceAlpha\" stdDeviation=\"0.5\" result=\"blur\"/>\n                 <feSpecularLighting in=\"blur\" surfaceScale=\"5\" specularConstant=\"0.5\" specularExponent=\"10\" result=\"specOut\" lighting-color=\"white\">\n                     <fePointLight x=\"-5000\" y=\"-10000\" z=\"0000\"/>\n                 </feSpecularLighting>\n                 <feComposite in=\"specOut\" in2=\"SourceAlpha\" operator=\"in\" result=\"specOut2\"/>\n                 <feComposite in=\"SourceGraphic\" in2=\"specOut2\" operator=\"arithmetic\" k1=\"0\" k2=\"1\" k3=\"1\" k4=\"0\" result=\"litPaint\" />\n             </filter>\n             <linearGradient id=\"ID0756d7d2-2648-4a67-89af-c133b3a8d4c9\" x2=\"1\" y2=\"1\">\n                 <stop class=\"stop1\" offset=\"0%\" stop-color=\"#a48bdb\">\n                     <animate attributeName=\"stop-color\"\n                              values=\"#a48bdb;#7651c9;#4918B8;#a48bdb;#7651c9;#4918B8;\" dur=\"20s\" repeatCount=\"indefinite\">\n                     </animate>\n                 </stop>\n                 <stop class=\"stop2\" offset=\"50%\" stop-color=\"#7651c9\">\n                     <animate attributeName=\"stop-color\"\n                              values=\"#a48bdb;#7651c9;#4918B8;#a48bdb;#7651c9;#4918B8;\" dur=\"20s\" repeatCount=\"indefinite\">\n                     </animate>\n                 </stop>\n                 <stop class=\"stop3\" offset=\"100%\" stop-color=\"#4918B8\">\n                     <animate attributeName=\"stop-color\"\n                              values=\"#a48bdb;#7651c9;#4918B8;#a48bdb;#7651c9;#4918B8;\" dur=\"20s\" repeatCount=\"indefinite\">\n                     </animate>\n                 </stop>\n                 <animateTransform attributeName=\"gradientTransform\" type=\"rotate\" values=\"360 .5 .5;0 .5 .5\"\n                                   dur=\"10s\" repeatCount=\"indefinite\" />\n             </linearGradient>\n             <linearGradient id=\"circlecheck\" x2=\"1\" y2=\"1\">\n                <stop class=\"stop1\" offset=\"0%\" stop-color=\"#a9d99a\"/>\n                <stop class=\"stop2\" offset=\"50%\" stop-color=\"#7ec667\"/>\n                <stop class=\"stop3\" offset=\"100%\" stop-color=\"#54B435\"/>\n            </linearGradient>\n            <g id=\"completedCheck\">\n                <polyline points=\"10 25 22 40 50 10\" fill=\"none\" stroke=\"url(#circlecheck)\" stroke-width=\"6\"/>\n            </g>\n\n             " + colors + "\n             " + style + "\n         </defs>\n         <g transform='scale(" + scale + ")' id='GID" + id + "'>\n         "));
    }
}

