/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.releasestrategy;

import io.docops.asciidoc.utils.StringFunctionsKt;
import io.docops.docopsextensionssupport.releasestrategy.Release;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseStrategy;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseTimelineMaker;
import io.docops.docopsextensionssupport.releasestrategy.ReleaseTimelineMakerKt;
import io.docops.docopsextensionssupport.roadmap.RoadMapMakerKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ.\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ(\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J&\u0010\u0014\u001a\u00020\u00042\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u001a"}, d2={"Lio/docops/docopsextensionssupport/releasestrategy/ReleaseTimelineSummaryMaker;", "Lio/docops/docopsextensionssupport/releasestrategy/ReleaseTimelineMaker;", "()V", "buildReleaseItem", "", "release", "Lio/docops/docopsextensionssupport/releasestrategy/Release;", "currentIndex", "", "isPdf", "", "id", "releaseStrategy", "Lio/docops/docopsextensionssupport/releasestrategy/ReleaseStrategy;", "buildReleaseItemHidden", "head", "width", "", "title", "scale", "linesToSpanText", "lines", "", "dy", "x", "make", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nReleaseTimelineSummaryMaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReleaseTimelineSummaryMaker.kt\nio/docops/docopsextensionssupport/releasestrategy/ReleaseTimelineSummaryMaker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1864#2,3:172\n1864#2,3:175\n1864#2,3:178\n1855#2,2:181\n*S KotlinDebug\n*F\n+ 1 ReleaseTimelineSummaryMaker.kt\nio/docops/docopsextensionssupport/releasestrategy/ReleaseTimelineSummaryMaker\n*L\n49#1:172,3\n77#1:175,3\n127#1:178,3\n165#1:181,2\n*E\n"})
public final class ReleaseTimelineSummaryMaker
extends ReleaseTimelineMaker {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public String make(@NotNull ReleaseStrategy releaseStrategy, boolean isPdf) {
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        float width = this.determineWidth(releaseStrategy);
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String id = string;
        StringBuilder str = new StringBuilder(this.head(width, id, releaseStrategy.getTitle(), releaseStrategy.getScale()));
        str.append(this.defs(isPdf, id, releaseStrategy.getScale(), releaseStrategy));
        String titleFill = "#000000";
        if (releaseStrategy.getUseDark()) {
            titleFill = "#fcfcfc";
        }
        str.append(this.title(releaseStrategy.getTitle(), width, titleFill));
        Iterable $this$forEachIndexed$iv = releaseStrategy.getReleases();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void release;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Release release2 = (Release)item$iv;
            int index = n;
            boolean bl = false;
            str.append(this.buildReleaseItem((Release)release, index, isPdf, id, releaseStrategy));
            str.append(this.buildReleaseItemHidden((Release)release, index, isPdf, id, releaseStrategy));
        }
        str.append("</g>");
        str.append(this.tail());
        String string2 = str.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final String head(float width, String id, String title, float scale) {
        float height = (float)485 * scale;
        return StringsKt.trimIndent((String)("\n            <svg width=\"" + width + "\" height=\"" + height + "\" viewBox='0 0 " + width + " " + height + "' xmlns='http://www.w3.org/2000/svg' xmlns:xlink=\"http://www.w3.org/1999/xlink\" role='img'\n            aria-label='Docops: Release Strategy' id=\"ID" + id + "\">\n            <desc>https://docops.io/extension</desc>\n            <title>" + StringFunctionsKt.escapeXml((String)title) + "</title>\n        "));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildReleaseItem(@NotNull Release release, int currentIndex, boolean isPdf, @NotNull String id, @NotNull ReleaseStrategy releaseStrategy) {
        Intrinsics.checkNotNullParameter((Object)release, (String)"release");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        int startX = 0;
        if (currentIndex > 0) {
            startX = currentIndex * 425 - 20 * currentIndex;
        }
        StringBuilder lineText = new StringBuilder();
        int lineStart = 0;
        lineStart = 25;
        Iterable $this$forEachIndexed$iv = release.getLines();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            lineText.append(StringsKt.trimIndent((String)("\n                <tspan x=\"" + lineStart + "\" dy=\"10\" class=\"entry\" font-size=\"12px\" font-weight=\"normal\"\n                   font-family=\"Arial, 'Helvetica Neue', Helvetica, sans-serif\" text-anchor=\"start\">- " + StringFunctionsKt.escapeXml((String)s) + "</tspan>\n            ")));
            if (index <= 7) {
                lineStart += 10;
                continue;
            }
            lineStart -= 10;
        }
        String goals = StringFunctionsKt.escapeXml((String)release.getGoal());
        List lines = RoadMapMakerKt.linesToUrlIfExist((List)RoadMapMakerKt.wrapText((String)goals, (float)20.0f), (Map)new LinkedHashMap());
        String spans = this.linesToSpanText(lines, 24, 150);
        int textY = 88 - lines.size() * 12;
        int positionX = startX;
        if (currentIndex > 0) {
            positionX += currentIndex * 5;
        }
        String completed = "";
        if (release.getCompleted()) {
            completed = "<use xlink:href=\"#completedCheck\" x=\"405\" y=\"65\" width=\"24\" height=\"24\"/>";
        }
        return StringsKt.trimIndent((String)("\n         <g transform=\"translate(" + (positionX + 10) + ",60)\" class=\"" + this.shadeColor(release) + "\">\n             <text text-anchor=\"middle\" x=\"250\" y=\"-12\" class=\"milestoneTL\">" + release.getDate() + "</text>\n             <path d=\"m 0,0 h 400 v 200 h -400 l 0,0 l 100,-100 z\" stroke=\"" + ReleaseTimelineMakerKt.fishTailColor((Release)release, (ReleaseStrategy)releaseStrategy) + "\" fill=\"url(#" + this.shadeColor(release) + "_rect)\"/>\n             <path d=\"m 400,0 v 200 l 100,-100 z\" fill=\"url(#" + this.shadeColor(release) + "_rect)\" stroke=\"" + ReleaseTimelineMakerKt.fishTailColor((Release)release, (ReleaseStrategy)releaseStrategy) + "\" />\n            <text x=\"410\" y=\"110\" class=\"milestoneTL\" font-size=\"36px\" fill=\"" + releaseStrategy.getDisplayConfig().getFontColor() + "\">" + release.getType() + "</text>\n            " + completed + "\n            <g transform=\"translate(100,0)\" cursor=\"pointer\" onclick=\"strategyShowItem('ID" + id + "_" + currentIndex + "')\">\n                <rect x=\"0\" y=\"0\" height=\"200\" width=\"300\" fill=\"url(#" + this.shadeColor(release) + "_rect)\" class=\"raise\"/>\n                <text text-anchor=\"middle\" x=\"150\" y=\"" + textY + "\" class=\"milestoneTL lines\" font-size=\"12px\"\n                      font-family=\"Arial, 'Helvetica Neue', Helvetica, sans-serif\" font-weight=\"bold\" fill=\"" + releaseStrategy.getDisplayConfig().getFontColor() + "\">\n                   " + spans + "\n                </text>\n            </g>\n        </g>\n        "));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildReleaseItemHidden(@NotNull Release release, int currentIndex, boolean isPdf, @NotNull String id, @NotNull ReleaseStrategy releaseStrategy) {
        Intrinsics.checkNotNullParameter((Object)release, (String)"release");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)releaseStrategy, (String)"releaseStrategy");
        int startX = 0;
        if (currentIndex > 0) {
            startX = currentIndex * 425 - 20 * currentIndex;
        }
        StringBuilder lineText = new StringBuilder();
        int lineStart = 0;
        lineStart = 25;
        Iterable $this$forEachIndexed$iv = release.getLines();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void s;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string = (String)item$iv;
            int index = n;
            boolean bl = false;
            lineText.append(StringsKt.trimIndent((String)("\n                <tspan x=\"" + lineStart + "\" dy=\"12\" class=\"entry\" font-size=\"12px\" font-weight=\"normal\"\n                   font-family=\"Arial, 'Helvetica Neue', Helvetica, sans-serif\" text-anchor=\"start\">- " + StringFunctionsKt.escapeXml((String)s) + "</tspan>\n            ")));
            if (index <= 6) {
                lineStart += 12;
                continue;
            }
            lineStart -= 12;
        }
        int x = 200;
        String anchor = "text-anchor=\"middle\"";
        if (isPdf) {
            x = 15;
            anchor = "";
        }
        int positionX = startX;
        if (currentIndex > 0) {
            positionX += currentIndex * 5;
        }
        return StringsKt.trimIndent((String)("\n         <g transform=\"translate(" + (positionX + 10) + ",275)\" class=\"" + this.shadeColor(release) + "\" visibility=\"hidden\" id=\"ID" + id + "_" + currentIndex + "\">\n             <path d=\"m 0,0 h 400 v 200 h -400 l 0,0 l 100,-100 z\" stroke=\"" + ReleaseTimelineMakerKt.fishTailColor((Release)release, (ReleaseStrategy)releaseStrategy) + "\" fill=\"#fcfcfc\"/>\n             <path d=\"m 400,0 v 200 l 100,-100 z\" fill=\"url(#" + this.shadeColor(release) + "_rect)\" stroke=\"" + ReleaseTimelineMakerKt.fishTailColor((Release)release, (ReleaseStrategy)releaseStrategy) + "\" />\n            <text x=\"410\" y=\"110\" class=\"milestoneTL\" font-size=\"36px\" fill=\"#fcfcfc\">" + release.getType() + "</text>\n            <text " + anchor + " x=\"" + x + "\" y=\"12\" class=\"milestoneTL lines\" font-size=\"12px\" font-family='Arial, \"Helvetica Neue\", Helvetica, sans-serif' font-weight=\"bold\">\n                " + lineText + "\n            </text>\n        </g>\n        "));
    }

    private final String linesToSpanText(List<String> lines, int dy, int x) {
        StringBuilder text = new StringBuilder();
        Iterable $this$forEach$iv = lines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            text.append("<tspan x=\"" + x + "\" dy=\"" + dy + "\" text-anchor=\"middle\" font-family=\"Arial, 'Helvetica Neue', Helvetica, sans-serif\" font-size=\"24\" font-weight=\"normal\">" + it + "</tspan>");
        }
        String string = text.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

