/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.roadmap;

import io.docops.asciidoc.utils.StringFunctionsKt;
import io.docops.docopsextensionssupport.roadmap.DarkTheme;
import io.docops.docopsextensionssupport.roadmap.RegularTheme;
import io.docops.docopsextensionssupport.roadmap.RoadMapMakerKt;
import io.docops.docopsextensionssupport.roadmap.RoadMapParser;
import io.docops.docopsextensionssupport.roadmap.RoadMapParserKt;
import io.docops.docopsextensionssupport.roadmap.RoadMapTheme;
import io.docops.docopsextensionssupport.roadmap.RoadMaps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J4\u0010\t\u001a\u00020\b2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u000b0\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J(\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002J$\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\b\u0010\u0019\u001a\u00020\bH\u0002J&\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ&\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ \u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\bH\u0002J\b\u0010\u001f\u001a\u00020\bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lio/docops/docopsextensionssupport/roadmap/RoadMapMaker;", "", "useDark", "", "(Z)V", "getUseDark", "()Z", "defs", "", "doDone", "done", "", "numChars", "roadmaps", "Lio/docops/docopsextensionssupport/roadmap/RoadMaps;", "startingY", "", "draw", "scale", "title", "head", "Lkotlin/Pair;", "", "joinXmlLines", "str", "makeNow", "makeRoadMapImage", "source", "parseToRoadMap", "row", "index", "tail", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nRoadMapMaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoadMapMaker.kt\nio/docops/docopsextensionssupport/roadmap/RoadMapMaker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,470:1\n1855#2,2:471\n1855#2:473\n1864#2,3:474\n1856#2:477\n*S KotlinDebug\n*F\n+ 1 RoadMapMaker.kt\nio/docops/docopsextensionssupport/roadmap/RoadMapMaker\n*L\n122#1:471,2\n137#1:473\n139#1:474,3\n137#1:477\n*E\n"})
public final class RoadMapMaker {
    private final boolean useDark;

    public RoadMapMaker(boolean useDark) {
        this.useDark = useDark;
    }

    public /* synthetic */ RoadMapMaker(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public final boolean getUseDark() {
        return this.useDark;
    }

    @NotNull
    public final String makeRoadMapImage(@NotNull String source, @NotNull String scale, @NotNull String title, @NotNull String numChars) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)numChars, (String)"numChars");
        RoadMaps roadmaps = new RoadMapParser().parse(source);
        return this.draw(roadmaps, scale, title, numChars);
    }

    @NotNull
    public final RoadMaps parseToRoadMap(@NotNull String source, @NotNull String scale, @NotNull String title, @NotNull String numChars) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)numChars, (String)"numChars");
        return new RoadMapParser().parse(source);
    }

    private final String draw(RoadMaps roadmaps, String scale, String title, String numChars) {
        StringBuilder sb = new StringBuilder();
        Pair head = this.head(roadmaps, Float.parseFloat(scale));
        sb.append((String)head.getFirst());
        sb.append(this.defs());
        RoadMapTheme roadMapTheme = (RoadMapTheme)new RegularTheme();
        String headerColor = "headerLight";
        if (this.useDark) {
            roadMapTheme = (RoadMapTheme)new DarkTheme();
            headerColor = "headerDark";
        }
        sb.append("<rect width=\"100%\" height=\"100%\" fill=\"" + roadMapTheme.paperColor() + "\" opacity=\"1.0\"/>");
        sb.append("<g transform='scale(" + scale + ")'>");
        sb.append(this.makeNow());
        int n = RoadMapParserKt.maxLength((RoadMaps)roadmaps);
        int n2 = 0;
        while (n2 < n) {
            int index = n2++;
            boolean bl = false;
            sb.append(this.row(index, roadmaps, numChars));
        }
        sb.append(StringsKt.trimIndent((String)("\n        <text x=\"105\" y=\"100\" class=\"now\">NOW</text>\n        <text x=\"324.5\" y=\"100\" class=\"next\" text-anchor=\"middle\">NEXT</text>\n        <text x=\"534.5\" y=\"100\" class=\"later\" text-anchor=\"middle\">LATER</text>\n         <rect x=\"0\" y=\"0\" stroke-width=\"0\" fill=\"url(#" + headerColor + ")\"  height=\"80\" width=\"662\" opacity=\"1.0\"/>\n        <text x=\"306\" y=\"60\" font-family=\" Arial, Helvetica, sans-serif\" font-size=\"46\" class=\"glass\" fill=\"" + roadMapTheme.titleColor() + "\" text-anchor=\"middle\">" + StringFunctionsKt.escapeXml((String)title) + "</text> \n        ")));
        if (!((Collection)roadmaps.getDone()).isEmpty()) {
            sb.append(StringsKt.trimIndent((String)("\n                <rect x=\"26\" y=\"" + head.getSecond() + "\" height=\"25\" width=\"600\" fill=\"url(#" + headerColor + ")\" opacity=\"1.0\" stroke-width=\"0\"/>\n                <text x=\"306\" y=\"" + (((Number)head.getSecond()).intValue() + 20) + "\" font-family=\" Arial, Helvetica, sans-serif\" font-size=\"20\" class=\"doneTitle\" fill=\"" + roadMapTheme.titleColor() + "\" text-anchor=\"middle\">COMPLETED</text> \n            ")));
            sb.append(this.doDone(roadmaps.getDone(), numChars, roadmaps, ((Number)head.getSecond()).intValue()));
        }
        sb.append("</g>");
        sb.append(this.tail());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.joinXmlLines(string);
    }

    private final String joinXmlLines(String str) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)str);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            sb.append(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String doDone(List<List<String>> done, String numChars, RoadMaps roadmaps, int startingY) {
        List doneChunks = CollectionsKt.chunked((Iterable)done, (int)3);
        StringBuilder sb = new StringBuilder();
        int c = 0;
        c = startingY + 40;
        Iterable $this$forEach$iv = doneChunks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List mutableLists = (List)element$iv;
            boolean bl = false;
            sb.append("<g transform=\"translate(26," + c + ")\">");
            Iterable $this$forEachIndexed$iv = mutableLists;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                String spans;
                List lines;
                void item;
                Object text;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                List list = (List)item$iv;
                int index = n;
                boolean bl2 = false;
                if (index == 0) {
                    sb.append("<rect x=\"0\" y=\"0\" fill=\"#fcfcfc\" class=\"doneBox\" height=\"100\" width=\"184\"/>");
                    text = "<text x=\"2\" y=\"2\" class=\"doneRoad\" fill=\"#421A56\">";
                    lines = RoadMapMakerKt.linesToUrlIfExist((List)RoadMapMakerKt.wrapText((String)CollectionsKt.joinToString$default((Iterable)((Iterable)item), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), (float)Float.parseFloat(numChars)), (Map)roadmaps.getUrlMap());
                    spans = RoadMapMakerKt.linesToMultiLineText((List)lines, (int)12, (int)2, null);
                    text = (String)text + spans;
                    text = (String)text + "</text>";
                    sb.append((String)text);
                }
                if (index == 1) {
                    sb.append("<rect x=\"210\" y=\"0\" fill=\"#fcfcfc\" class=\"doneBox\" height=\"100\" width=\"184\"/>");
                    text = "<text x=\"212\" y=\"2\" class=\"doneRoad\" fill=\"#421A56\">";
                    lines = RoadMapMakerKt.linesToUrlIfExist((List)RoadMapMakerKt.wrapText((String)CollectionsKt.joinToString$default((Iterable)((Iterable)item), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), (float)Float.parseFloat(numChars)), (Map)roadmaps.getUrlMap());
                    spans = RoadMapMakerKt.linesToMultiLineText((List)lines, (int)12, (int)212, null);
                    text = (String)text + spans;
                    text = (String)text + "</text>";
                    sb.append((String)text);
                }
                if (index != 2) continue;
                sb.append("<rect x=\"420\" y=\"0\" fill=\"#fcfcfc\" class=\"doneBox\" height=\"100\" width=\"184\"/>");
                text = "<text x=\"422\" y=\"2\" class=\"doneRoad\" fill=\"#421A56\">";
                lines = RoadMapMakerKt.linesToUrlIfExist((List)RoadMapMakerKt.wrapText((String)CollectionsKt.joinToString$default((Iterable)((Iterable)item), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), (float)Float.parseFloat(numChars)), (Map)roadmaps.getUrlMap());
                spans = RoadMapMakerKt.linesToMultiLineText((List)lines, (int)12, (int)422, null);
                text = (String)text + spans;
                text = (String)text + "</text>";
                sb.append((String)text);
            }
            sb.append("</g>");
            c += 106;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final Pair<String, Integer> head(RoadMaps roadmaps, float scale) {
        int originalHeight;
        float width = (float)662 * scale;
        int totalHeight = originalHeight = RoadMapParserKt.maxLength((RoadMaps)roadmaps) * 105 + 106;
        if (!((Collection)roadmaps.getDone()).isEmpty()) {
            int remain = roadmaps.getDone().size() % 3;
            int rows = roadmaps.getDone().size() / 3;
            if (remain > 0) {
                ++rows;
            }
            totalHeight += 105 * rows + 40;
        }
        float height = (float)totalHeight * scale;
        String str = "<svg xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" width=\"" + width + "\" height=\"" + height + "\" viewBox=\"0 0 " + width + " " + height + "\">";
        return new Pair((Object)str, (Object)originalHeight);
    }

    private final String row(int index, RoadMaps roadmaps, String numChars) {
        String spans;
        List lines;
        Object text;
        StringBuilder sb = new StringBuilder("<g transform=\"translate(26," + 105 * (index + 1) + ")\">");
        String now = "<rect x=\"0\" y=\"0\" fill=\"#fcfcfc\" class=\"nowBox\" height=\"100\" width=\"184\"/>";
        String next = "<rect x=\"210\" y=\"0\" fill=\"#fcfcfc\" class=\"nextBox\" height=\"100\" width=\"184\"/>";
        String later = "<rect x=\"420\" y=\"0\" fill=\"#fcfcfc\" class=\"laterBox\" height=\"100\" width=\"184\"/>";
        if (roadmaps.getNow().size() - 1 >= index) {
            sb.append(now);
            text = "<text x=\"2\" y=\"2\" class=\"primaryRoad\" fill=\"#421A56\">";
            lines = RoadMapMakerKt.linesToUrlIfExist((List)RoadMapMakerKt.wrapText((String)CollectionsKt.joinToString$default((Iterable)((Iterable)roadmaps.getNow().get(index)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), (float)Float.parseFloat(numChars)), (Map)roadmaps.getUrlMap());
            spans = RoadMapMakerKt.linesToMultiLineText((List)lines, (int)12, (int)2, null);
            text = (String)text + spans;
            text = (String)text + "</text>";
            sb.append((String)text);
        }
        if (roadmaps.getNext().size() - 1 >= index) {
            sb.append(next);
            text = "<text x=\"212\" y=\"2\" class=\"secondaryRoad\">";
            lines = RoadMapMakerKt.linesToUrlIfExist((List)RoadMapMakerKt.wrapText((String)CollectionsKt.joinToString$default((Iterable)((Iterable)roadmaps.getNext().get(index)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), (float)Float.parseFloat(numChars)), (Map)roadmaps.getUrlMap());
            spans = RoadMapMakerKt.linesToMultiLineText((List)lines, (int)12, (int)212, null);
            text = (String)text + spans;
            text = (String)text + "</text>";
            sb.append((String)text);
            if (index == 0) {
                sb.append("<line x1=\"186\" y1=\"50\" x2=\"200\" y2=\"50\" stroke=\"#e0349c\" stroke-width=\"8\" marker-end=\"url(#arrowhead1)\" />");
            }
        }
        if (roadmaps.getLater().size() - 1 >= index) {
            sb.append(later);
            text = "<text x=\"422\" y=\"2\" class=\"tertiaryRoad\">";
            lines = RoadMapMakerKt.linesToUrlIfExist((List)RoadMapMakerKt.wrapText((String)CollectionsKt.joinToString$default((Iterable)((Iterable)roadmaps.getLater().get(index)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null), (float)Float.parseFloat(numChars)), (Map)roadmaps.getUrlMap());
            spans = RoadMapMakerKt.linesToMultiLineText((List)lines, (int)12, (int)422, null);
            text = (String)text + spans;
            text = (String)text + "</text>";
            sb.append((String)text);
            if (index == 0) {
                sb.append("<line x1=\"396\" y1=\"50\" x2=\"410\" y2=\"50\" stroke=\"#e56516\" stroke-width=\"8\" marker-end=\"url(#arrowhead2)\" />");
            }
        }
        sb.append("</g>");
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String makeNow() {
        return "";
    }

    private final String tail() {
        return "</svg>";
    }

    private final String defs() {
        return "    <defs>\n    <linearGradient id=\"headerTitleBar\" x2=\"0%\" y2=\"100%\">\n        <stop class=\"stop1\" offset=\"0%\" stop-color=\"#f8d8c4\"/>\n        <stop class=\"stop2\" offset=\"50%\" stop-color=\"#f5c5a7\"/>\n        <stop class=\"stop3\" offset=\"100%\" stop-color=\"#f2b28a\"/>\n    </linearGradient>\n    <linearGradient id=\"headerEight\" x2=\"0%\" y2=\"100%\">\n        <stop class=\"stop1\" offset=\"0%\" stop-color=\"#ffb79a\"/>\n        <stop class=\"stop2\" offset=\"50%\" stop-color=\"#ff9368\"/>\n        <stop class=\"stop3\" offset=\"100%\" stop-color=\"#FF6F36\"/>\n    </linearGradient>\n    <linearGradient x1=\"62.342285\" y1=\"8.8261719\" x2=\"62.342281\" y2=\"61.276535\" id=\"linearGradient4619\" gradientUnits=\"userSpaceOnUse\">\n        <stop id=\"stop4621\" style=\"stop-color:#ffffff;stop-opacity:1\" offset=\"0\"/>\n        <stop id=\"stop4623\" style=\"stop-color:#45a98f;stop-opacity:1\" offset=\"1\"/>\n    </linearGradient>\n    <linearGradient id=\"blackPurple\" x1=\"62.342285\" y1=\"8.8261719\" x2=\"62.342281\" y2=\"61.276535\" gradientUnits=\"userSpaceOnUse\">\n    <stop class=\"stop1\" stop-color=\"#ffffff\" offset=\"0\"/><stop class=\"stop3\" offset=\"1\" stop-color=\"#6b587d\"/></linearGradient>\n    <linearGradient id=\"headerDark\" x1=\"62.342285\" y1=\"8.8261719\" x2=\"62.342281\" y2=\"61.276535\"  gradientUnits=\"userSpaceOnUse\">\n        <stop class=\"stop1\" offset=\"0%\" stop-color=\"#8b9195\"/>\n        <stop class=\"stop2\" offset=\"50%\" stop-color=\"#515a60\"/>\n        <stop class=\"stop3\" offset=\"100%\" stop-color=\"#17242b\"/>\n    </linearGradient>\n    <linearGradient id=\"headerLight\" x1=\"62.342285\" y1=\"8.8261719\" x2=\"62.342281\" y2=\"61.276535\" gradientUnits=\"userSpaceOnUse\">\n        <stop class=\"stop1\" offset=\"0%\" stop-color=\"#E4E4E4\"/>\n        <stop class=\"stop2\" offset=\"100%\" stop-color=\"#DBD8E3\"/>\n    </linearGradient>\n    <marker id=\"arrowhead1\" markerWidth=\"2\" markerHeight=\"5\" refX=\"0\" refY=\"1.5\" orient=\"auto\">\n        <polygon points=\"0 0, 1 1.5, 0 3\" fill=\"#e0349c\"/>\n    </marker>\n    <marker id=\"arrowhead2\" markerWidth=\"2\" markerHeight=\"5\" refX=\"0\" refY=\"1.5\" orient=\"auto\">\n        <polygon points=\"0 0, 1 1.5, 0 3\" fill=\"#e56516\"/>\n    </marker>\n    <filter id=\"Bevel2\" filterUnits=\"objectBoundingBox\" x=\"-10%\" y=\"-10%\" width=\"150%\" height=\"150%\">\n        <feGaussianBlur in=\"SourceAlpha\" stdDeviation=\"0.5\" result=\"blur\"/>\n        <feSpecularLighting in=\"blur\" surfaceScale=\"5\" specularConstant=\"0.5\" specularExponent=\"10\" result=\"specOut\" lighting-color=\"white\">\n            <fePointLight x=\"-5000\" y=\"-10000\" z=\"0000\"/>\n        </feSpecularLighting>\n        <feComposite in=\"specOut\" in2=\"SourceAlpha\" operator=\"in\" result=\"specOut2\"/>\n        <feComposite in=\"SourceGraphic\" in2=\"specOut2\" operator=\"arithmetic\" k1=\"0\" k2=\"1\" k3=\"1\" k4=\"0\" result=\"litPaint\" />\n    </filter>\n\n    <style>\n    .now { fill: #45a98f; font-family: Arial, Helvetica, sans-serif; stroke: #45a98f; text-anchor: middle; font-weight: bold; }\n    .nowBox { fill: none; font-family: Arial, Helvetica, sans-serif; stroke: #45a98f; }\n    .next { fill: #e0349c; font-family: Arial, Helvetica, sans-serif; stroke: #e0349c; text-anchor: middle; font-weight: bold; }\n    .nextBox { fill: none; font-family: Arial, Helvetica, sans-serif; stroke: #e0349c; text-anchor: middle; font-weight: bold; }\n    .later { fill: #e56516; font-family: Arial, Helvetica, sans-serif; stroke: #e56516; text-anchor: middle; font-weight: bold; }\n    .laterBox { fill: none; font-family: Arial, Helvetica, sans-serif; stroke: #e56516; text-anchor: middle; font-weight: bold; }\n    .doneBox { fill: none; font-family: Arial, Helvetica, sans-serif; stroke: #4076ff; }\n    .primaryRoad { font-family: Arial, Helvetica, sans-serif; font-size: 12px; fill: #45a98f; }\n    .secondaryRoad{ font-family: Arial, Helvetica, sans-serif; font-size: 12px; fill: #e0349c; }\n    .tertiaryRoad { font-family: Arial, Helvetica, sans-serif; font-size: 12px; fill: #e56516; }\n    .doneRoad { font-family: Arial, Helvetica, sans-serif; font-size: 12px; fill: #4076ff; }\n    .doneTitle { fill: #4076ff; font-family: Arial, Helvetica, sans-serif; stroke: #4076ff;  font-weight: bold; }\n    .rmLink { fill: blue; text-decoration: underline; }\n    .glass:after, .glass:before {\n    content: \"\";\n    display: block;\n    position: absolute\n}\n\n.glass {\n    overflow: hidden;\n    color: #fff;\n    text-shadow: 0 1px 2px rgba(0, 0, 0, .7);\n    background-image: radial-gradient(circle at center, rgba(0, 167, 225, .25), rgba(0, 110, 149, .5));\n    box-shadow: 0 5px 10px rgba(0, 0, 0, .75), inset 0 0 0 2px rgba(0, 0, 0, .3), inset 0 -6px 6px -3px rgba(0, 129, 174, .2);\n    position: relative\n}\n\n.glass:after {\n    background: rgba(0, 167, 225, .2);\n    z-index: 0;\n    height: 100%;\n    width: 100%;\n    top: 0;\n    left: 0;\n    backdrop-filter: blur(3px) saturate(400%);\n    -webkit-backdrop-filter: blur(3px) saturate(400%)\n}\n\n.glass:before {\n    width: calc(100% - 4px);\n    height: 35px;\n    background-image: linear-gradient(rgba(255, 255, 255, .7), rgba(255, 255, 255, 0));\n    top: 2px;\n    left: 2px;\n    border-radius: 30px 30px 200px 200px;\n    opacity: .7\n}\n\n.glass:hover {\n    text-shadow: 0 1px 2px rgba(0, 0, 0, .9)\n}\n\n.glass:hover:before {\n    opacity: 1\n}\n\n.glass:active {\n    text-shadow: 0 0 2px rgba(0, 0, 0, .9);\n    box-shadow: 0 3px 8px rgba(0, 0, 0, .75), inset 0 0 0 2px rgba(0, 0, 0, .3), inset 0 -6px 6px -3px rgba(0, 129, 174, .2)\n}\n\n.glass:active:before {\n    height: 25px\n}\n</style>\n</defs>";
    }

    public RoadMapMaker() {
        this(false, 1, null);
    }
}

