/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.roadmap;

import io.docops.docopsextensionssupport.roadmap.RoadMaps;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u00a8\u0006\u0007"}, d2={"excel", "", "Lio/docops/docopsextensionssupport/roadmap/RoadMaps;", "title", "", "maxLength", "", "docops-extension-server"})
public final class RoadMapParserKt {
    @NotNull
    public static final byte[] excel(@NotNull RoadMaps $this$excel, @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)$this$excel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet(title);
        XSSFCellStyle xSSFCellStyle = workbook.createCellStyle();
        Intrinsics.checkNotNullExpressionValue((Object)xSSFCellStyle, (String)"createCellStyle(...)");
        CellStyle style = (CellStyle)xSSFCellStyle;
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GOLD.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        XSSFRow xSSFRow = sheet.createRow(0);
        Intrinsics.checkNotNullExpressionValue((Object)xSSFRow, (String)"createRow(...)");
        Row header = (Row)xSSFRow;
        header.createCell(0).setCellValue("NOW");
        header.createCell(1).setCellValue("NEXT");
        header.createCell(2).setCellValue("LATER");
        header.createCell(3).setCellValue("DONE");
        for (int c = 0; c < 4; ++c) {
            header.getCell(c).setCellStyle(style);
        }
        XSSFRow xSSFRow2 = sheet.createRow(1);
        Intrinsics.checkNotNullExpressionValue((Object)xSSFRow2, (String)"createRow(...)");
        Row dataRow = (Row)xSSFRow2;
        dataRow.createCell(0).setCellValue("");
        dataRow.createCell(1).setCellValue("");
        dataRow.createCell(2).setCellValue("");
        dataRow.createCell(3).setCellValue("");
        int n = $this$excel.maxListSize();
        for (int i = 0; i < n; ++i) {
            int index = i;
            boolean bl = false;
            XSSFRow row = sheet.createRow(index + 2);
            String nowValue = "";
            List n2 = $this$excel.nowList();
            if (n2.size() - 1 >= index) {
                nowValue = (String)n2.get(index);
            }
            String nextValue = "";
            List nt = $this$excel.nextList();
            if (nt.size() - 1 > index) {
                nextValue = (String)nt.get(index);
            }
            String laterValue = "";
            List lt = $this$excel.laterList();
            if (lt.size() - 1 > index) {
                laterValue = (String)lt.get(index);
            }
            String doneValue = "";
            List dl = $this$excel.doneList();
            if (dl.size() - 1 > index) {
                doneValue = (String)dl.get(index);
            }
            XSSFCell cell0 = row.createCell(0);
            XSSFCellStyle cellStyle0 = cell0.getSheet().getWorkbook().createCellStyle();
            cellStyle0.setWrapText(true);
            cell0.setCellStyle((CellStyle)cellStyle0);
            cell0.setCellValue(nowValue);
            XSSFCell cell1 = row.createCell(1);
            XSSFCellStyle cellStyle1 = cell1.getSheet().getWorkbook().createCellStyle();
            cellStyle1.setWrapText(true);
            cell1.setCellStyle((CellStyle)cellStyle1);
            cell1.setCellValue(nextValue);
            XSSFCell cell2 = row.createCell(2);
            XSSFCellStyle cellStyle2 = cell2.getSheet().getWorkbook().createCellStyle();
            cellStyle2.setWrapText(true);
            cell2.setCellStyle((CellStyle)cellStyle2);
            cell2.setCellValue(laterValue);
            XSSFCell content = row.createCell(3);
            XSSFCellStyle xSSFCellStyle2 = content.getSheet().getWorkbook().createCellStyle();
            Intrinsics.checkNotNullExpressionValue((Object)xSSFCellStyle2, (String)"createCellStyle(...)");
            CellStyle cellStyle = (CellStyle)xSSFCellStyle2;
            cellStyle.setWrapText(true);
            content.setCellStyle(cellStyle);
            content.setCellValue(doneValue);
        }
        sheet.autoSizeColumn(0);
        sheet.autoSizeColumn(1);
        sheet.autoSizeColumn(2);
        sheet.autoSizeColumn(3);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        workbook.write((OutputStream)outputStream);
        workbook.close();
        byte[] byArray = outputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    public static final int maxLength(@NotNull RoadMaps $this$maxLength) {
        Intrinsics.checkNotNullParameter((Object)$this$maxLength, (String)"<this>");
        return Math.max($this$maxLength.getNow().size(), Math.max($this$maxLength.getNext().size(), $this$maxLength.getLater().size()));
    }
}

