/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.roadmap;

import io.docops.asciidoctorj.extension.adr.AdrBlockProcessorKt;
import io.docops.docopsextensionssupport.badge.BadgeControllerKt;
import io.docops.docopsextensionssupport.roadmap.RoadMapMaker;
import io.docops.docopsextensionssupport.roadmap.RoadMapParserKt;
import io.docops.docopsextensionssupport.roadmap.RoadMaps;
import io.docops.docopsextensionssupport.svgsupport.SvgToPng;
import io.docops.docopsextensionssupport.web.panel.PanelGeneratorKt;
import io.micrometer.core.annotation.Timed;
import io.micrometer.observation.annotation.Observed;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/roadmap"})
@Observed(name="roadmap.controller")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JJ\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0001\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\f2\b\b\u0001\u0010\u000e\u001a\u00020\f2\b\b\u0001\u0010\u000f\u001a\u00020\f2\b\b\u0001\u0010\u0010\u001a\u00020\f2\b\b\u0001\u0010\u0011\u001a\u00020\u0012H\u0017J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0017R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lio/docops/docopsextensionssupport/roadmap/RoadmapPlanController;", "", "()V", "log", "Lorg/apache/commons/logging/Log;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/apache/commons/logging/Log;", "getRoadMap", "Lorg/springframework/http/ResponseEntity;", "", "payload", "", "scale", "type", "title", "numChars", "useDark", "", "putRoadmapPlan", "httpServletRequest", "Ljakarta/servlet/http/HttpServletRequest;", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nRoadmapPlanController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RoadmapPlanController.kt\nio/docops/docopsextensionssupport/roadmap/RoadmapPlanController\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,142:1\n79#2,5:143\n113#2,7:148\n79#2,5:155\n113#2,7:160\n*S KotlinDebug\n*F\n+ 1 RoadmapPlanController.kt\nio/docops/docopsextensionssupport/roadmap/RoadmapPlanController\n*L\n53#1:143,5\n53#1:148,7\n111#1:155,5\n111#1:160,7\n*E\n"})
public class RoadmapPlanController {
    private final Log log = LogFactory.getLog(RoadmapPlanController.class);

    public Log getLog() {
        return this.log;
    }

    @PutMapping(value={"/"})
    @ResponseBody
    @Timed(value="docops.roadmap.put.html")
    @NotNull
    public ResponseEntity<byte[]> putRoadmapPlan(@NotNull HttpServletRequest httpServletRequest) {
        String numChars;
        Intrinsics.checkNotNullParameter((Object)httpServletRequest, (String)"httpServletRequest");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        String div = "";
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(MediaType.parseMediaType((String)"text/html"));
        String contents = httpServletRequest.getParameter("content");
        CharSequence charSequence = contents;
        if (charSequence == null || charSequence.length() == 0) {
            contents = StreamUtils.copyToString((InputStream)((InputStream)httpServletRequest.getInputStream()), (Charset)Charset.defaultCharset());
        }
        String scale = httpServletRequest.getParameter("scale");
        String title = httpServletRequest.getParameter("title");
        String chars = numChars = httpServletRequest.getParameter("numChars");
        if (numChars == null || ((CharSequence)numChars).length() == 0) {
            chars = "32";
        }
        String useDarkInput = httpServletRequest.getParameter("useDark");
        RoadMapMaker rmm = new RoadMapMaker("on".equals(useDarkInput));
        String string = contents;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        Intrinsics.checkNotNull((Object)scale);
        Intrinsics.checkNotNull((Object)title);
        string = chars;
        Intrinsics.checkNotNull((Object)string);
        String svg = rmm.makeRoadMapImage(string2, scale, title, string);
        string = contents;
        Intrinsics.checkNotNull((Object)string);
        div = StringsKt.trimIndent((String)("\n            <div>" + svg + "</div>\n            <div class=\"divider\"></div> \n            <div>\n               <a class=\"btn btn-outline\" href=\"api/roadmap/?payload=" + AdrBlockProcessorKt.compressString((String)string) + "&title=" + title + "&numChars=" + numChars + "&scale=" + scale + "&type=svg\" target=\"_blank\">Open Url</a>\n            </div>\n        "));
        byte[] byArray = div.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ResponseEntity result$iv$iv = new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.getLog().info((Object)("putRoadmapPlan executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms "));
        return (ResponseEntity)timing2.getValue();
    }

    @GetMapping(value={"/"})
    @ResponseBody
    @Timed(value="docops.roadmap.get.html")
    @NotNull
    public ResponseEntity<byte[]> getRoadMap(@RequestParam(name="payload") @NotNull String payload, @RequestParam(name="scale") @NotNull String scale, @RequestParam(value="type", required=false, defaultValue="SVG") @NotNull String type, @RequestParam(value="title", required=false) @NotNull String title, @RequestParam(value="numChars", required=false, defaultValue="30") @NotNull String numChars, @RequestParam(name="useDark", defaultValue="false") boolean useDark) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)numChars, (String)"numChars");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        String string = URLDecoder.decode(payload, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        String data = PanelGeneratorKt.uncompressString((String)string);
        RoadMapMaker rmm = new RoadMapMaker(useDark);
        boolean isPdf = Intrinsics.areEqual((Object)"PDF", (Object)type);
        String svg = rmm.makeRoadMapImage(data, scale, title, numChars);
        if (isPdf) {
            HttpHeaders headers = new HttpHeaders();
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(MediaType.IMAGE_PNG);
            Pair res = BadgeControllerKt.findHeightWidth((String)svg);
            byte[] baos = new SvgToPng().toPngFromSvg(svg, res);
            responseEntity = new ResponseEntity((Object)baos, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        } else if (Intrinsics.areEqual((Object)"XLS", (Object)type)) {
            HttpHeaders headers = new HttpHeaders();
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(MediaType.parseMediaType((String)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"));
            responseEntity = new ResponseEntity((Object)RoadMapParserKt.excel((RoadMaps)rmm.parseToRoadMap(data, scale, title, numChars), (String)title), (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        } else {
            HttpHeaders headers = new HttpHeaders();
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(MediaType.parseMediaType((String)"image/svg+xml"));
            byte[] byArray = svg.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            responseEntity = new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        ResponseEntity result$iv$iv = responseEntity;
        TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.getLog().info((Object)("getRoadMap executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms "));
        return (ResponseEntity)timing2.getValue();
    }
}

