/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.scorecard;

import io.docops.asciidoc.utils.StringFunctionsKt;
import io.docops.docopsextensionssupport.scorecard.ScoreCard;
import io.docops.docopsextensionssupport.scorecard.ScoreCardItem;
import io.docops.docopsextensionssupport.scorecard.ScoreCardMaker;
import io.docops.docopsextensionssupport.scorecard.ScoreCardMakerKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0015\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0016\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u000e\u001a\u00020\u0004H\u0002J\u0006\u0010\u000f\u001a\u00020\u0004J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0004J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001a\u0010\u0016\u001a\u00020\u00042\b\b\u0002\u0010\u0017\u001a\u00020\u00042\b\b\u0002\u0010\u0018\u001a\u00020\nJ\u000e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0006\u0010\u001b\u001a\u00020\u0004J\u0010\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\u00a8\u0006\u001f"}, d2={"Lio/docops/docopsextensionssupport/scorecard/ScoreCardMaker;", "", "()V", "arrowHead", "", "scoreCard", "Lio/docops/docopsextensionssupport/scorecard/ScoreCard;", "arrowLine", "background", "h", "", "w", "defs", "styles", "endWrapper", "glass", "gradientBackGround", "head", "height", "id", "left", "make", "raise", "strokeColor", "opacity", "right", "startWrapper", "tail", "titles", "workItem", "Companion", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nScoreCardMaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScoreCardMaker.kt\nio/docops/docopsextensionssupport/scorecard/ScoreCardMaker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,261:1\n1855#2,2:262\n1855#2,2:264\n*S KotlinDebug\n*F\n+ 1 ScoreCardMaker.kt\nio/docops/docopsextensionssupport/scorecard/ScoreCardMaker\n*L\n150#1:262,2\n175#1:264,2\n*E\n"})
public final class ScoreCardMaker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final float WIDTH = 1045.0f;

    @NotNull
    public final String make(@NotNull ScoreCard scoreCard) {
        Intrinsics.checkNotNullParameter((Object)scoreCard, (String)"scoreCard");
        String id = scoreCard.getId();
        StringBuilder sb = new StringBuilder();
        float numOfRowsHeight = (float)Math.max(scoreCard.getInitiativeItems().size(), scoreCard.getOutcomeItems().size()) * 35.1f;
        float headerHeight = 50.0f;
        float height = numOfRowsHeight + headerHeight;
        sb.append(this.head(scoreCard, height, id));
        StringBuilder styles = new StringBuilder();
        styles.append(this.workItem(id));
        styles.append(this.glass());
        styles.append(ScoreCardMaker.raise$default((ScoreCardMaker)this, null, (float)0.0f, (int)3, null));
        String string = styles.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        sb.append(this.defs(string, scoreCard));
        sb.append(this.startWrapper(scoreCard));
        sb.append(this.background(height, 1045.0f));
        sb.append(this.titles(scoreCard));
        sb.append(this.arrowLine(scoreCard));
        sb.append(this.left(scoreCard));
        sb.append(this.right(scoreCard));
        sb.append(this.endWrapper());
        sb.append(this.tail());
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @NotNull
    public final String head(@NotNull ScoreCard scoreCard, float height, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)scoreCard, (String)"scoreCard");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        float width = 1045.0f;
        return "<svg id=\"d" + id + "\" xmlns=\"http://www.w3.org/2000/svg\" width=\"" + width * scoreCard.getScale() + "\" height=\"" + height * scoreCard.getScale() + "\"\n     viewBox=\"0 0 " + width * scoreCard.getScale() + " " + height * scoreCard.getScale() + "\"\n     preserveAspectRatio=\"xMidYMin slice\"\n     xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n";
    }

    @NotNull
    public final String tail() {
        return "</svg>";
    }

    @NotNull
    public final String defs(@NotNull String styles, @NotNull ScoreCard scoreCard) {
        Intrinsics.checkNotNullParameter((Object)styles, (String)"styles");
        Intrinsics.checkNotNullParameter((Object)scoreCard, (String)"scoreCard");
        return StringsKt.trimIndent((String)("\n            <defs>\n            " + this.arrowHead(scoreCard) + "\n            " + this.gradientBackGround(scoreCard) + "\n            " + ScoreCardMakerKt.buildGradientDef((String)scoreCard.getScoreCardTheme().getArrowColor(), (String)"arrowColor") + "\n            " + ScoreCardMakerKt.buildGradientDef((String)"#D36B00", (String)"leftScoreBox") + "\n            " + ScoreCardMakerKt.buildGradientDef((String)"#5D9C59", (String)"rightScoreBox") + "\n            " + ScoreCardMakerKt.buildGradientDef((String)scoreCard.getScoreCardTheme().getOutcomeBackgroundColor(), (String)"rightItem") + "\n            " + ScoreCardMakerKt.buildGradientDef((String)scoreCard.getScoreCardTheme().getInitiativeBackgroundColor(), (String)"leftItem") + "\n            <style>\n            " + styles + "\n            .left_" + scoreCard.getId() + " {\n                fill: url(#leftItem);\n            }\n            .right_" + scoreCard.getId() + " {\n                fill: url(#rightItem);\n            }\n            </style>\n            <script>\n                var reveal = function () {\n                    var elems = document.querySelectorAll('#d" + scoreCard.getId() + " [display=\"none\"]');\n                    if(elems.length > 0) {\n                        var item = elems[0];\n                        item.setAttribute(\"display\", \"block\");\n                    }\n                }\n            </script>\n            </defs>\n            \n        "));
    }

    private final String arrowHead(ScoreCard scoreCard) {
        return "<marker id=\"arrowhead1\" markerWidth=\"2\" markerHeight=\"5\" refX=\"0\" refY=\"1.5\" orient=\"auto\">\n            <polygon points=\"0 0, 1 1.5, 0 3\" fill=\"" + scoreCard.getScoreCardTheme().getArrowColor() + "\"/>\n        </marker>";
    }

    private final String gradientBackGround(ScoreCard scoreCard) {
        return ScoreCardMakerKt.buildGradientDef((String)scoreCard.getScoreCardTheme().getBackgroundColor(), (String)"backgroundScore");
    }

    private final String workItem(String id) {
        return "\n        #" + id + " .workitem {\n                filter: drop-shadow(3px 5px 2px rgb(0 0 0 / 0.4));\n            }\n         #" + id + " .workitem :hover {\n                opacity: 0.5;\n                stroke-opacity: 1.7;\n                stroke-width: 3;\n                stroke: #bd5d5d;\n            }\n            ";
    }

    @NotNull
    public final String glass() {
        return ".glass:after,.glass:before{content:\"\";display:block;position:absolute}.glass{overflow:hidden;color:#fff;text-shadow:0 1px 2px rgba(0,0,0,.7);background-image:radial-gradient(circle at center,rgba(0,167,225,.25),rgba(0,110,149,.5));box-shadow:0 5px 10px rgba(0,0,0,.75),inset 0 0 0 2px rgba(0,0,0,.3),inset 0 -6px 6px -3px rgba(0,129,174,.2);position:relative}.glass:after{background:rgba(0,167,225,.2);z-index:0;height:100%;width:100%;top:0;left:0;backdrop-filter:blur(3px) saturate(400%);-webkit-backdrop-filter:blur(3px) saturate(400%)}.glass:before{width:calc(100% - 4px);height:35px;background-image:linear-gradient(rgba(255,255,255,.7),rgba(255,255,255,0));top:2px;left:2px;border-radius:30px 30px 200px 200px;opacity:.7}.glass:hover{text-shadow:0 1px 2px rgba(0,0,0,.9)}.glass:hover:before{opacity:1}.glass:active{text-shadow:0 0 2px rgba(0,0,0,.9);box-shadow:0 3px 8px rgba(0,0,0,.75),inset 0 0 0 2px rgba(0,0,0,.3),inset 0 -6px 6px -3px rgba(0,129,174,.2)}.glass:active:before{height:25px}";
    }

    @NotNull
    public final String raise(@NotNull String strokeColor, float opacity) {
        Intrinsics.checkNotNullParameter((Object)strokeColor, (String)"strokeColor");
        return ".raise {pointer-events: bounding-box;opacity: 1;filter: drop-shadow(3px 5px 2px rgb(0 0 0 / 0.4));}.raise:hover {stroke: " + strokeColor + ";stroke-width: 3px; opacity: " + opacity + ";} .raiseText {pointer-events: bounding-box; opacity: 1; filter: drop-shadow(3px 5px 2px rgb(0 0 0 / 0.4)); }";
    }

    public static /* synthetic */ String raise$default(ScoreCardMaker scoreCardMaker, String string, float f, int n, Object object) {
        if ((n & 1) != 0) {
            string = "gold";
        }
        if ((n & 2) != 0) {
            f = 0.9f;
        }
        return scoreCardMaker.raise(string, f);
    }

    @NotNull
    public final String background(float h, float w) {
        return StringsKt.trimIndent((String)("\n        <path d=\"" + ScoreCardMakerKt.generateRectPathData((float)w, (float)h, (float)16.0f, (float)16.0f, (float)16.0f, (float)16.0f) + "\" \n        fill=\"#fcfcfc\" stroke=\"#5b5b5b\"  />\n         "));
    }

    private final String titles(ScoreCard scoreCard) {
        String reveal = "";
        if (scoreCard.getSlideShow()) {
            reveal = "onclick=\"reveal();\" cursor=\"pointer\"";
        }
        return StringsKt.trimIndent((String)("\n    <text x=\"522.5\" y=\"20\" style=\"font-family: Arial, Helvetica, sans-serif;  text-anchor:middle; font-size: 12px; fill: " + scoreCard.getScoreCardTheme().getTitleColor() + "; letter-spacing: normal;font-weight: bold;font-variant: small-caps;\" class=\"raiseText\">" + scoreCard.getTitle() + "</text>\n    <text x=\"255\" y=\"40\" style=\"font-family: Arial, Helvetica, sans-serif;  text-anchor:middle; font-size: 12px; fill: " + scoreCard.getScoreCardTheme().getInitiativeTitleColor() + "; letter-spacing: normal;font-weight: bold;font-variant: small-caps;\" class=\"raiseText\">" + scoreCard.getInitiativeTitle() + "</text>\n    <text x=\"755.5\" y=\"40\" style=\"font-family: Arial, Helvetica, sans-serif;  text-anchor:middle; font-size: 12px; fill: " + scoreCard.getScoreCardTheme().getOutcomeTitleColor() + "; letter-spacing: normal;font-weight: bold;font-variant: small-caps;\" class=\"raiseText\" " + reveal + ">" + scoreCard.getOutcomeTitle() + "</text>\n   \n        "));
    }

    @NotNull
    public final String left(@NotNull ScoreCard scoreCard) {
        Intrinsics.checkNotNullParameter((Object)scoreCard, (String)"scoreCard");
        StringBuilder sb = new StringBuilder();
        int startY = 0;
        startY = 50;
        int inc = 35;
        Iterable $this$forEach$iv = scoreCard.getInitiativeItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScoreCardItem it = (ScoreCardItem)element$iv;
            boolean bl = false;
            sb.append(StringsKt.trimIndent((String)("\n    <g transform=\"translate(10, " + startY + ")\">\n    <path d=\"" + ScoreCardMakerKt.generateRectPathData((float)500.0f, (float)30.0f, (float)12.0f, (float)12.0f, (float)12.0f, (float)12.0f) + "\" class=\"left_" + scoreCard.getId() + "\">\n    <title>" + it.getDescription() + "</title>\n    </path>\n        <rect x=\"5\" y=\"5\" height=\"20\" width=\"20\" fill=\"url(#leftScoreBox)\" rx=\"5\" ry=\"5\"/>\n        <text x=\"11\" y=\"19\" fill=\"#efefef\" style=\"font-family: arial;  font-size: 12px; font-weight:bold;\">" + StringsKt.first((CharSequence)it.getDisplayText()) + "</text>\n        <text x=\"30\" y=\"7\" style=\"font-family: arial;  font-size: 12px;\" class=\"raiseText\">\n            <tspan x=\"30\" dy=\"12\" style=\"font-variant: small-caps;fill:" + scoreCard.getScoreCardTheme().getInitiativeDisplayTextColor() + ";\">" + StringFunctionsKt.escapeXml((String)it.getDisplayText()) + "</tspan>\n        </text>\n    </g>\n            ")));
            startY += inc;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String right(@NotNull ScoreCard scoreCard) {
        Intrinsics.checkNotNullParameter((Object)scoreCard, (String)"scoreCard");
        StringBuilder sb = new StringBuilder();
        int startY = 0;
        startY = 50;
        int inc = 35;
        String display = null;
        display = "display=\"block\"";
        if (scoreCard.getSlideShow()) {
            display = "display=\"none\"";
        }
        Iterable $this$forEach$iv = scoreCard.getOutcomeItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScoreCardItem it = (ScoreCardItem)element$iv;
            boolean bl = false;
            sb.append(StringsKt.trimIndent((String)("\n    <g transform=\"translate(525, " + startY + ")\" " + display + ">\n        <path d=\"" + ScoreCardMakerKt.generateRectPathData((float)500.0f, (float)30.0f, (float)12.0f, (float)12.0f, (float)12.0f, (float)12.0f) + "\" class=\"right_" + scoreCard.getId() + "\">\n        <title>" + it.getDescription() + "</title>\n        </path>\n        <rect x=\"5\" y=\"5\" height=\"20\" width=\"20\" fill=\"url(#rightScoreBox)\" rx=\"5\" ry=\"5\"/>\n        <text x=\"11\" y=\"19\" fill=\"#efefef\" style=\"font-family: arial;  font-size: 12px; font-weight:bold;\">" + StringsKt.first((CharSequence)it.getDisplayText()) + "</text>\n        <text x=\"30\" y=\"7\" style=\"font-family: arial;  font-size: 12px;\" class=\"raiseText\">\n            <tspan x=\"30\" dy=\"12\" style=\"font-variant: small-caps; fill:" + scoreCard.getScoreCardTheme().getOutcomeDisplayTextColor() + ";\">" + StringFunctionsKt.escapeXml((String)it.getDisplayText()) + "</tspan>\n        </text>\n    </g>\n            ")));
            startY += inc;
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String arrowLine(ScoreCard scoreCard) {
        return StringsKt.trimIndent((String)("\n        <g transform=\"translate(480,25)\" class=\"raiseText\">\n            <line x1=\"10\" x2=\"50\" y1=\"10\" y2=\"10\" stroke=\"" + scoreCard.getScoreCardTheme().getArrowColor() + "\" stroke-width=\"5\" stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n            <g transform=\"translate(50,7.5)\">\n                <polygon points=\"0,5 1.6666666666666667,2.5 0,0 5,2.5\" stroke=\"url(#arrowColor)\" stroke-width=\"3\"\n                         fill=\"url(#arrowColor)\"/>\n            </g>\n        </g>\n        "));
    }

    private final String startWrapper(ScoreCard scoreCard) {
        return "<g transform='scale(" + scoreCard.getScale() + ")'>";
    }

    private final String endWrapper() {
        return "</g>";
    }
}

