/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.scorecard;

import io.docops.docopsextensionssupport.scorecard.ScoreCard;
import io.docops.docopsextensionssupport.scorecard.ScoreCardItem;
import io.docops.docopsextensionssupport.scorecard.ScoreCardMaker;
import io.docops.docopsextensionssupport.scorecard.ScoreCardTheme;
import java.awt.Color;
import java.io.File;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a6\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006\u001a\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\r2\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"buildGradientDef", "", "color", "id", "generateRectPathData", "width", "", "height", "topLetRound", "topRightRound", "bottomRightRound", "bottomLeftRound", "gradientFromColor", "", "main", "", "tint", "Ljava/awt/Color;", "factor", "", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nScoreCardMaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScoreCardMaker.kt\nio/docops/docopsextensionssupport/scorecard/ScoreCardMakerKt\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,261:1\n113#2:262\n*S KotlinDebug\n*F\n+ 1 ScoreCardMaker.kt\nio/docops/docopsextensionssupport/scorecard/ScoreCardMakerKt\n*L\n259#1:262\n*E\n"})
public final class ScoreCardMakerKt {
    @NotNull
    public static final String buildGradientDef(@NotNull String color, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Map m = ScoreCardMakerKt.gradientFromColor((String)color);
        return "\n           <linearGradient id=\"" + id + "\" x2=\"0%\" y2=\"100%\">\n            <stop class=\"stop1\" offset=\"0%\" stop-color=\"" + m.get("color1") + "\"/>\n            <stop class=\"stop2\" offset=\"50%\" stop-color=\"" + m.get("color2") + "\"/>\n            <stop class=\"stop3\" offset=\"100%\" stop-color=\"" + m.get("color3") + "\"/>\n            </linearGradient> \n        ";
    }

    @NotNull
    public static final Map<String, String> gradientFromColor(@NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Color decoded = Color.decode(color);
        Intrinsics.checkNotNull((Object)decoded);
        String tinted1 = ScoreCardMakerKt.tint((Color)decoded, (double)0.5);
        String tinted2 = ScoreCardMakerKt.tint((Color)decoded, (double)0.25);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"color1", (Object)tinted1), TuplesKt.to((Object)"color2", (Object)tinted2), TuplesKt.to((Object)"color3", (Object)color)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    private static final String tint(Color color, double factor) {
        double rs = (double)color.getRed() + factor * (double)(255 - color.getRed());
        double gs = (double)color.getGreen() + factor * (double)(255 - color.getGreen());
        double bs = (double)color.getBlue() + factor * (double)(255 - color.getBlue());
        String string = Integer.toString((int)rs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = Integer.toString((int)gs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String string3 = Integer.toString((int)bs, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        return "#" + string + string2 + string3;
    }

    @NotNull
    public static final String generateRectPathData(float width, float height, float topLetRound, float topRightRound, float bottomRightRound, float bottomLeftRound) {
        return "M 0 " + topLetRound + " A " + topLetRound + " " + topLetRound + " 0 0 1 " + topLetRound + " 0 L " + (width - topRightRound) + " 0 A " + topRightRound + " " + topRightRound + " 0 0 1 " + width + " " + topRightRound + " L " + width + " " + (height - bottomRightRound) + " A " + bottomRightRound + " " + bottomRightRound + " 0 0 1 " + (width - bottomRightRound) + " " + height + " L " + bottomLeftRound + " " + height + " A " + bottomLeftRound + " " + bottomLeftRound + " 0 0 1 0 " + (height - bottomLeftRound) + " Z";
    }

    public static final void main() {
        ScoreCardMaker sm = new ScoreCardMaker();
        Object object = new ScoreCardItem[]{new ScoreCardItem("Spring Boot 2.7 on Pcf Platform", "Spring Boot microservice framework"), new ScoreCardItem("Redis used for storing circuit breaker data", "Redis is a distributed caching layer"), new ScoreCardItem("MySql for storing zipkin traces", null, 2, null), new ScoreCardItem("RabbitMQ for sending zipkin traces", null, 2, null)};
        List list = CollectionsKt.mutableListOf((Object[])object);
        Object object2 = new ScoreCardItem[]{new ScoreCardItem("Docker Containerized Spring Boot 3.x on EKS", null, 2, null), new ScoreCardItem("Okta used for Authentication", null, 2, null), new ScoreCardItem("PVC used for storing circuit breaker data", null, 2, null), new ScoreCardItem("Open Search for zipkin trace storage", null, 2, null), new ScoreCardItem("IBOB guidelines compliance", null, 2, null), new ScoreCardItem("Flight check completed", null, 2, null), new ScoreCardItem("Blue/Green/Canary deployments supported", null, 2, null), new ScoreCardItem("Documented Local Setup for building & debugging", null, 2, null), new ScoreCardItem("Production Support Guidelines documented", null, 2, null), new ScoreCardItem("Splunk queries documented", "Actuator Endpoints validated")};
        object = CollectionsKt.mutableListOf((Object[])object2);
        object2 = new ScoreCardTheme(null, null, null, null, "#fcfcfc", "#fcfcfc", "#111111", "#31AD18", null, 271, null);
        ScoreCard sc = new ScoreCard(null, "Digital Policy Service", "PCF to EKS", "TMVS++", list, (List)object, 1.0f, (ScoreCardTheme)object2, true, 1, null);
        String svg = sm.make(sc);
        File outfile = new File("gen/score2.svg");
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        $this$encodeToString$iv.getSerializersModule();
        object2 = $this$encodeToString$iv.encodeToString((SerializationStrategy)ScoreCard.Companion.serializer(), (Object)sc);
        System.out.println(object2);
        object2 = svg;
        byte[] byArray = ((String)object2).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        FilesKt.writeBytes((File)outfile, (byte[])byArray);
    }

    public static /* synthetic */ void main(String[] args) {
        ScoreCardMakerKt.main();
    }
}

