/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.scorecard;

import io.docops.docopsextensionssupport.scorecard.ScoreCard;
import io.docops.docopsextensionssupport.scorecard.ScoreCardMaker;
import io.docops.docopsextensionssupport.web.panel.PanelGeneratorKt;
import io.micrometer.core.annotation.Timed;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/scorecard"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\nH\u0017J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0012J\"\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0017J\u0018\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\u0010\u001a\u00020\u0011H\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/docops/docopsextensionssupport/scorecard/ScorecardController;", "", "()V", "log", "Lorg/apache/commons/logging/Log;", "kotlin.jvm.PlatformType", "fromJsonToScorecard", "Lorg/springframework/http/ResponseEntity;", "", "payload", "", "fromRequestParameter", "getScoreCard", "useDark", "", "putScorecard", "scoreCard", "Lio/docops/docopsextensionssupport/scorecard/ScoreCard;", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nScorecardController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScorecardController.kt\nio/docops/docopsextensionssupport/scorecard/ScorecardController\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,129:1\n79#2,5:130\n113#2,6:135\n119#2:142\n79#2,5:143\n113#2,7:148\n79#2,5:155\n113#2,7:160\n96#3:141\n96#3:167\n*S KotlinDebug\n*F\n+ 1 ScorecardController.kt\nio/docops/docopsextensionssupport/scorecard/ScorecardController\n*L\n54#1:130,5\n54#1:135,6\n54#1:142\n84#1:143,5\n84#1:148,7\n108#1:155,5\n108#1:160,7\n56#1:141\n117#1:167\n*E\n"})
public class ScorecardController {
    private final Log log = LogFactory.getLog(ScorecardController.class);

    @GetMapping(value={"/"})
    @ResponseBody
    @Timed(value="docops.getScoreCard")
    @NotNull
    public ResponseEntity<byte[]> getScoreCard(@RequestParam(name="payload") @NotNull String payload, @RequestParam(name="useDark", defaultValue="false") boolean useDark) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        try {
            boolean $i$f$measureTimedValue = false;
            TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            String string = URLDecoder.decode(payload, "UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
            String data = PanelGeneratorKt.uncompressString((String)string);
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            ScoreCard content = (ScoreCard)this_$iv.decodeFromString((DeserializationStrategy)ScoreCard.Companion.serializer(), data);
            ScoreCardMaker sm = new ScoreCardMaker();
            String svg = sm.make(content);
            HttpHeaders headers = new HttpHeaders();
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(new MediaType("image", "svg+xml", StandardCharsets.UTF_8));
            String string2 = svg;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            ResponseEntity result$iv$iv = new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
            TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
            this.log.info((Object)("getScoreCard executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms "));
            return (ResponseEntity)timing2.getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @PutMapping(value={"/"})
    @ResponseBody
    @Timed(value="docops.putScorecard")
    @NotNull
    public ResponseEntity<byte[]> putScorecard(@RequestBody @NotNull ScoreCard scoreCard) {
        Intrinsics.checkNotNullParameter((Object)scoreCard, (String)"scoreCard");
        try {
            boolean $i$f$measureTimedValue = false;
            TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTimedValue2 = false;
            long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            ScoreCardMaker sm = new ScoreCardMaker();
            String svg = sm.make(scoreCard);
            HttpHeaders headers = new HttpHeaders();
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(new MediaType("image", "svg+xml", StandardCharsets.UTF_8));
            String string = svg;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            ResponseEntity result$iv$iv = new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
            TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
            this.log.info((Object)("putScorecard executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms "));
            return (ResponseEntity)timing2.getValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    @PutMapping(value={"/form"})
    @ResponseBody
    @NotNull
    public ResponseEntity<byte[]> fromJsonToScorecard(@RequestParam(name="payload") @NotNull String payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        ResponseEntity result$iv$iv = this.fromRequestParameter(payload);
        TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.log.info((Object)("fromJsonToScorecard executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms "));
        return (ResponseEntity)timing2.getValue();
    }

    private ResponseEntity<byte[]> fromRequestParameter(String payload) {
        try {
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            ScoreCard scoreCard = (ScoreCard)this_$iv.decodeFromString((DeserializationStrategy)ScoreCard.Companion.serializer(), payload);
            ScoreCardMaker sm = new ScoreCardMaker();
            String svg = sm.make(scoreCard);
            HttpHeaders headers = new HttpHeaders();
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(new MediaType("image", "svg+xml", StandardCharsets.UTF_8));
            String string = svg;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }
}

