/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.support;

import io.docops.docopsextensionssupport.support.ColorUtilKt;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u00042\b\b\u0001\u0010\u0007\u001a\u00020\u0006H\u0017J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\t\u001a\u00020\nH\u0017J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00042\b\b\u0001\u0010\u0007\u001a\u00020\u0006H\u0017\u00a8\u0006\f"}, d2={"Lio/docops/docopsextensionssupport/support/ColorToGradientController;", "", "()V", "colors", "Lorg/springframework/http/ResponseEntity;", "", "", "color", "putColors", "httpServletRequest", "Ljakarta/servlet/http/HttpServletRequest;", "svgLinearGradient", "docops-extension-server"})
public class ColorToGradientController {
    @GetMapping(value={"/grad/{color}"})
    @NotNull
    public ResponseEntity<Map<String, String>> colors(@PathVariable(value="color") @NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        ResponseEntity responseEntity = ResponseEntity.accepted().body((Object)ColorUtilKt.gradientFromColor((String)color));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @PutMapping(value={"/grad"})
    @NotNull
    public ResponseEntity<String> putColors(@NotNull HttpServletRequest httpServletRequest) {
        Intrinsics.checkNotNullParameter((Object)httpServletRequest, (String)"httpServletRequest");
        String color = httpServletRequest.getParameter("gradColor");
        Intrinsics.checkNotNull((Object)color);
        Map gradient = ColorUtilKt.gradientFromColor((String)color);
        ResponseEntity responseEntity = ResponseEntity.accepted().body((Object)StringsKt.trimIndent((String)("\n            <div>\n        <svg width=\"200\" height=\"200\" viewBox=\"0 0 200.0 200.0\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" role=\"img\" aria-label=\"Docops: Color Gradient\" >\n    <defs>\n        <linearGradient id=\"grad1\" x2=\"0%\" y2=\"100%\">\n            <stop class=\"stop1\" offset=\"0%\" stop-color=\"" + gradient.get("color1") + "\"/>\n            <stop class=\"stop2\" offset=\"50%\" stop-color=\"" + gradient.get("color2") + "\"/>\n            <stop class=\"stop3\" offset=\"100%\" stop-color=\"" + gradient.get("color3") + "\"/>\n        </linearGradient>\n        <linearGradient id=\"grad2\" x1=\"0%\" y1=\"0%\" x2=\"100%\" y2=\"0%\">\n            <stop class=\"stop1\" offset=\"0%\" stop-color=\"" + gradient.get("color1") + "\"/>\n            <stop class=\"stop2\" offset=\"50%\" stop-color=\"" + gradient.get("color2") + "\"/>\n            <stop class=\"stop3\" offset=\"100%\" stop-color=\"" + gradient.get("color3") + "\"/>\n        </linearGradient>\n    </defs>\n    <rect x=\"0\" y=\"0\" width=\"100%\" height=\"50%\" fill=\"url(#grad1)\"/>\n    <rect x=\"00\" y=\"100\" width=\"100%\" height=\"50%\" fill=\"url(#grad2)\"/>\n</svg>    \n</div>\n<div class=\"divider\"></div>\n<div>\n<pre>\n    <code class=\"xml\">\n        &lt;linearGradient id=\"grad1\" x2=\"0%\" y2=\"100%\"&gt;\n            &lt;stop class=\"stop1\" offset=\"0%\" stop-color=\"" + gradient.get("color1") + "\"/&gt;\n            &lt;stop class=\"stop2\" offset=\"50%\" stop-color=\"" + gradient.get("color2") + "\"/&gt;\n            &lt;stop class=\"stop3\" offset=\"100%\" stop-color=\"" + gradient.get("color3") + "\"/&gt;\n        &lt;/linearGradient&gt;\n        &lt;linearGradient id=\"grad2\" x1=\"0%\" y1=\"0%\" x2=\"100%\" y2=\"0%\"&gt;\n            &lt;stop class=\"stop1\" offset=\"0%\" stop-color=\"" + gradient.get("color1") + "\"/&gt;\n            &lt;stop class=\"stop2\" offset=\"50%\" stop-color=\"" + gradient.get("color2") + "\"/&gt;\n            &lt;stop class=\"stop3\" offset=\"100%\" stop-color=\"" + gradient.get("color3") + "\"/&gt;\n        &lt;/linearGradient&gt;\n    </code>\n</pre>\n</div>\n<script>\ndocument.querySelectorAll('pre code').forEach((el) => {\n    hljs.highlightElement(el);\n});\n</script>\n        ")));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }

    @GetMapping(value={"/grad/svg/{color}"})
    @NotNull
    public ResponseEntity<String> svgLinearGradient(@PathVariable(value="color") @NotNull String color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Map gradient = ColorUtilKt.gradientFromColor((String)color);
        ResponseEntity responseEntity = ResponseEntity.accepted().body((Object)StringsKt.trimIndent((String)("\n        <linearGradient id=\"headerGreen\" x2=\"0%\" y2=\"100%\">\n            <stop class=\"stop1\" offset=\"0%\" stop-color=\"" + gradient.get("color1") + "\"/>\n            <stop class=\"stop2\" offset=\"50%\" stop-color=\"" + gradient.get("color2") + "\"/>\n            <stop class=\"stop3\" offset=\"100%\" stop-color=\"" + gradient.get("color3") + "\"/>\n        </linearGradient>\n        ")));
        Intrinsics.checkNotNullExpressionValue((Object)responseEntity, (String)"body(...)");
        return responseEntity;
    }
}

