/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.timeline;

import io.docops.docopsextensionssupport.badge.BadgeControllerKt;
import io.docops.docopsextensionssupport.svgsupport.SvgToPng;
import io.docops.docopsextensionssupport.timeline.Entry;
import io.docops.docopsextensionssupport.timeline.TimelineMaker;
import io.docops.docopsextensionssupport.timeline.TimelineParser;
import io.docops.docopsextensionssupport.web.panel.PanelGeneratorKt;
import io.micrometer.core.annotation.Timed;
import io.micrometer.observation.annotation.Observed;
import jakarta.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import kotlin.time.TimedValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/timeline"})
@Observed(name="timeline.controller")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JT\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\n2\b\b\u0001\u0010\f\u001a\u00020\n2\b\b\u0001\u0010\r\u001a\u00020\n2\b\b\u0001\u0010\u000e\u001a\u00020\n2\b\b\u0001\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\nH\u0017J\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\b\b\u0001\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\nH\u0017J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0017R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/docops/docopsextensionssupport/timeline/TimelineController;", "", "()V", "log", "Lorg/apache/commons/logging/Log;", "kotlin.jvm.PlatformType", "getTimeLine", "Lorg/springframework/http/ResponseEntity;", "", "payload", "", "title", "scale", "type", "numChars", "useDark", "", "outlineColor", "getTimeLineTable", "putTimeline", "httpServletRequest", "Ljakarta/servlet/http/HttpServletRequest;", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nTimelineController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimelineController.kt\nio/docops/docopsextensionssupport/timeline/TimelineController\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,197:1\n79#2,5:198\n113#2,7:203\n79#2,5:210\n113#2,7:215\n79#2,5:222\n113#2,6:227\n119#2:235\n1855#3,2:233\n*S KotlinDebug\n*F\n+ 1 TimelineController.kt\nio/docops/docopsextensionssupport/timeline/TimelineController\n*L\n58#1:198,5\n58#1:203,7\n142#1:210,5\n142#1:215,7\n175#1:222,5\n175#1:227,6\n175#1:235\n183#1:233,2\n*E\n"})
public class TimelineController {
    private final Log log = LogFactory.getLog(TimelineController.class);

    @PutMapping(value={"/"})
    @ResponseBody
    @Timed(value="docops.timeline.put.html")
    @NotNull
    public ResponseEntity<byte[]> putTimeline(@NotNull HttpServletRequest httpServletRequest) {
        String numChars;
        Intrinsics.checkNotNullParameter((Object)httpServletRequest, (String)"httpServletRequest");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        String title = "title";
        String contents = httpServletRequest.getParameter("content");
        CharSequence charSequence = contents;
        if (charSequence == null || charSequence.length() == 0) {
            contents = StreamUtils.copyToString((InputStream)((InputStream)httpServletRequest.getInputStream()), (Charset)Charset.defaultCharset());
            String string = httpServletRequest.getParameter("title");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParameter(...)");
            title = string;
        }
        String scale = httpServletRequest.getParameter("scale");
        String chars = numChars = httpServletRequest.getParameter("numChars");
        if (numChars == null || ((CharSequence)numChars).length() == 0) {
            chars = "24";
        }
        String outlineColor = httpServletRequest.getParameter("outline");
        String useDarkInput = httpServletRequest.getParameter("useDark");
        boolean bl2 = Intrinsics.areEqual((Object)"on", (Object)useDarkInput);
        Intrinsics.checkNotNull((Object)outlineColor);
        TimelineMaker tm = new TimelineMaker(bl2, outlineColor);
        String string = contents;
        Intrinsics.checkNotNull((Object)string);
        String string2 = string;
        Intrinsics.checkNotNull((Object)scale);
        string = chars;
        Intrinsics.checkNotNull((Object)string);
        String svg = tm.makeTimelineSvg(string2, title, scale, false, string);
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(MediaType.parseMediaType((String)"text/html"));
        String div = StringsKt.trimIndent((String)("\n        <div class=\"collapse collapse-arrow border-base-300\">\n            <input type=\"radio\" name=\"my-accordion-2\" checked=\"checked\" />\n            <div class=\"collapse-title text-xl font-small\">\n                Image\n            </div>\n            <div class=\"collapse-content\">\n                <div id='imageblock'>\n                " + svg + "\n                </div>\n            </div>\n        </div>\n        <div class=\"collapse collapse-arrow border-base-300\">\n            <input type=\"radio\" name=\"my-accordion-2\" />\n            <div class=\"collapse-title text-xl font-small\">\n                Click to View Source\n            </div>\n            <div class=\"collapse-content\">\n                <h3>Adr Source</h3>\n                <div>\n                <pre>\n                <code class=\"kotlin\">\n                 " + contents + "\n                </code>\n                </pre>\n                </div>\n                <script>\n                var adrSource = `[timeline,title=\"Demo timeline Builder by docops.io\",scale=\"0.7\",role=\"center\"]\\n----\\n" + contents + "\\n----`;\n                document.querySelectorAll('pre code').forEach((el) => {\n                    hljs.highlightElement(el);\n                });\n                </script>\n            </div>\n        </div>\n        "));
        byte[] byArray = div.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ResponseEntity result$iv$iv = new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.log.info((Object)("putTimeline executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms "));
        return (ResponseEntity)timing2.getValue();
    }

    @GetMapping(value={"/"})
    @ResponseBody
    @Timed(value="docops.roadmap.get.html")
    @NotNull
    public ResponseEntity<byte[]> getTimeLine(@RequestParam(name="payload") @NotNull String payload, @RequestParam(name="title") @NotNull String title, @RequestParam(name="scale") @NotNull String scale, @RequestParam(value="type", required=false, defaultValue="SVG") @NotNull String type, @RequestParam(value="numChars", required=false, defaultValue="35") @NotNull String numChars, @RequestParam(name="useDark", defaultValue="false") boolean useDark, @RequestParam(name="outlineColor", defaultValue="#37cdbe") @NotNull String outlineColor) {
        ResponseEntity responseEntity;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)numChars, (String)"numChars");
        Intrinsics.checkNotNullParameter((Object)outlineColor, (String)"outlineColor");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        String string = URLDecoder.decode(payload, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        String data = PanelGeneratorKt.uncompressString((String)string);
        TimelineMaker tm = new TimelineMaker(useDark, outlineColor);
        boolean isPdf = Intrinsics.areEqual((Object)"PDF", (Object)type);
        String svg = tm.makeTimelineSvg(data, title, scale, isPdf, numChars);
        HttpHeaders headers = new HttpHeaders();
        if (isPdf) {
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(MediaType.IMAGE_PNG);
            Pair res = BadgeControllerKt.findHeightWidth((String)svg);
            byte[] baos = new SvgToPng().toPngFromSvg(svg, res);
            responseEntity = new ResponseEntity((Object)baos, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        } else {
            headers.setCacheControl(CacheControl.noCache().getHeaderValue());
            headers.setContentType(MediaType.parseMediaType((String)"image/svg+xml"));
            byte[] byArray = svg.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            responseEntity = new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        }
        ResponseEntity result$iv$iv = responseEntity;
        TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.log.info((Object)("getTimeLine executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms "));
        return (ResponseEntity)timing2.getValue();
    }

    @GetMapping(value={"/table"})
    @ResponseBody
    @Timed(value="docops.roadmap.table.data.html")
    @NotNull
    public ResponseEntity<byte[]> getTimeLineTable(@RequestParam(name="payload") @NotNull String payload, @RequestParam(name="title") @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        boolean $i$f$measureTimedValue = false;
        TimeSource.Monotonic $this$measureTimedValue$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTimedValue2 = false;
        long mark$iv$iv = $this$measureTimedValue$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        String string = URLDecoder.decode(payload, "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(...)");
        String data = PanelGeneratorKt.uncompressString((String)string);
        TimelineParser tm = new TimelineParser();
        List entries = tm.parse(data);
        StringBuilder sb = new StringBuilder("." + title + "\n");
        sb.append("[%header,cols=\"1,2\",stripes=even]\n");
        sb.append("!===\n");
        sb.append("|Date |Event\n");
        Iterable $this$forEach$iv = entries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entry it = (Entry)element$iv;
            boolean bl2 = false;
            sb.append("a|" + it.getDate() + " |" + it.getText() + "\n");
        }
        sb.append("!===");
        HttpHeaders headers = new HttpHeaders();
        headers.setCacheControl(CacheControl.noCache().getHeaderValue());
        headers.setContentType(MediaType.TEXT_PLAIN);
        String string2 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        ResponseEntity result$iv$iv = new ResponseEntity((Object)byArray, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
        TimedValue timing2 = new TimedValue((Object)result$iv$iv, TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv), null);
        this.log.info((Object)("getTimeLineTable executed in " + Duration.getInWholeMilliseconds-impl((long)timing2.getDuration-UwyO8pc()) + "ms "));
        return (ResponseEntity)timing2.getValue();
    }
}

