/*
 * Decompiled with CFR 0.152.
 */
package io.docops.docopsextensionssupport.timeline;

import io.docops.asciidoc.utils.StringFunctionsKt;
import io.docops.docopsextensionssupport.support.ColorUtilKt;
import io.docops.docopsextensionssupport.timeline.Entry;
import io.docops.docopsextensionssupport.timeline.EntryKt;
import io.docops.docopsextensionssupport.timeline.TimelineMaker;
import io.docops.docopsextensionssupport.timeline.TimelineParser;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 )2\u00020\u0001:\u0001)B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0005H\u0002J6\u0010\u0014\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00050\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J0\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000fH\u0002J*\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000f0\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\"\u001a\u00020\u0005H\u0002J0\u0010#\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000fH\u0002J.\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0005J0\u0010'\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u000fH\u0002J\b\u0010(\u001a\u00020\u0005H\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006*"}, d2={"Lio/docops/docopsextensionssupport/timeline/TimelineMaker;", "", "useDark", "", "outlineColor", "", "(ZLjava/lang/String;)V", "fillColor", "getOutlineColor", "()Ljava/lang/String;", "textColor", "getUseDark", "()Z", "buildRoad", "width", "", "dateTotSpan", "date", "x", "dy", "defs", "Lkotlin/Pair;", "", "entries", "", "Lio/docops/docopsextensionssupport/timeline/Entry;", "isPdf", "even", "index", "entry", "color", "chars", "gradIndex", "head", "scale", "makeEntry", "makeTimelineSvg", "source", "title", "odd", "tail", "Companion", "docops-extension-server"})
@SourceDebugExtension(value={"SMAP\nTimelineMaker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimelineMaker.kt\nio/docops/docopsextensionssupport/timeline/TimelineMaker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,359:1\n1864#2,3:360\n1855#2,2:363\n1864#2,3:365\n1864#2,3:368\n*S KotlinDebug\n*F\n+ 1 TimelineMaker.kt\nio/docops/docopsextensionssupport/timeline/TimelineMaker\n*L\n89#1:360,3\n178#1:363,2\n200#1:365,3\n223#1:368,3\n*E\n"})
public final class TimelineMaker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean useDark;
    @NotNull
    private final String outlineColor;
    @NotNull
    private String textColor;
    @NotNull
    private String fillColor;
    @NotNull
    private static final List<String> DEFAULT_COLORS;
    private static final float DEFAULT_HEIGHT;

    public TimelineMaker(boolean useDark, @NotNull String outlineColor) {
        Intrinsics.checkNotNullParameter((Object)outlineColor, (String)"outlineColor");
        this.useDark = useDark;
        this.outlineColor = outlineColor;
        this.textColor = "#000000";
        this.fillColor = "#fcfcfc";
        if (this.useDark) {
            this.textColor = "#fcfcfc";
            this.fillColor = "#17242b";
        }
    }

    public final boolean getUseDark() {
        return this.useDark;
    }

    @NotNull
    public final String getOutlineColor() {
        return this.outlineColor;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String makeTimelineSvg(@NotNull String source, @NotNull String title, @NotNull String scale, boolean isPdf, @NotNull String chars) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)chars, (String)"chars");
        List entries = new TimelineParser().parse(source);
        StringBuilder sb = new StringBuilder();
        Pair head = this.head(entries, scale);
        sb.append((String)head.getFirst());
        Pair defs = this.defs(entries, isPdf);
        Map colors = (Map)defs.getSecond();
        sb.append((String)defs.getFirst());
        String titleFill = "#000000";
        if (this.useDark) {
            titleFill = "#fcfcfc";
        }
        if (this.useDark) {
            sb.append("<rect width='100%' height='100%' fill='#17242b'/>");
        } else {
            sb.append("<rect width='100%' height='100%' fill='#fcfcfc'/>");
        }
        sb.append("<g transform=\"scale(" + scale + ")\">");
        sb.append("<text x=\"" + ((Number)head.getSecond()).intValue() / 2 + "\" y=\"40\" text-anchor=\"middle\" style=\"font-size: 24px;font-family: Arial, sans-serif; font-variant:small-caps\" class=\"edge\" fill=\"" + titleFill + "\">" + StringFunctionsKt.escapeXml((String)title) + "</text>");
        sb.append("<g transform=\"translate(0,24) scale(1.0)\">");
        sb.append(this.buildRoad(((Number)head.getSecond()).intValue() - 100));
        int gradIndex = RangesKt.random((IntRange)RangesKt.until((int)0, (int)entries.size()), (Random)((Random)Random.Default));
        Iterable $this$forEachIndexed$iv = entries;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void entry;
            CharSequence charSequence;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Entry entry2 = (Entry)item$iv;
            int index = n;
            boolean bl = false;
            CharSequence charSequence2 = this.outlineColor;
            if (StringsKt.isBlank((CharSequence)charSequence2)) {
                boolean bl2 = false;
                charSequence = (String)DEFAULT_COLORS.get(gradIndex);
            } else {
                charSequence = charSequence2;
            }
            String color = (String)charSequence;
            sb.append(this.makeEntry(index, (Entry)entry, color, chars, gradIndex));
        }
        sb.append("</g>");
        sb.append("</g>");
        sb.append(this.tail());
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String makeEntry(int index, Entry entry, String color, String chars, int gradIndex) {
        return index % 2 == 0 ? this.odd(index, entry, color, chars, gradIndex) : this.even(index, entry, color, chars, gradIndex);
    }

    private final String odd(int index, Entry entry, String color, String chars, int gradIndex) {
        int x = 0;
        if (index > 0) {
            x += 125 * index;
        }
        String text = EntryKt.toTextWithSpan((Entry)entry, (float)Float.parseFloat(chars), (int)20, (int)200, (String)"odd", (int)14, (String)this.textColor);
        return StringsKt.trimIndent((String)("\n      <g transform=\"translate(" + x + ",0)\" class=\"odd\">\n        <g transform=\"translate(125,500)\">\n            <circle cx=\"0\" cy=\"0\" r=\"20\" fill=\"#fcfcfc\" />\n            <circle cx=\"0\" cy=\"0\" r=\"17\" fill=\"url(#outlineGradient)\" />\n            <line x1=\"0\" x2=\"0\" y1=\"-20\" y2=\"-95\" stroke=\"" + color + "\" stroke-width=\"2\"/>\n                <g transform=\"translate(-2.5,-92),rotate(-90)\">\n                    <polygon points=\"0,5 0,0 5,2.5\" fill=\"url(#arrowColor)\" stroke-width=\"3\" stroke=\"url(#arrowColor)\"/>\n                </g>\n        </g>\n        <rect x=\"10\" y=\"150\" width=\"225\" height=\"250\" fill=\"" + this.fillColor + "\" stroke=\"" + color + "\" stroke-width=\"2\" rx=\"5\"/>\n        <rect x=\"10\" y=\"150\" width=\"225\" height=\"40\" fill=\"url(#topBar)\" stroke=\"" + color + "\" stroke-width=\"2\" rx=\"5\"/>\n        <text x=\"125\" y=\"175\" fill='#000000' text-anchor='middle'\n                  style=\"font-family: Arial, Helvetica, sans-serif;  text-anchor:middle; font-size: 20px; fill: #fcfcfc; letter-spacing: normal;font-weight: bold;font-variant: small-caps;\"\n                  class=\"glass raiseText\">\n                  " + entry.getDate() + "\n        </text>\n        " + text + "\n    </g>\n    \n        "));
    }

    private final String even(int index, Entry entry, String color, String chars, int gradIndex) {
        int x = 0;
        if (index > 0) {
            x += 125 * index;
        }
        String text = EntryKt.toTextWithSpan((Entry)entry, (float)Float.parseFloat(chars), (int)20, (int)650, (String)"even", (int)14, (String)this.textColor);
        return StringsKt.trimIndent((String)("\n        <g transform=\"translate(" + x + ",0)\" class=\"even\">\n        <g transform=\"translate(125,500)\">\n            <circle cx=\"0\" cy=\"0\" r=\"20\" fill=\"#fcfcfc\" />\n            <circle cx=\"0\" cy=\"0\" r=\"17\" fill=\"url(#outlineGradient)\" />\n            <line x1=\"0\" x2=\"0\" y1=\"20\" y2=\"95\" stroke=\"" + color + "\" stroke-width=\"2\"/>\n            <g transform=\"translate(2.5,92),rotate(90)\">\n                <polygon points=\"0,5 0,0 5,2.5\" fill=\"url(#arrowColor)\" stroke-width=\"3\" stroke=\"url(#arrowColor)\"/>\n            </g>\n        </g>\n        \n        <rect x=\"10\" y=\"600\" width=\"225\" height=\"250\" fill=\"" + this.fillColor + "\" stroke=\"" + color + "\" stroke-width=\"2\" rx=\"5\"/>\n        <rect x=\"10\" y=\"600\" width=\"225\" height=\"40\" fill=\"url(#topBar)\" stroke-width=\"2\" rx=\"5\" />\n        \n        <text x=\"125\" y=\"625\" fill='#000000' text-anchor='middle'\n                  style=\"font-family: Arial, Helvetica, sans-serif;  text-anchor:middle; font-size: 20px; fill: #fcfcfc; letter-spacing: normal;font-weight: bold;font-variant: small-caps;\"\n                  class=\"glass raiseText\">\n                  " + entry.getDate() + "\n        </text>\n        " + text + "\n    </g>\n    \n        "));
    }

    private final String dateTotSpan(String date, int x, int dy, String textColor) {
        String[] stringArray = new String[]{" "};
        List sp = StringsKt.split$default((CharSequence)date, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = sp;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            sb.append("<tspan x=\"" + x + "\" dy=\"" + dy + "\" fill=\"" + textColor + "\">" + StringFunctionsKt.escapeXml((String)it) + "</tspan>");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String buildRoad(int width) {
        return StringsKt.trimIndent((String)("\n            <g transform=\"translate(30,500)\">\n            <path d=\"M0,0 h" + width + "\" stroke=\"#aaaaaa\" stroke-width=\"28\" fill=\"url(#arrowColor)\" class=\"raise\"\n                  stroke-linecap=\"round\" stroke-linejoin=\"round\"/>\n            <line x1=\"10\" y1=\"0\" x2=\"" + width + "\" y2=\"0\" stroke=\"#fcfcfc\"\n                  stroke-width=\"10\" fill=\"#ffffff\" stroke-dasharray=\"24 24 24\" stroke-linecap=\"round\"\n                  stroke-linejoin=\"round\"/>\n            <g transform=\"translate(" + width + ",-2)\">\n                <polygon points=\"0,5 0,0 5,2.5\" stroke=\"url(#arrowColor)\" stroke-width=\"35\" fill=\"url(#arrowColor)\"\n                />\n            </g>\n        </g>\n        "));
    }

    private final Pair<String, Integer> head(List<Entry> entries, String scale) {
        int width = 0;
        Iterable $this$forEachIndexed$iv = entries;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Entry entry = (Entry)item$iv;
            int index = n;
            boolean bl = false;
            width = 140 * index + 80;
        }
        float scaleF = Float.parseFloat(scale);
        float height = DEFAULT_HEIGHT * Float.parseFloat(scale);
        return new Pair((Object)StringsKt.trimIndent((String)("\n        <svg width=\"" + (float)(width += 140) * scaleF + "\" height=\"" + height + "\" viewBox=\"0 0 " + (float)width * scaleF + " " + height + "\"\n        preserveAspectRatio=\"xMidYMin slice\"\n        xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n        <desc>https://docops.io/extension</desc>\n    ")), (Object)width);
    }

    private final String tail() {
        return "</svg>";
    }

    private final Pair<String, Map<Integer, String>> defs(List<Entry> entries, boolean isPdf) {
        Map colors = new LinkedHashMap();
        String linkColor = "#0000bb";
        if (this.useDark) {
            linkColor = "#7dc4e6";
        }
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEachIndexed$iv = entries;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Entry cfr_ignored_0 = (Entry)item$iv;
            int index = n;
            boolean bl = false;
            String color = index > 9 ? ColorUtilKt.getRandomColorHex() : (String)DEFAULT_COLORS.get(index);
            Integer n2 = index;
            colors.put(n2, color);
            Map colorMap = ColorUtilKt.gradientFromColor((String)color);
            sb.append(StringsKt.trimIndent((String)("\n         <radialGradient id=\"grad" + index + "\" cx=\"50%\" cy=\"50%\" r=\"50%\" fx=\"50%\" fy=\"20%\">\n            <stop offset=\"30%\" style=\"stop-color:" + colorMap.get("color1") + "; stop-opacity:1\" />\n            <stop offset=\"60%\" style=\"stop-color:" + color + "; stop-opacity:1\" />\n        </radialGradient>\n        <linearGradient id=\"headerTimeline" + index + "\" x2=\"0%\" y2=\"100%\">\n            <stop class=\"stop1\" offset=\"0%\" stop-color=\"" + colorMap.get("color1") + "\"/>\n            <stop class=\"stop2\" offset=\"50%\" stop-color=\"" + colorMap.get("color2") + "\"/>\n            <stop class=\"stop3\" offset=\"100%\" stop-color=\"" + colorMap.get("color3") + "\"/>\n        </linearGradient>\n            ")));
        }
        Map colorMap = ColorUtilKt.gradientFromColor((String)this.outlineColor);
        sb.append("<radialGradient id=\"outlineGradient\" cx=\"50%\" cy=\"50%\" r=\"50%\" fx=\"50%\" fy=\"20%\">\n            <stop offset=\"30%\" style=\"stop-color:" + colorMap.get("color1") + "; stop-opacity:1\" />\n            <stop offset=\"60%\" style=\"stop-color:" + this.outlineColor + "; stop-opacity:1\" />\n        </radialGradient>");
        String style = StringsKt.trimIndent((String)("\n<style>\n    .edge { filter: drop-shadow(0 2mm 2mm #66557c); }\n    .cricleedge { filter: drop-shadow(0 2mm 2mm #a899bd); }\n    .odd { font-size:14px; font-family: Arial, sans-serif; fill: #000000;}\n    .even { font-size:14px; font-family: Arial, sans-serif; fill: #000000;}\n    .rmLink { fill: " + linkColor + "; text-decoration: underline; }\n</style>\n        "));
        if (isPdf) {
            style = "";
        }
        return new Pair((Object)StringsKt.trimIndent((String)("\n        <defs>\n        <filter id=\"buttonBlur\">\n            <feGaussianBlur in=\"SourceAlpha\" stdDeviation=\"2\" result=\"blur\"/>\n            <feOffset in=\"blur\" dy=\"2\" result=\"offsetBlur\"/>\n            <feMerge>\n                <feMergeNode in=\"offsetBlur\"/>\n                <feMergeNode in=\"SourceGraphic\"/>\n            </feMerge>\n        </filter>\n\n        <linearGradient id=\"overlayGrad\" gradientUnits=\"userSpaceOnUse\" x1=\"95\" y1=\"-20\" x2=\"95\" y2=\"70\">\n            <stop offset=\"0\" stop-color=\"#000000\" stop-opacity=\"0.5\"/>\n            <stop offset=\"1\" stop-color=\"#000000\" stop-opacity=\"0\"/>\n        </linearGradient>\n\n        <filter id=\"topshineBlur\">\n            <feGaussianBlur stdDeviation=\"0.93\"/>\n        </filter>\n\n        <linearGradient id=\"topshineGrad\" gradientUnits=\"userSpaceOnUse\" x1=\"95\" y1=\"0\" x2=\"95\" y2=\"40\">\n            <stop offset=\"0\" stop-color=\"#ffffff\" stop-opacity=\"1\"/>\n            <stop offset=\"1\" stop-color=\"#ffffff\" stop-opacity=\"0\"/>\n        </linearGradient>\n\n        <filter id=\"bottomshine\">\n            <feGaussianBlur stdDeviation=\"0.95\"/>\n        </filter>\n        <linearGradient id=\"panelBack\" x2=\"1\" y2=\"1\">\n            <stop class=\"stop1\" offset=\"0%\" stop-color=\"#939393\"/>\n            <stop class=\"stop2\" offset=\"50%\" stop-color=\"#5d5d5d\"/>\n            <stop class=\"stop3\" offset=\"100%\" stop-color=\"#282828\"/>\n        </linearGradient>\n        <linearGradient id=\"arrowColor\" x2=\"0%\" y2=\"100%\">\n            <stop class=\"stop1\" offset=\"0%\" stop-color=\"" + colorMap.get("color1") + "\"/>\n            <stop class=\"stop2\" offset=\"50%\" stop-color=\"" + colorMap.get("color2") + "\"/>\n            <stop class=\"stop3\" offset=\"100%\" stop-color=\"" + colorMap.get("color3") + "\"/>\n        </linearGradient>\n        <linearGradient id=\"topBar\" x2=\"0%\" y2=\"100%\">\n            <stop class=\"stop1\" offset=\"0%\" stop-color=\"" + colorMap.get("color1") + "\"/>\n            <stop class=\"stop2\" offset=\"50%\" stop-color=\"" + colorMap.get("color2") + "\"/>\n            <stop class=\"stop3\" offset=\"100%\" stop-color=\"" + colorMap.get("color3") + "\"/>\n        </linearGradient>\n        <marker\n                id=\"triangle\"\n                viewBox=\"0 0 10 10\"\n                refX=\"1\"\n                refY=\"5\"\n                markerUnits=\"strokeWidth\"\n                markerWidth=\"5\"\n                markerHeight=\"5\"\n                orient=\"auto\">\n            <path d=\"M 0 0 L 10 5 L 0 10 z\" fill=\"#aaaaaa\" />\n         </marker>   \n        " + sb + "\n        " + style + "\n    </defs>\n    \n    ")), (Object)colors);
    }

    public static final /* synthetic */ List access$getDEFAULT_COLORS$cp() {
        return DEFAULT_COLORS;
    }

    public static final /* synthetic */ float access$getDEFAULT_HEIGHT$cp() {
        return DEFAULT_HEIGHT;
    }

    static {
        Object[] objectArray = new String[]{"#45618E", "#A43B3B", "#FFD373", "#F7E67A", "#01FF90", "#FF6F36", "#EAA213", "#FFAF10", "#FF7F00", "#6D4F98"};
        DEFAULT_COLORS = CollectionsKt.mutableListOf((Object[])objectArray);
        DEFAULT_HEIGHT = 1000.0f;
    }
}

