/*
 * Decompiled with CFR 0.152.
 */
package io.documentnode.epub4j.domain;

import io.documentnode.epub4j.domain.Relator;
import io.documentnode.epub4j.util.StringUtil;
import java.io.Serializable;

public class Author
implements Serializable {
    private static final long serialVersionUID = 6663408501416574200L;
    private String firstname;
    private String lastname;
    private Relator relator = Relator.AUTHOR;

    public Author(String singleName) {
        this("", singleName);
    }

    public Author(String firstname, String lastname) {
        this.firstname = firstname;
        this.lastname = lastname;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String toString() {
        return this.lastname + ", " + this.firstname;
    }

    public int hashCode() {
        return StringUtil.hashCode(this.firstname, this.lastname);
    }

    public boolean equals(Object authorObject) {
        if (!(authorObject instanceof Author)) {
            return false;
        }
        Author other = (Author)authorObject;
        return StringUtil.equals(this.firstname, other.firstname) && StringUtil.equals(this.lastname, other.lastname);
    }

    public Relator setRole(String code) {
        Relator result = Relator.byCode(code);
        if (result == null) {
            result = Relator.AUTHOR;
        }
        this.relator = result;
        return result;
    }

    public Relator getRelator() {
        return this.relator;
    }

    public void setRelator(Relator relator) {
        this.relator = relator;
    }
}

