/*
 * Decompiled with CFR 0.152.
 */
package io.documentnode.epub4j.domain;

import io.documentnode.epub4j.domain.Guide;
import io.documentnode.epub4j.domain.GuideReference;
import io.documentnode.epub4j.domain.Metadata;
import io.documentnode.epub4j.domain.Resource;
import io.documentnode.epub4j.domain.Resources;
import io.documentnode.epub4j.domain.Spine;
import io.documentnode.epub4j.domain.SpineReference;
import io.documentnode.epub4j.domain.TOCReference;
import io.documentnode.epub4j.domain.TableOfContents;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Book
implements Serializable {
    private static final long serialVersionUID = 2068355170895770100L;
    private Resources resources = new Resources();
    private Metadata metadata = new Metadata();
    private Spine spine = new Spine();
    private TableOfContents tableOfContents = new TableOfContents();
    private Guide guide = new Guide();
    private Resource opfResource;
    private Resource ncxResource;
    private Resource coverImage;

    public TOCReference addSection(TOCReference parentSection, String sectionTitle, Resource resource) {
        return this.addSection(parentSection, sectionTitle, resource, null);
    }

    public TOCReference addSection(TOCReference parentSection, String sectionTitle, Resource resource, String fragmentId) {
        this.getResources().add(resource);
        if (this.spine.findFirstResourceById(resource.getId()) < 0) {
            this.spine.addSpineReference(new SpineReference(resource));
        }
        return parentSection.addChildSection(new TOCReference(sectionTitle, resource, fragmentId));
    }

    public TOCReference addSection(String title, Resource resource) {
        return this.addSection(title, resource, null);
    }

    public TOCReference addSection(String title, Resource resource, String fragmentId) {
        this.getResources().add(resource);
        TOCReference tocReference = this.tableOfContents.addTOCReference(new TOCReference(title, resource, fragmentId));
        if (this.spine.findFirstResourceById(resource.getId()) < 0) {
            this.spine.addSpineReference(new SpineReference(resource));
        }
        return tocReference;
    }

    public void generateSpineFromTableOfContents() {
        Spine spine = new Spine(this.tableOfContents);
        spine.setTocResource(this.spine.getTocResource());
        this.spine = spine;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public Resource addResource(Resource resource) {
        return this.resources.add(resource);
    }

    public Resources getResources() {
        return this.resources;
    }

    public Spine getSpine() {
        return this.spine;
    }

    public void setSpine(Spine spine) {
        this.spine = spine;
    }

    public TableOfContents getTableOfContents() {
        return this.tableOfContents;
    }

    public void setTableOfContents(TableOfContents tableOfContents) {
        this.tableOfContents = tableOfContents;
    }

    public Resource getCoverPage() {
        Resource coverPage = this.guide.getCoverPage();
        if (coverPage == null) {
            coverPage = this.spine.getResource(0);
        }
        return coverPage;
    }

    public void setCoverPage(Resource coverPage) {
        if (coverPage == null) {
            return;
        }
        if (!this.resources.containsByHref(coverPage.getHref())) {
            this.resources.add(coverPage);
        }
        this.guide.setCoverPage(coverPage);
    }

    public String getTitle() {
        return this.getMetadata().getFirstTitle();
    }

    public Resource getCoverImage() {
        return this.coverImage;
    }

    public void setCoverImage(Resource coverImage) {
        if (coverImage == null) {
            return;
        }
        if (!this.resources.containsByHref(coverImage.getHref())) {
            this.resources.add(coverImage);
        }
        this.coverImage = coverImage;
    }

    public Guide getGuide() {
        return this.guide;
    }

    public List<Resource> getContents() {
        LinkedHashMap<String, Resource> result = new LinkedHashMap<String, Resource>();
        Book.addToContentsResult(this.getCoverPage(), result);
        for (SpineReference spineReference : this.getSpine().getSpineReferences()) {
            Book.addToContentsResult(spineReference.getResource(), result);
        }
        for (Resource resource : this.getTableOfContents().getAllUniqueResources()) {
            Book.addToContentsResult(resource, result);
        }
        for (GuideReference guideReference : this.getGuide().getReferences()) {
            Book.addToContentsResult(guideReference.getResource(), result);
        }
        return new ArrayList<Resource>(result.values());
    }

    private static void addToContentsResult(Resource resource, Map<String, Resource> allReachableResources) {
        if (resource != null && !allReachableResources.containsKey(resource.getHref())) {
            allReachableResources.put(resource.getHref(), resource);
        }
    }

    public Resource getOpfResource() {
        return this.opfResource;
    }

    public void setOpfResource(Resource opfResource) {
        this.opfResource = opfResource;
    }

    public void setNcxResource(Resource ncxResource) {
        this.ncxResource = ncxResource;
    }

    public Resource getNcxResource() {
        return this.ncxResource;
    }
}

