/*
 * Decompiled with CFR 0.152.
 */
package io.documentnode.epub4j.domain;

import io.documentnode.epub4j.domain.LazyResourceProvider;
import io.documentnode.epub4j.domain.MediaTypes;
import io.documentnode.epub4j.domain.Resource;
import io.documentnode.epub4j.util.IOUtil;
import io.documentnode.minilog.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LazyResource
extends Resource {
    private static final long serialVersionUID = 5089400472352002866L;
    private static final Logger log = Logger.create(LazyResource.class);
    private final LazyResourceProvider resourceProvider;
    private final long cachedSize;

    public LazyResource(LazyResourceProvider resourceProvider, String href) {
        this(resourceProvider, -1L, href);
    }

    public LazyResource(LazyResourceProvider resourceProvider, long size, String href) {
        super(null, null, href, MediaTypes.determineMediaType(href));
        this.resourceProvider = resourceProvider;
        this.cachedSize = size;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isInitialized()) {
            return new ByteArrayInputStream(this.getData());
        }
        return this.resourceProvider.getResourceStream(this.originalHref);
    }

    public void initialize() throws IOException {
        this.getData();
    }

    @Override
    public byte[] getData() throws IOException {
        if (this.data == null) {
            log.debug("Initializing lazy resource: " + this.getHref());
            InputStream in = this.resourceProvider.getResourceStream(this.originalHref);
            byte[] readData = IOUtil.toByteArray(in, (int)this.cachedSize);
            if (readData == null) {
                throw new IOException("Could not load the contents of resource: " + this.getHref());
            }
            this.data = readData;
            in.close();
        }
        return this.data;
    }

    @Override
    public void close() {
        if (this.resourceProvider != null) {
            this.data = null;
        }
    }

    public boolean isInitialized() {
        return this.data != null;
    }

    @Override
    public long getSize() {
        if (this.data != null) {
            return this.data.length;
        }
        return this.cachedSize;
    }
}

