/*
 * Decompiled with CFR 0.152.
 */
package io.documentnode.epub4j.epub;

import io.documentnode.epub4j.domain.Book;
import io.documentnode.epub4j.epub.BookProcessor;
import io.documentnode.minilog.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BookProcessorPipeline
implements BookProcessor {
    private Logger log = Logger.create(BookProcessorPipeline.class);
    private List<BookProcessor> bookProcessors;

    public BookProcessorPipeline() {
        this(null);
    }

    public BookProcessorPipeline(List<BookProcessor> bookProcessingPipeline) {
        this.bookProcessors = bookProcessingPipeline;
    }

    @Override
    public Book processBook(Book book) {
        if (this.bookProcessors == null) {
            return book;
        }
        for (BookProcessor bookProcessor : this.bookProcessors) {
            try {
                book = bookProcessor.processBook(book);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
        }
        return book;
    }

    public void addBookProcessor(BookProcessor bookProcessor) {
        if (this.bookProcessors == null) {
            this.bookProcessors = new ArrayList<BookProcessor>();
        }
        this.bookProcessors.add(bookProcessor);
    }

    public void addBookProcessors(Collection<BookProcessor> bookProcessors) {
        if (this.bookProcessors == null) {
            this.bookProcessors = new ArrayList<BookProcessor>();
        }
        this.bookProcessors.addAll(bookProcessors);
    }

    public List<BookProcessor> getBookProcessors() {
        return this.bookProcessors;
    }

    public void setBookProcessingPipeline(List<BookProcessor> bookProcessingPipeline) {
        this.bookProcessors = bookProcessingPipeline;
    }
}

