/*
 * Decompiled with CFR 0.152.
 */
package io.documentnode.epub4j.epub;

import io.documentnode.minilog.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.kxml2.io.KXmlSerializer;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlSerializer;

public class EpubProcessorSupport {
    private static final Logger log = Logger.create(EpubProcessorSupport.class);
    protected static DocumentBuilderFactory documentBuilderFactory;

    private static void init() {
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setValidating(false);
    }

    public static XmlSerializer createXmlSerializer(OutputStream out) throws UnsupportedEncodingException {
        return EpubProcessorSupport.createXmlSerializer(new OutputStreamWriter(out, "UTF-8"));
    }

    public static XmlSerializer createXmlSerializer(Writer out) {
        KXmlSerializer result = null;
        try {
            result = new KXmlSerializer();
            result.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            result.setOutput(out);
        }
        catch (Exception e) {
            log.error("When creating XmlSerializer: " + e.getClass().getName() + ": " + e.getMessage());
        }
        return result;
    }

    public static EntityResolver getEntityResolver() {
        return new EntityResolverImpl();
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() {
        return documentBuilderFactory;
    }

    public static DocumentBuilder createDocumentBuilder() {
        DocumentBuilder result = null;
        try {
            result = documentBuilderFactory.newDocumentBuilder();
            result.setEntityResolver(EpubProcessorSupport.getEntityResolver());
        }
        catch (ParserConfigurationException e) {
            log.error(e.getMessage());
        }
        return result;
    }

    static {
        EpubProcessorSupport.init();
    }

    static class EntityResolverImpl
    implements EntityResolver {
        private String previousLocation;

        EntityResolverImpl() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            String resourcePath;
            if (systemId.startsWith("http:")) {
                URL url = new URL(systemId);
                resourcePath = "dtd/" + url.getHost() + url.getPath();
                this.previousLocation = resourcePath.substring(0, resourcePath.lastIndexOf(47));
            } else {
                resourcePath = this.previousLocation + systemId.substring(systemId.lastIndexOf(47));
            }
            if (this.getClass().getClassLoader().getResource(resourcePath) == null) {
                throw new RuntimeException("remote resource is not cached : [" + systemId + "] cannot continue");
            }
            InputStream in = EpubProcessorSupport.class.getClassLoader().getResourceAsStream(resourcePath);
            return new InputSource(in);
        }
    }
}

