/*
 * Decompiled with CFR 0.152.
 */
package io.documentnode.epub4j.epub;

import io.documentnode.epub4j.domain.Book;
import io.documentnode.epub4j.domain.MediaType;
import io.documentnode.epub4j.domain.MediaTypes;
import io.documentnode.epub4j.domain.Resource;
import io.documentnode.epub4j.domain.Resources;
import io.documentnode.epub4j.epub.BookProcessor;
import io.documentnode.epub4j.epub.NCXDocument;
import io.documentnode.epub4j.epub.PackageDocumentReader;
import io.documentnode.epub4j.epub.ResourcesLoader;
import io.documentnode.epub4j.util.ResourceUtil;
import io.documentnode.epub4j.util.StringUtil;
import io.documentnode.minilog.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import net.sf.jazzlib.ZipFile;
import net.sf.jazzlib.ZipInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EpubReader {
    private static final Logger log = Logger.create(EpubReader.class);
    private BookProcessor bookProcessor = BookProcessor.IDENTITY_BOOKPROCESSOR;

    public Book readEpub(InputStream in) throws IOException {
        return this.readEpub(in, "UTF-8");
    }

    public Book readEpub(ZipInputStream in) throws IOException {
        return this.readEpub(in, "UTF-8");
    }

    public Book readEpub(ZipFile zipfile) throws IOException {
        return this.readEpub(zipfile, "UTF-8");
    }

    public Book readEpub(InputStream in, String encoding) throws IOException {
        return this.readEpub(new ZipInputStream(in), encoding);
    }

    public Book readEpubLazy(ZipFile zipFile, String encoding) throws IOException {
        return this.readEpubLazy(zipFile, encoding, Arrays.asList(MediaTypes.mediaTypes));
    }

    public Book readEpub(ZipInputStream in, String encoding) throws IOException {
        return this.readEpub(ResourcesLoader.loadResources(in, encoding));
    }

    public Book readEpub(ZipFile in, String encoding) throws IOException {
        return this.readEpub(ResourcesLoader.loadResources(in, encoding));
    }

    public Book readEpubLazy(ZipFile zipFile, String encoding, List<MediaType> lazyLoadedTypes) throws IOException {
        Resources resources = ResourcesLoader.loadResources(zipFile, encoding, lazyLoadedTypes);
        return this.readEpub(resources);
    }

    public Book readEpub(Resources resources) throws IOException {
        return this.readEpub(resources, new Book());
    }

    public Book readEpub(Resources resources, Book result) throws IOException {
        if (result == null) {
            result = new Book();
        }
        this.handleMimeType(result, resources);
        String packageResourceHref = this.getPackageResourceHref(resources);
        Resource packageResource = this.processPackageResource(packageResourceHref, result, resources);
        result.setOpfResource(packageResource);
        Resource ncxResource = this.processNcxResource(packageResource, result);
        result.setNcxResource(ncxResource);
        result = this.postProcessBook(result);
        return result;
    }

    private Book postProcessBook(Book book) {
        if (this.bookProcessor != null) {
            book = this.bookProcessor.processBook(book);
        }
        return book;
    }

    private Resource processNcxResource(Resource packageResource, Book book) {
        return NCXDocument.read(book, this);
    }

    private Resource processPackageResource(String packageResourceHref, Book book, Resources resources) {
        Resource packageResource = resources.remove(packageResourceHref);
        try {
            PackageDocumentReader.read(packageResource, this, book, resources);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return packageResource;
    }

    private String getPackageResourceHref(Resources resources) {
        String defaultResult;
        String result = defaultResult = "OEBPS/content.opf";
        Resource containerResource = resources.remove("META-INF/container.xml");
        if (containerResource == null) {
            return result;
        }
        try {
            Document document = ResourceUtil.getAsDocument(containerResource);
            Element rootFileElement = (Element)((Element)document.getDocumentElement().getElementsByTagName("rootfiles").item(0)).getElementsByTagName("rootfile").item(0);
            result = rootFileElement.getAttribute("full-path");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        if (StringUtil.isBlank(result)) {
            result = defaultResult;
        }
        return result;
    }

    private void handleMimeType(Book result, Resources resources) {
        resources.remove("mimetype");
    }
}

