/*
 * Decompiled with CFR 0.152.
 */
package io.documentnode.epub4j.epub;

import io.documentnode.epub4j.Constants;
import io.documentnode.epub4j.domain.Author;
import io.documentnode.epub4j.domain.Book;
import io.documentnode.epub4j.domain.Identifier;
import io.documentnode.epub4j.domain.MediaTypes;
import io.documentnode.epub4j.domain.Resource;
import io.documentnode.epub4j.domain.TOCReference;
import io.documentnode.epub4j.domain.TableOfContents;
import io.documentnode.epub4j.epub.DOMUtil;
import io.documentnode.epub4j.epub.EpubProcessorSupport;
import io.documentnode.epub4j.epub.EpubReader;
import io.documentnode.epub4j.epub.EpubWriter;
import io.documentnode.epub4j.util.ResourceUtil;
import io.documentnode.epub4j.util.StringUtil;
import io.documentnode.minilog.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmlpull.v1.XmlSerializer;

public class NCXDocument {
    public static final String NAMESPACE_NCX = "http://www.daisy.org/z3986/2005/ncx/";
    public static final String PREFIX_NCX = "ncx";
    public static final String NCX_ITEM_ID = "ncx";
    public static final String DEFAULT_NCX_HREF = "toc.ncx";
    public static final String PREFIX_DTB = "dtb";
    private static final Logger log = Logger.create(NCXDocument.class);

    public static Resource read(Book book, EpubReader epubReader) {
        Resource ncxResource = null;
        if (book.getSpine().getTocResource() == null) {
            log.error("Book does not contain a table of contents file");
            return ncxResource;
        }
        try {
            ncxResource = book.getSpine().getTocResource();
            if (ncxResource == null) {
                return ncxResource;
            }
            Document ncxDocument = ResourceUtil.getAsDocument(ncxResource);
            Element navMapElement = DOMUtil.getFirstElementByTagNameNS(ncxDocument.getDocumentElement(), NAMESPACE_NCX, "navMap");
            TableOfContents tableOfContents = new TableOfContents(NCXDocument.readTOCReferences(navMapElement.getChildNodes(), book));
            book.setTableOfContents(tableOfContents);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return ncxResource;
    }

    private static List<TOCReference> readTOCReferences(NodeList navpoints, Book book) {
        if (navpoints == null) {
            return new ArrayList<TOCReference>();
        }
        ArrayList<TOCReference> result = new ArrayList<TOCReference>(navpoints.getLength());
        for (int i = 0; i < navpoints.getLength(); ++i) {
            Node node = navpoints.item(i);
            if (node.getNodeType() != 1 || !node.getLocalName().equals("navPoint")) continue;
            TOCReference tocReference = NCXDocument.readTOCReference((Element)node, book);
            result.add(tocReference);
        }
        return result;
    }

    static TOCReference readTOCReference(Element navpointElement, Book book) {
        String label = NCXDocument.readNavLabel(navpointElement);
        Object tocResourceRoot = StringUtil.substringBeforeLast(book.getSpine().getTocResource().getHref(), '/');
        tocResourceRoot = ((String)tocResourceRoot).length() == book.getSpine().getTocResource().getHref().length() ? "" : (String)tocResourceRoot + "/";
        String reference = StringUtil.collapsePathDots((String)tocResourceRoot + NCXDocument.readNavReference(navpointElement));
        String href = StringUtil.substringBefore(reference, '#');
        String fragmentId = StringUtil.substringAfter(reference, '#');
        Resource resource = book.getResources().getByHref(href);
        if (resource == null) {
            log.error("Resource with href " + href + " in NCX document not found");
        }
        TOCReference result = new TOCReference(label, resource, fragmentId);
        List<TOCReference> childTOCReferences = NCXDocument.readTOCReferences(navpointElement.getChildNodes(), book);
        result.setChildren(childTOCReferences);
        return result;
    }

    private static String readNavReference(Element navpointElement) {
        Element contentElement = DOMUtil.getFirstElementByTagNameNS(navpointElement, NAMESPACE_NCX, "content");
        String result = DOMUtil.getAttribute(contentElement, NAMESPACE_NCX, "src");
        try {
            result = URLDecoder.decode(result, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage());
        }
        return result;
    }

    private static String readNavLabel(Element navpointElement) {
        Element navLabel = DOMUtil.getFirstElementByTagNameNS(navpointElement, NAMESPACE_NCX, "navLabel");
        return DOMUtil.getTextChildrenContent(DOMUtil.getFirstElementByTagNameNS(navLabel, NAMESPACE_NCX, "text"));
    }

    public static void write(EpubWriter epubWriter, Book book, ZipOutputStream resultStream) throws IOException {
        resultStream.putNextEntry(new ZipEntry(book.getSpine().getTocResource().getHref()));
        XmlSerializer out = EpubProcessorSupport.createXmlSerializer(resultStream);
        NCXDocument.write(out, book);
        out.flush();
    }

    public static void write(XmlSerializer xmlSerializer, Book book) throws IllegalArgumentException, IllegalStateException, IOException {
        NCXDocument.write(xmlSerializer, book.getMetadata().getIdentifiers(), book.getTitle(), book.getMetadata().getAuthors(), book.getTableOfContents());
    }

    public static Resource createNCXResource(Book book) throws IllegalArgumentException, IllegalStateException, IOException {
        return NCXDocument.createNCXResource(book.getMetadata().getIdentifiers(), book.getTitle(), book.getMetadata().getAuthors(), book.getTableOfContents());
    }

    public static Resource createNCXResource(List<Identifier> identifiers, String title, List<Author> authors, TableOfContents tableOfContents) throws IllegalArgumentException, IllegalStateException, IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        XmlSerializer out = EpubProcessorSupport.createXmlSerializer(data);
        NCXDocument.write(out, identifiers, title, authors, tableOfContents);
        Resource resource = new Resource("ncx", data.toByteArray(), DEFAULT_NCX_HREF, MediaTypes.NCX);
        return resource;
    }

    public static void write(XmlSerializer serializer, List<Identifier> identifiers, String title, List<Author> authors, TableOfContents tableOfContents) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startDocument("UTF-8", Boolean.valueOf(false));
        serializer.setPrefix("", NAMESPACE_NCX);
        serializer.startTag(NAMESPACE_NCX, "ncx");
        serializer.attribute("", "version", "2005-1");
        serializer.startTag(NAMESPACE_NCX, "head");
        for (Identifier identifier : identifiers) {
            NCXDocument.writeMetaElement(identifier.getScheme(), identifier.getValue(), serializer);
        }
        NCXDocument.writeMetaElement("generator", Constants.EPUB4J_GENERATOR_NAME, serializer);
        NCXDocument.writeMetaElement("depth", String.valueOf(tableOfContents.calculateDepth()), serializer);
        NCXDocument.writeMetaElement("totalPageCount", "0", serializer);
        NCXDocument.writeMetaElement("maxPageNumber", "0", serializer);
        serializer.endTag(NAMESPACE_NCX, "head");
        serializer.startTag(NAMESPACE_NCX, "docTitle");
        serializer.startTag(NAMESPACE_NCX, "text");
        serializer.text(StringUtil.defaultIfNull(title));
        serializer.endTag(NAMESPACE_NCX, "text");
        serializer.endTag(NAMESPACE_NCX, "docTitle");
        for (Author author : authors) {
            serializer.startTag(NAMESPACE_NCX, "docAuthor");
            serializer.startTag(NAMESPACE_NCX, "text");
            serializer.text(author.getLastname() + ", " + author.getFirstname());
            serializer.endTag(NAMESPACE_NCX, "text");
            serializer.endTag(NAMESPACE_NCX, "docAuthor");
        }
        serializer.startTag(NAMESPACE_NCX, "navMap");
        NCXDocument.writeNavPoints(tableOfContents.getTocReferences(), 1, serializer);
        serializer.endTag(NAMESPACE_NCX, "navMap");
        serializer.endTag(NAMESPACE_NCX, "ncx");
        serializer.endDocument();
    }

    private static void writeMetaElement(String dtbName, String content, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(NAMESPACE_NCX, "meta");
        serializer.attribute("", "name", "dtb:" + dtbName);
        serializer.attribute("", "content", content);
        serializer.endTag(NAMESPACE_NCX, "meta");
    }

    private static int writeNavPoints(List<TOCReference> tocReferences, int playOrder, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        for (TOCReference tocReference : tocReferences) {
            if (tocReference.getResource() == null) {
                playOrder = NCXDocument.writeNavPoints(tocReference.getChildren(), playOrder, serializer);
                continue;
            }
            NCXDocument.writeNavPointStart(tocReference, playOrder, serializer);
            ++playOrder;
            if (!tocReference.getChildren().isEmpty()) {
                playOrder = NCXDocument.writeNavPoints(tocReference.getChildren(), playOrder, serializer);
            }
            NCXDocument.writeNavPointEnd(tocReference, serializer);
        }
        return playOrder;
    }

    private static void writeNavPointStart(TOCReference tocReference, int playOrder, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.startTag(NAMESPACE_NCX, "navPoint");
        serializer.attribute("", "id", "navPoint-" + playOrder);
        serializer.attribute("", "playOrder", String.valueOf(playOrder));
        serializer.attribute("", "class", "chapter");
        serializer.startTag(NAMESPACE_NCX, "navLabel");
        serializer.startTag(NAMESPACE_NCX, "text");
        serializer.text(tocReference.getTitle());
        serializer.endTag(NAMESPACE_NCX, "text");
        serializer.endTag(NAMESPACE_NCX, "navLabel");
        serializer.startTag(NAMESPACE_NCX, "content");
        serializer.attribute("", "src", tocReference.getCompleteHref());
        serializer.endTag(NAMESPACE_NCX, "content");
    }

    private static void writeNavPointEnd(TOCReference tocReference, XmlSerializer serializer) throws IllegalArgumentException, IllegalStateException, IOException {
        serializer.endTag(NAMESPACE_NCX, "navPoint");
    }

    private static interface NCXAttributeValues {
        public static final String chapter = "chapter";
        public static final String version = "2005-1";
    }

    private static interface NCXAttributes {
        public static final String src = "src";
        public static final String name = "name";
        public static final String content = "content";
        public static final String id = "id";
        public static final String playOrder = "playOrder";
        public static final String clazz = "class";
        public static final String version = "version";
    }

    private static interface NCXTags {
        public static final String ncx = "ncx";
        public static final String meta = "meta";
        public static final String navPoint = "navPoint";
        public static final String navMap = "navMap";
        public static final String navLabel = "navLabel";
        public static final String content = "content";
        public static final String text = "text";
        public static final String docTitle = "docTitle";
        public static final String docAuthor = "docAuthor";
        public static final String head = "head";
    }
}

