/*
 * Decompiled with CFR 0.152.
 */
package io.documentnode.epub4j.epub;

import io.documentnode.epub4j.domain.EpubResourceProvider;
import io.documentnode.epub4j.domain.LazyResource;
import io.documentnode.epub4j.domain.MediaType;
import io.documentnode.epub4j.domain.MediaTypes;
import io.documentnode.epub4j.domain.Resource;
import io.documentnode.epub4j.domain.Resources;
import io.documentnode.epub4j.util.CollectionUtil;
import io.documentnode.epub4j.util.ResourceUtil;
import io.documentnode.minilog.Logger;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import net.sf.jazzlib.ZipEntry;
import net.sf.jazzlib.ZipException;
import net.sf.jazzlib.ZipFile;
import net.sf.jazzlib.ZipInputStream;

public class ResourcesLoader {
    private static final Logger log = Logger.create(ResourcesLoader.class);

    public static Resources loadResources(ZipFile zipFile, String defaultHtmlEncoding, List<MediaType> lazyLoadedTypes) throws IOException {
        EpubResourceProvider resourceProvider = new EpubResourceProvider(zipFile.getName());
        Resources result = new Resources();
        Enumeration entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)entries.nextElement();
            if (zipEntry == null || zipEntry.isDirectory()) continue;
            String href = zipEntry.getName();
            Resource resource = ResourcesLoader.shouldLoadLazy(href, lazyLoadedTypes) ? new LazyResource(resourceProvider, zipEntry.getSize(), href) : ResourceUtil.createResource(zipEntry, zipFile.getInputStream(zipEntry));
            if (resource.getMediaType() == MediaTypes.XHTML) {
                resource.setInputEncoding(defaultHtmlEncoding);
            }
            result.add(resource);
        }
        return result;
    }

    private static boolean shouldLoadLazy(String href, Collection<MediaType> lazilyLoadedMediaTypes) {
        if (CollectionUtil.isEmpty(lazilyLoadedMediaTypes)) {
            return false;
        }
        MediaType mediaType = MediaTypes.determineMediaType(href);
        return lazilyLoadedMediaTypes.contains(mediaType);
    }

    public static Resources loadResources(ZipInputStream zipInputStream, String defaultHtmlEncoding) throws IOException {
        ZipEntry zipEntry;
        Resources result = new Resources();
        do {
            if ((zipEntry = ResourcesLoader.getNextZipEntry(zipInputStream)) == null || zipEntry.isDirectory()) continue;
            Resource resource = ResourceUtil.createResource(zipEntry, zipInputStream);
            if (resource.getMediaType() == MediaTypes.XHTML) {
                resource.setInputEncoding(defaultHtmlEncoding);
            }
            result.add(resource);
        } while (zipEntry != null);
        return result;
    }

    private static ZipEntry getNextZipEntry(ZipInputStream zipInputStream) throws IOException {
        try {
            return zipInputStream.getNextEntry();
        }
        catch (ZipException e) {
            log.error("Invalid or damaged zip file.", (Throwable)e);
            try {
                zipInputStream.closeEntry();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public static Resources loadResources(ZipFile zipFile, String defaultHtmlEncoding) throws IOException {
        return ResourcesLoader.loadResources(zipFile, defaultHtmlEncoding, Collections.emptyList());
    }
}

