/*
 * Decompiled with CFR 0.152.
 */
package io.documentnode.epub4j.epub;

import io.documentnode.epub4j.domain.EpubResourceProvider;
import io.documentnode.epub4j.domain.LazyResource;
import io.documentnode.epub4j.domain.MediaType;
import io.documentnode.epub4j.domain.MediaTypes;
import io.documentnode.epub4j.domain.Resource;
import io.documentnode.epub4j.domain.Resources;
import io.documentnode.epub4j.util.CollectionUtil;
import io.documentnode.epub4j.util.ResourceUtil;
import io.documentnode.minilog.Logger;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;

public class ResourcesLoader {
    private static final Logger log = Logger.create(ResourcesLoader.class);

    public static Resources loadResources(ZipFile zipFile, String defaultHtmlEncoding, List<MediaType> lazyLoadedTypes) throws IOException {
        EpubResourceProvider resourceProvider = new EpubResourceProvider(zipFile.getFile().getAbsolutePath());
        Resources result = new Resources();
        List entries = zipFile.getFileHeaders();
        for (FileHeader zipEntry : entries) {
            if (zipEntry == null || zipEntry.isDirectory()) continue;
            String href = zipEntry.getFileName();
            Resource resource = ResourcesLoader.shouldLoadLazy(href, lazyLoadedTypes) ? new LazyResource(resourceProvider, zipEntry.getUncompressedSize(), href) : ResourceUtil.createResource(zipEntry, zipFile.getInputStream(zipEntry));
            if (resource.getMediaType() == MediaTypes.XHTML) {
                resource.setInputEncoding(defaultHtmlEncoding);
            }
            result.add(resource);
        }
        return result;
    }

    private static boolean shouldLoadLazy(String href, Collection<MediaType> lazilyLoadedMediaTypes) {
        if (CollectionUtil.isEmpty(lazilyLoadedMediaTypes)) {
            return false;
        }
        MediaType mediaType = MediaTypes.determineMediaType(href);
        return lazilyLoadedMediaTypes.contains(mediaType);
    }

    public static Resources loadResources(ZipInputStream zipInputStream, String defaultHtmlEncoding) throws IOException {
        LocalFileHeader zipEntry;
        Resources result = new Resources();
        do {
            if ((zipEntry = ResourcesLoader.getNextZipEntry(zipInputStream)) == null || zipEntry.isDirectory()) continue;
            Resource resource = ResourceUtil.createResource(zipEntry, zipInputStream);
            if (resource.getMediaType() == MediaTypes.XHTML) {
                resource.setInputEncoding(defaultHtmlEncoding);
            }
            result.add(resource);
        } while (zipEntry != null);
        return result;
    }

    private static LocalFileHeader getNextZipEntry(ZipInputStream zipInputStream) throws IOException {
        try {
            return zipInputStream.getNextEntry();
        }
        catch (IOException e) {
            log.error("Invalid or damaged zip file.", (Throwable)e);
            throw e;
        }
    }

    public static Resources loadResources(ZipFile zipFile, String defaultHtmlEncoding) throws IOException {
        return ResourcesLoader.loadResources(zipFile, defaultHtmlEncoding, Collections.emptyList());
    }
}

