/*
 * Decompiled with CFR 0.152.
 */
package io.documentnode.epub4j.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;

public class IOUtil {
    public static final int IO_COPY_BUFFER_SIZE = 4096;

    public static byte[] toByteArray(Reader in, String encoding) throws IOException {
        StringWriter out = new StringWriter();
        IOUtil.copy(in, out);
        out.flush();
        return out.toString().getBytes(encoding);
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        IOUtil.copy(in, result);
        result.flush();
        return result.toByteArray();
    }

    public static byte[] toByteArray(InputStream in, int size) throws IOException {
        try {
            ByteArrayOutputStream result = size > 0 ? new ByteArrayOutputStream(size) : new ByteArrayOutputStream();
            IOUtil.copy(in, result);
            result.flush();
            return result.toByteArray();
        }
        catch (OutOfMemoryError error) {
            return null;
        }
    }

    protected static int calcNewNrReadSize(int nrRead, int totalNrNread) {
        if (totalNrNread < 0) {
            return totalNrNread;
        }
        if (totalNrNread > Integer.MAX_VALUE - nrRead) {
            return -1;
        }
        return totalNrNread + nrRead;
    }

    public static int copy(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[4096];
        int readSize = -1;
        int result = 0;
        while ((readSize = in.read(buffer)) >= 0) {
            out.write(buffer, 0, readSize);
            result = IOUtil.calcNewNrReadSize(readSize, result);
        }
        out.flush();
        return result;
    }

    public static int copy(Reader in, Writer out) throws IOException {
        char[] buffer = new char[4096];
        int readSize = -1;
        int result = 0;
        while ((readSize = in.read(buffer)) >= 0) {
            out.write(buffer, 0, readSize);
            result = IOUtil.calcNewNrReadSize(readSize, result);
        }
        out.flush();
        return result;
    }
}

