/*
 * Decompiled with CFR 0.152.
 */
package io.documentnode.minilog;

import io.documentnode.minilog.Level;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    public static Level DEFAULT_LEVEL = Level.DEBUG;
    public static String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private static Level LEVEL = DEFAULT_LEVEL;
    private static String DATE_TIME_FORMAT = DEFAULT_DATE_TIME_FORMAT;
    private static File FILE = null;
    private static final PrintWriter CONSOLE = new PrintWriter(System.out);
    private final String className;

    public static Logger create(Class<?> classType) {
        return new Logger(classType.getName());
    }

    public static Level level() {
        return LEVEL;
    }

    public static void setLevel(Level level) {
        LEVEL = level;
    }

    public static String dateTimeFormat() {
        return DATE_TIME_FORMAT;
    }

    public static void setDateTimeFormat(String dateTimeFormat) {
        try {
            new SimpleDateFormat(dateTimeFormat);
            DATE_TIME_FORMAT = dateTimeFormat;
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
    }

    public static File file() {
        return FILE;
    }

    public static void setFile(File file) {
        FILE = file;
    }

    public Logger(String className) {
        this.className = className;
    }

    private String createLogRecord(String msg) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_TIME_FORMAT);
        String dateTime = dateFormat.format(new Date());
        return String.format("%s [%s] %s - %s", dateTime, Character.valueOf(LEVEL.name().charAt(0)), this.className, msg);
    }

    private void log(String msg) {
        String logRecord = this.createLogRecord(msg);
        this.log((PrintWriter printWriter) -> {
            printWriter.println(logRecord);
            printWriter.flush();
        });
    }

    private void log(String msg, Throwable t) {
        String logRecord = this.createLogRecord(msg);
        this.log((PrintWriter printWriter) -> {
            printWriter.println(logRecord);
            t.printStackTrace(printWriter);
            printWriter.flush();
        });
    }

    private void log(MsgWriter writer) {
        writer.write(CONSOLE);
        if (FILE != null) {
            try {
                if (!FILE.exists()) {
                    FILE.createNewFile();
                }
                FileWriter fw = new FileWriter(FILE, true);
                BufferedWriter bw = new BufferedWriter(fw);
                try (PrintWriter pw = new PrintWriter(bw);){
                    writer.write(pw);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                FILE = null;
            }
        }
    }

    public void trace(String msg) {
        if (Level.TRACE.ordinal() >= LEVEL.ordinal()) {
            this.log(msg);
        }
    }

    public void trace(String format, Object arg) {
        this.trace(String.format(format, arg));
    }

    public void trace(String format, Object ... arguments) {
        this.trace(String.format(format, arguments));
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.trace(String.format(format, arg1, arg2));
    }

    public void trace(String msg, Throwable t) {
        if (Level.TRACE.ordinal() >= LEVEL.ordinal()) {
            this.log(msg, t);
        }
    }

    public void debug(String msg) {
        if (Level.DEBUG.ordinal() >= LEVEL.ordinal()) {
            this.log(msg);
        }
    }

    public void debug(String format, Object arg) {
        this.debug(String.format(format, arg));
    }

    public void debug(String format, Object ... arguments) {
        this.debug(String.format(format, arguments));
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.debug(String.format(format, arg1, arg2));
    }

    public void debug(String msg, Throwable t) {
        if (Level.DEBUG.ordinal() >= LEVEL.ordinal()) {
            this.log(msg, t);
        }
    }

    public void info(String msg) {
        if (Level.INFO.ordinal() >= LEVEL.ordinal()) {
            this.log(msg);
        }
    }

    public void info(String format, Object arg) {
        this.info(String.format(format, arg));
    }

    public void info(String format, Object ... arguments) {
        this.info(String.format(format, arguments));
    }

    public void info(String format, Object arg1, Object arg2) {
        this.info(String.format(format, arg1, arg2));
    }

    public void info(String msg, Throwable t) {
        if (Level.INFO.ordinal() >= LEVEL.ordinal()) {
            this.log(msg, t);
        }
    }

    public void warn(String msg) {
        if (Level.WARN.ordinal() >= LEVEL.ordinal()) {
            this.log(msg);
        }
    }

    public void warn(String format, Object arg) {
        this.warn(String.format(format, arg));
    }

    public void warn(String format, Object ... arguments) {
        this.warn(String.format(format, arguments));
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warn(String.format(format, arg1, arg2));
    }

    public void warn(String msg, Throwable t) {
        if (Level.WARN.ordinal() >= LEVEL.ordinal()) {
            this.log(msg, t);
        }
    }

    public void error(String msg) {
        if (Level.ERROR.ordinal() >= LEVEL.ordinal()) {
            this.log(msg);
        }
    }

    public void error(String format, Object arg) {
        this.error(String.format(format, arg));
    }

    public void error(String format, Object ... arguments) {
        this.error(String.format(format, arguments));
    }

    public void error(String format, Object arg1, Object arg2) {
        this.error(String.format(format, arg1, arg2));
    }

    public void error(String msg, Throwable t) {
        if (Level.ERROR.ordinal() >= LEVEL.ordinal()) {
            this.log(msg, t);
        }
    }

    private static interface MsgWriter {
        public void write(PrintWriter var1);
    }
}

