/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.operation;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatchMessages;
import com.github.fge.jsonpatch.operation.JsonPatchOperationBase;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.github.fge.msgsimple.load.MessageBundles;
import java.io.IOException;

public abstract class DualPathOperation
extends JsonPatchOperationBase {
    protected static final MessageBundle BUNDLE = MessageBundles.getBundle(JsonPatchMessages.class);
    @JsonSerialize(using=ToStringSerializer.class)
    protected final JsonPointer from;

    protected DualPathOperation(String op, JsonPointer from, JsonPointer path) {
        super(op, path);
        this.from = from;
    }

    public final void serialize(JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        jgen.writeStartObject();
        jgen.writeStringField("op", this.getOp());
        jgen.writeStringField("path", this.getPath().toString());
        jgen.writeStringField("from", this.from.toString());
        jgen.writeEndObject();
    }

    public final void serializeWithType(JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonProcessingException {
        this.serialize(jgen, provider);
    }

    @Override
    public final String toString() {
        return "op: " + this.getOp() + "; from: \"" + this.from + "\"; path: \"" + this.getPath() + '\"';
    }
}

