/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.plugin;

import io.domainlifecycles.plugin.diagram.CreateDiagramTask;
import io.domainlifecycles.plugin.extensions.DiagramTaskConfigurationExtension;
import io.domainlifecycles.plugin.extensions.DlcGradlePluginExtension;
import io.domainlifecycles.plugin.extensions.DomainModelUploadTaskConfigurationExtension;
import io.domainlifecycles.plugin.extensions.JsonTaskConfigurationExtension;
import io.domainlifecycles.plugin.json.JsonRenderTask;
import io.domainlifecycles.plugin.viewer.UploadDomainModelTask;
import io.domainlifecycles.plugins.exception.DLCPluginsException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Provider;

public class DlcGradlePlugin
implements Plugin<Project> {
    public void apply(Project project) {
        DlcGradlePluginExtension pluginExtension = (DlcGradlePluginExtension)project.getExtensions().create("dlcGradlePlugin", DlcGradlePluginExtension.class, new Object[0]);
        if (!(pluginExtension instanceof ExtensionAware)) {
            throw DLCPluginsException.fail((String)"Could not create Gradle extension of DlcGradlePluginExtension.");
        }
        ExtensionAware extensionAware = (ExtensionAware)pluginExtension;
        JsonTaskConfigurationExtension jsonModelExtension = (JsonTaskConfigurationExtension)extensionAware.getExtensions().create("jsonModel", JsonTaskConfigurationExtension.class, new Object[0]);
        DiagramTaskConfigurationExtension diagramExtension = (DiagramTaskConfigurationExtension)extensionAware.getExtensions().create("diagram", DiagramTaskConfigurationExtension.class, new Object[0]);
        DomainModelUploadTaskConfigurationExtension domainModelUploadTaskConfigurationExtension = (DomainModelUploadTaskConfigurationExtension)extensionAware.getExtensions().create("domainModelUpload", DomainModelUploadTaskConfigurationExtension.class, new Object[0]);
        project.afterEvaluate(proj -> {
            project.getTasks().register("createDiagram", CreateDiagramTask.class, task -> {
                task.getFileOutputDir().set((Provider)diagramExtension.getFileOutputDir());
                task.getDiagrams().addAll(diagramExtension.getDiagrams());
            });
            project.getTasks().register("renderJson", JsonRenderTask.class, task -> {
                task.getFileOutputDir().set((Provider)jsonModelExtension.getFileOutputDir());
                task.getSerializations().addAll(jsonModelExtension.getSerializations());
            });
            project.getTasks().register("domainModelUpload", UploadDomainModelTask.class, task -> {
                task.getProjectName().set(domainModelUploadTaskConfigurationExtension.getProjectName());
                task.getApiKey().set(domainModelUploadTaskConfigurationExtension.getApiKey());
                task.getDiagramViewerBaseUrl().set(domainModelUploadTaskConfigurationExtension.getDiagramViewerBaseUrl());
                task.getDomainModelPackages().set(domainModelUploadTaskConfigurationExtension.getContextPackages());
            });
        });
    }
}

