/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.plugin.diagram;

import io.domainlifecycles.plugin.diagram.DiagramConfigMapper;
import io.domainlifecycles.plugin.extensions.PluginDiagramConfigurationExtension;
import io.domainlifecycles.plugins.diagram.DiagramConfig;
import io.domainlifecycles.plugins.diagram.DiagramGenerator;
import io.domainlifecycles.plugins.diagram.DiagramGeneratorImpl;
import io.domainlifecycles.utils.ClassLoaderUtils;
import io.domainlifecycles.utils.FileIOUtils;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CreateDiagramTask
extends DefaultTask {
    private static final Logger log = LoggerFactory.getLogger(CreateDiagramTask.class);
    private DiagramGenerator diagramGenerator;

    @OutputDirectory
    public abstract DirectoryProperty getFileOutputDir();

    @Input
    public abstract NamedDomainObjectContainer<PluginDiagramConfigurationExtension> getDiagrams();

    @TaskAction
    public void action() {
        this.diagramGenerator = new DiagramGeneratorImpl();
        this.getDiagrams().forEach(this::createAndSaveDiagram);
        this.diagramGenerator.tearDown();
    }

    private void createAndSaveDiagram(PluginDiagramConfigurationExtension diagramConfigExtension) {
        DiagramConfig diagramConfig = DiagramConfigMapper.map(diagramConfigExtension);
        byte[] diagramFileContent = this.diagramGenerator.generateDiagram(ClassLoaderUtils.getParentClasspathFiles(this.getProject()), diagramConfig, (String[])((List)diagramConfigExtension.getDomainModelPackages().getOrElse(Collections.emptyList())).toArray(String[]::new));
        Path filePath = Path.of(((Directory)this.getFileOutputDir().get()).toString(), diagramConfig.getFileName() + diagramConfig.getFileType().getFileSuffix());
        log.info(String.format("Saving diagram to %s", filePath));
        FileIOUtils.writeFileTo(filePath, diagramFileContent);
    }
}

