/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.plugin.json;

import io.domainlifecycles.plugin.extensions.SerializationConfigurationExtension;
import io.domainlifecycles.plugins.json.JsonSerializer;
import io.domainlifecycles.plugins.json.JsonSerializerImpl;
import io.domainlifecycles.utils.ClassLoaderUtils;
import io.domainlifecycles.utils.FileIOUtils;
import java.nio.file.Path;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JsonRenderTask
extends DefaultTask {
    private static final Logger log = LoggerFactory.getLogger(JsonRenderTask.class);
    private static final String DEFAULT_JSON_RENDER_FILE_NAME = "model";
    private JsonSerializer jsonSerializer;

    @OutputDirectory
    public abstract DirectoryProperty getFileOutputDir();

    @Input
    public abstract NamedDomainObjectContainer<SerializationConfigurationExtension> getSerializations();

    @TaskAction
    public void action() {
        this.jsonSerializer = new JsonSerializerImpl(true);
        this.getSerializations().forEach(this::renderAndSaveModelAsJson);
    }

    private void renderAndSaveModelAsJson(SerializationConfigurationExtension serializationConfigurationExtension) {
        String jsonContent = this.jsonSerializer.serialize(ClassLoaderUtils.getParentClasspathFiles(this.getProject()), (List)serializationConfigurationExtension.getDomainModelPackages().getOrNull());
        Path filePath = Path.of(String.valueOf(this.getFileOutputDir().getOrNull()), (String)serializationConfigurationExtension.getFileName().getOrElse((Object)DEFAULT_JSON_RENDER_FILE_NAME) + ".json");
        log.info(String.format("Saving JSON model to %s", filePath));
        FileIOUtils.writeFileTo(filePath, jsonContent);
    }
}

