/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.plugin.viewer;

import io.domainlifecycles.plugins.json.JsonSerializerImpl;
import io.domainlifecycles.plugins.viewer.DomainModelUploader;
import io.domainlifecycles.plugins.viewer.DomainModelUploaderImpl;
import io.domainlifecycles.utils.ClassLoaderUtils;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UploadDomainModelTask
extends DefaultTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(UploadDomainModelTask.class);
    private DomainModelUploader domainModelUploader;

    @Input
    public abstract Property<String> getDiagramViewerBaseUrl();

    @Input
    public abstract Property<String> getApiKey();

    @Input
    public abstract Property<String> getProjectName();

    @Input
    public abstract ListProperty<String> getDomainModelPackages();

    @TaskAction
    public void action() {
        LOGGER.info("Running Upload Domain Model Goal...");
        this.domainModelUploader = new DomainModelUploaderImpl();
        this.uploadDomainModel();
    }

    private void uploadDomainModel() {
        JsonSerializerImpl jsonSerializer = new JsonSerializerImpl(true);
        String domainModelJson = jsonSerializer.serialize(ClassLoaderUtils.getParentClasspathFiles(this.getProject()), (List)this.getDomainModelPackages().get());
        this.domainModelUploader.uploadDomainModel(domainModelJson, (List)this.getDomainModelPackages().get(), (String)this.getApiKey().get(), (String)this.getProjectName().get(), (String)this.getDiagramViewerBaseUrl().get());
    }
}

