/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.utils;

import io.domainlifecycles.exception.DLCGradlePluginException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassLoaderUtils {
    private static final Logger log = LoggerFactory.getLogger(ClassLoaderUtils.class);

    public static List<URL> getParentClasspathFiles(Project project) {
        ArrayList<URL> parentClasspath = new ArrayList<URL>();
        try {
            File parentProjectBuildDir = new File(project.getBuildDir(), "classes/java/main");
            parentClasspath.add(parentProjectBuildDir.toURI().toURL());
            project.getConfigurations().getByName("runtimeClasspath").getResolvedConfiguration().getResolvedArtifacts().forEach(resolvedArtifact -> {
                try {
                    parentClasspath.add(resolvedArtifact.getFile().toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            });
            parentClasspath.forEach(element -> log.debug("Identified classpath element: {}", element));
            return parentClasspath;
        }
        catch (Exception e) {
            throw DLCGradlePluginException.fail("Failed to configure plugin with project classloader", e);
        }
    }
}

