/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.plugins.diagram;

import io.domainlifecycles.diagram.domain.DomainDiagramGenerator;
import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.plugins.diagram.DiagramConfig;
import io.domainlifecycles.plugins.diagram.DiagramGenerator;
import io.domainlifecycles.plugins.diagram.FileType;
import io.domainlifecycles.plugins.diagram.kroki.KrokiClient;
import io.domainlifecycles.plugins.exception.DLCPluginsException;
import io.domainlifecycles.plugins.util.DLCUtils;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiagramGeneratorImpl
implements DiagramGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiagramGeneratorImpl.class);
    private final KrokiClient krokiClient = new KrokiClient();

    @Override
    public byte[] generateDiagram(List<URL> classPathFiles, DiagramConfig diagramConfig, String ... domainPackages) {
        LOGGER.info(String.format("Generating diagram %s of type %s", diagramConfig.getFileName(), diagramConfig.getFileType().name()));
        String rawNomnomlDiagramText = this.generateRawNomnomlDiagramText(classPathFiles, diagramConfig, domainPackages);
        if (FileType.NOMNOML.equals((Object)diagramConfig.getFileType())) {
            return rawNomnomlDiagramText.getBytes(StandardCharsets.UTF_8);
        }
        try {
            this.krokiClient.initialize();
            return this.krokiClient.convertTo(rawNomnomlDiagramText, diagramConfig.getFileType());
        }
        catch (Exception e) {
            throw DLCPluginsException.fail(String.format("Error occurred while generating diagram '%s' (Of type: %s)", diagramConfig.getFileName(), diagramConfig.getFileType().name()), e);
        }
    }

    @Override
    public void tearDown() {
        this.krokiClient.finish();
    }

    private String generateRawNomnomlDiagramText(List<URL> classPathFiles, DiagramConfig diagramConfig, String ... domainPackages) {
        DomainMirror dm = null;
        try {
            dm = DLCUtils.initializeDomainMirrorFromClassPath(classPathFiles, domainPackages);
        }
        catch (RuntimeException e) {
            throw DLCPluginsException.fail("DomainMirror couldn't be initialized.", e);
        }
        DomainDiagramGenerator generator = new DomainDiagramGenerator(diagramConfig.map(), dm);
        return generator.generateDiagramText();
    }
}

