/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.plugins.diagram;

import io.domainlifecycles.plugins.exception.DLCPluginsException;

public enum FileType {
    PDF(".pdf"),
    SVG(".svg"),
    PNG(".png"),
    JPG(".jpg"),
    NOMNOML(".nomnoml");

    private final String fileSuffix;

    private FileType(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public static FileType byName(String name) {
        for (FileType fileType : FileType.values()) {
            if (!fileType.name().equalsIgnoreCase(name)) continue;
            return fileType;
        }
        throw DLCPluginsException.fail(String.format("Could not find matching FileType for file-name %s.", name));
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }
}

