/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.plugins.diagram.kroki;

import io.domainlifecycles.plugins.diagram.FileType;
import io.domainlifecycles.plugins.diagram.kroki.KrokiDockerAdapter;
import io.domainlifecycles.plugins.exception.DLCPluginsException;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KrokiClient {
    private static final Logger log = LoggerFactory.getLogger(KrokiDockerAdapter.class);
    private static final String KROKI_CONTAINER_URL = "http://localhost:8000";
    private static final String KROKI_NOMNOML_SVG_PATH = "/nomnoml/svg";
    private static final Integer MAX_RETRIES = 5;
    private static final Integer WAIT_TIMEOUT_MS = 500;
    private final KrokiDockerAdapter krokiDockerAdapter = new KrokiDockerAdapter();

    public void initialize() {
        this.krokiDockerAdapter.start();
    }

    public void finish() {
        this.krokiDockerAdapter.stop();
    }

    public byte[] convertTo(String rawNomNomlContent, FileType fileType) {
        String path = this.getKrokiPath(fileType);
        return this.convert(rawNomNomlContent, path);
    }

    private byte[] convert(String rawInputDiagramContent, String path) {
        log.info("Converting Nomnoml diagram to specified format via Kroki Docker container.");
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(KROKI_CONTAINER_URL + path)).header("Accept", "text/plain").POST(HttpRequest.BodyPublishers.ofString(rawInputDiagramContent)).build();
        return this.sendWithRetries(request);
    }

    private byte[] sendWithRetries(HttpRequest httpRequest) {
        for (int retryCounter = 0; retryCounter < MAX_RETRIES; ++retryCounter) {
            try {
                log.debug(String.format("Sending HTTP request to Kroki Docker container. Retry: %s", retryCounter + 1));
                HttpResponse<byte[]> response = HttpClient.newHttpClient().send(httpRequest, HttpResponse.BodyHandlers.ofByteArray());
                if (response.statusCode() < 400) {
                    log.debug("HTTP request to Kroki Docker container has been successful.");
                    return response.body();
                }
                if (response.statusCode() < 400) continue;
                throw DLCPluginsException.fail(String.format("Kroki Docker container returned error for conversion: %s", new String(response.body(), StandardCharsets.UTF_8)));
            }
            catch (IOException | InterruptedException e) {
                try {
                    Thread.sleep(WAIT_TIMEOUT_MS.intValue());
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        throw DLCPluginsException.fail(String.format("Kroki server couldn't be reached in specified retry limit (Retries: %s, Timeout: %s)", MAX_RETRIES, WAIT_TIMEOUT_MS));
    }

    private String getKrokiPath(FileType fileType) {
        return switch (fileType) {
            case FileType.SVG -> KROKI_NOMNOML_SVG_PATH;
            default -> throw DLCPluginsException.fail(String.format("Filetype %s not allowed for Kroki conversion", new Object[]{fileType}));
        };
    }
}

