/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.plugins.diagram.kroki;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import com.github.dockerjava.transport.SSLConfig;
import io.domainlifecycles.plugins.exception.DLCPluginsException;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KrokiDockerAdapter {
    private static final String KROKI_CONTAINER_NAME = "kroki-dlc";
    private static final String KROKI_CONTAINER_HOST_NAME = "kroki-dlc-host";
    private static final String KROKI_CONTAINER_IMAGE_NAME = "yuzutech/kroki";
    private static final Logger log = LoggerFactory.getLogger(KrokiDockerAdapter.class);
    private final DockerClient dockerClient = this.initializeDockerClient();
    private String krokiContainerId;

    KrokiDockerAdapter() {
    }

    void start() {
        if (this.krokiContainerId == null) {
            this.krokiContainerId = this.createOrGetKrokiDockerContainerId();
        }
        this.startContainer();
    }

    void stop() {
        if (this.krokiContainerId != null) {
            try {
                this.dockerClient.stopContainerCmd(this.krokiContainerId).exec();
            }
            catch (Throwable t) {
                throw DLCPluginsException.fail("Could not stop Kroki Docker container.", t);
            }
            log.debug("Kroki container stopped");
        }
    }

    private void startContainer() {
        block4: {
            try {
                List res = (List)this.dockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).withIdFilter(List.of(this.krokiContainerId)).exec();
                if (!res.isEmpty()) {
                    log.debug("Kroki container state:" + res.stream().map(Container::getState).collect(Collectors.joining()));
                    boolean running = res.stream().allMatch(c -> c.getState().equalsIgnoreCase("running"));
                    if (!running) {
                        this.dockerClient.startContainerCmd(this.krokiContainerId).exec();
                    }
                    break block4;
                }
                throw DLCPluginsException.fail("Kroki container not found");
            }
            catch (Throwable t) {
                throw DLCPluginsException.fail("Could not start or access Kroki Docker container.", t);
            }
        }
        log.debug("Kroki container running");
    }

    private String createOrGetKrokiDockerContainerId() {
        try {
            List foundContainers = (List)this.dockerClient.listContainersCmd().withShowAll(Boolean.valueOf(true)).withNameFilter(List.of(KROKI_CONTAINER_NAME)).exec();
            if (!foundContainers.isEmpty()) {
                log.debug("Found containers: {}", (Object)foundContainers.stream().map(c -> c.getId() + " " + String.valueOf(c.getNames())).collect(Collectors.joining("\n")));
                String krokiContainerId = ((Container)foundContainers.stream().findFirst().get()).getId();
                log.debug(String.format("Found existing Kroki Docker container with ID: %s. Reusing this.", krokiContainerId));
                return krokiContainerId;
            }
            log.debug("No existing Kroki Docker container found. Creating new one...");
        }
        catch (Throwable t) {
            throw DLCPluginsException.fail("Could not create Kroki Docker container. Please check whether your Docker engine is up and running.", t);
        }
        return this.createKrokiDockerContainer();
    }

    private String createKrokiDockerContainer() {
        ExposedPort tcp4444 = ExposedPort.tcp((int)8000);
        Ports portBindings = new Ports();
        portBindings.bind(tcp4444, Ports.Binding.bindPort((int)8000));
        try {
            return this.dockerClient.createContainerCmd(KROKI_CONTAINER_IMAGE_NAME).withName(KROKI_CONTAINER_NAME).withHostName(KROKI_CONTAINER_HOST_NAME).withExposedPorts(new ExposedPort[]{tcp4444}).withHostConfig(HostConfig.newHostConfig().withPortBindings(portBindings)).exec().getId();
        }
        catch (Throwable t) {
            throw DLCPluginsException.fail("Could not create Kroki Docker container. Please check whether your Docker engine is up and running.", t);
        }
    }

    private DockerClient initializeDockerClient() {
        try {
            DefaultDockerClientConfig standard = DefaultDockerClientConfig.createDefaultConfigBuilder().build();
            ApacheDockerHttpClient httpClient = new ApacheDockerHttpClient.Builder().dockerHost(standard.getDockerHost()).sslConfig((SSLConfig)standard.getSSLConfig()).maxConnections(100).connectionTimeout(Duration.ofSeconds(30L)).responseTimeout(Duration.ofSeconds(45L)).build();
            return DockerClientImpl.getInstance((DockerClientConfig)standard, (DockerHttpClient)httpClient);
        }
        catch (Throwable t) {
            throw DLCPluginsException.fail("Could not establish connection to Docker client. Please check whether your Docker engine is up and running.", t);
        }
    }
}

