/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.plugins.json;

import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.mirror.serialize.api.DomainSerializer;
import io.domainlifecycles.mirror.serialize.api.JacksonDomainSerializer;
import io.domainlifecycles.plugins.exception.DLCPluginsException;
import io.domainlifecycles.plugins.json.JsonSerializer;
import io.domainlifecycles.plugins.util.DLCUtils;
import java.net.URL;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSerializerImpl
implements JsonSerializer {
    private static final Logger log = LoggerFactory.getLogger(JsonSerializerImpl.class);
    private final DomainSerializer domainSerializer;

    public JsonSerializerImpl(boolean prettyPrint) {
        this.domainSerializer = new JacksonDomainSerializer(prettyPrint);
    }

    @Override
    public String serialize(List<URL> classPathFiles, List<String> domainModelPackages) {
        DomainMirror dm = null;
        try {
            dm = DLCUtils.initializeDomainMirrorFromClassPath(classPathFiles, (String[])domainModelPackages.toArray(String[]::new));
        }
        catch (RuntimeException e) {
            throw DLCPluginsException.fail("DLC couldn't be initialized.", e);
        }
        log.info("Serializing domain model to JSON");
        return this.domainSerializer.serialize(dm);
    }
}

