/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.plugins.util;

import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.mirror.reflect.ReflectiveDomainMirrorFactory;
import io.domainlifecycles.mirror.resolver.GenericTypeResolver;
import io.domainlifecycles.mirror.resolver.TypeMetaResolver;
import io.domainlifecycles.plugins.exception.DLCPluginsException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLCUtils {
    private static final Logger log = LoggerFactory.getLogger(DLCUtils.class);

    public static DomainMirror initializeDomainMirrorFromClassPath(List<URL> classPathFiles, String ... domainMirrorPackages) {
        Optional<ClassLoader> cl;
        if (classPathFiles != null && (cl = DLCUtils.subClassLoader(classPathFiles)).isPresent()) {
            log.info("Classes loaded - Initializing domain model");
            ReflectiveDomainMirrorFactory domainModelFactory = new ReflectiveDomainMirrorFactory(domainMirrorPackages);
            domainModelFactory.setExternalClassLoader(cl.get());
            domainModelFactory.setGenericTypeResolver((GenericTypeResolver)new TypeMetaResolver());
            DomainMirror dm = domainModelFactory.initializeDomainMirror();
            log.info("Domain model initialized");
            log.info("Mirrored types count = " + dm.getAllDomainTypeMirrors().size());
            return dm;
        }
        throw DLCPluginsException.fail("DomainMirror could not be initialized!");
    }

    private static Optional<ClassLoader> subClassLoader(List<URL> filesToAddToClasspath) {
        if (filesToAddToClasspath == null) {
            return Optional.empty();
        }
        try {
            URLClassLoader childClassLoader = new URLClassLoader((URL[])filesToAddToClasspath.toArray(URL[]::new), DLCUtils.class.getClassLoader());
            return Optional.of(childClassLoader);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }
}

