/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.plugins.viewer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.domainlifecycles.plugins.exception.DLCPluginsException;
import io.domainlifecycles.plugins.viewer.DomainModelUploader;
import io.domainlifecycles.plugins.viewer.model.DomainMirrorUploadDto;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainModelUploaderImpl
implements DomainModelUploader {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomainModelUploaderImpl.class);
    private static final String DIAGRAM_VIEWER_DOMAIN_MIRROR_UPLOAD_PATH = "/api/upload/domain-mirror/";
    private static final String API_KEY_HEADER_NAME = "X-API-KEY";

    @Override
    public void uploadDomainModel(String domainMirrorJson, List<String> domainModelPackages, String apiKey, String projectName, String diagramViewerBaseUrl) {
        LOGGER.debug(String.format("Trying to upload Domain-Model to Diagram-Viewer project '%s' with base url '%s'.", projectName, diagramViewerBaseUrl));
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = this.buildDomainMirrorUploadRequest(domainMirrorJson, domainModelPackages, projectName, apiKey, diagramViewerBaseUrl);
        try {
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            this.handleResponseErrors(response);
            LOGGER.info("Successfully uploaded Domain-Mirror to Diagram-Viewer.");
        }
        catch (IOException | InterruptedException e) {
            throw DLCPluginsException.fail("Could not send Domain-Mirror to Diagram-Viewer.", e);
        }
    }

    private HttpRequest buildDomainMirrorUploadRequest(String domainMirrorJson, List<String> domainPackages, String projectName, String apiKey, String diagramViewerBaseUrl) {
        String domainMirrorUploadDtoJsonString = DomainModelUploaderImpl.generateJsonRequestBody(domainMirrorJson, domainPackages);
        return HttpRequest.newBuilder().uri(URI.create(diagramViewerBaseUrl + DIAGRAM_VIEWER_DOMAIN_MIRROR_UPLOAD_PATH + projectName)).header("Content-Type", "application/json").header(API_KEY_HEADER_NAME, apiKey).PUT(HttpRequest.BodyPublishers.ofString(domainMirrorUploadDtoJsonString)).build();
    }

    private static String generateJsonRequestBody(String domainMirrorJson, List<String> domainModelPackages) {
        DomainMirrorUploadDto domainMirrorUploadDto = new DomainMirrorUploadDto(domainMirrorJson, domainModelPackages);
        ObjectMapper o = new ObjectMapper();
        try {
            return o.writeValueAsString((Object)domainMirrorUploadDto);
        }
        catch (JsonProcessingException e) {
            throw DLCPluginsException.fail("Could not serialize DomainMirrorUploadDTO to JSON.", e);
        }
    }

    private void handleResponseErrors(HttpResponse<String> response) {
        if (response.statusCode() == 200) {
            return;
        }
        throw DLCPluginsException.fail(String.format("Diagram-Viewer returned failure while processing Domain-Model. Status-Code: '%s'. Error-Message: '%s'.", response.statusCode(), response.body()));
    }
}

