/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.domain;

import io.domainlifecycles.diagram.Diagram;
import io.domainlifecycles.diagram.domain.config.DomainDiagramConfig;
import io.domainlifecycles.diagram.domain.mapper.DomainMapper;
import io.domainlifecycles.mirror.api.DomainMirror;

public class DomainDiagramGenerator
implements Diagram {
    private final DomainDiagramConfig diagramConfig;
    private final DomainMapper domainMapper;
    public static final String AGGREGATE_ROOT_STYLE_TAG = "AR";
    public static final String AGGREGATE_FRAME_STYLE_TAG = "AF";
    public static final String ENTITY_STYLE_TAG = "E";
    public static final String VALUE_OBJECT_STYLE_TAG = "VO";
    public static final String ENUM_STYLE_TAG = "V";
    public static final String DOMAIN_SERVICE_STYLE_TAG = "DS";
    public static final String SERVICE_KIND_STYLE_TAG = "SK";
    public static final String APPLICATION_SERVICE_STYLE_TAG = "AS";
    public static final String DOMAIN_EVENT_STYLE_TAG = "DE";
    public static final String REPOSITORY_STYLE_TAG = "R";
    public static final String DOMAIN_COMMAND_STYLE_TAG = "DC";
    public static final String READ_MODEL_STYLE_TAG = "RM";
    public static final String QUERY_HANDLER_STYLE_TAG = "QH";
    public static final String OUTBOUND_SERVICE_STYLE_TAG = "OS";
    public static final String IDENTITY_STYLE_TAG = "I";

    public DomainDiagramGenerator(DomainDiagramConfig diagramConfig, DomainMirror domainMirror) {
        this.diagramConfig = diagramConfig;
        this.domainMapper = new DomainMapper(diagramConfig, domainMirror);
    }

    @Override
    public String generateDiagramText() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.aggregateFrameStyleDeclaration());
        builder.append(this.aggregateRootStyleDeclaration());
        builder.append(this.entityStyleDeclaration());
        builder.append(this.valueObjectStyleDeclaration());
        builder.append(this.enumStyleDeclaration());
        builder.append(this.identityStyleDeclaration());
        builder.append(this.domainCommandStyleDeclaration());
        builder.append(this.domainEventStyleDeclaration());
        builder.append(this.applicationServiceStyleDeclaration());
        builder.append(this.domainServiceStyleDeclaration());
        builder.append(this.repositoryStyleDeclaration());
        builder.append(this.outboundServiceStyleDeclaration());
        builder.append(this.unspecifiedServiceKindStyleDeclaration());
        builder.append(this.queryHandlerStyleDeclaration());
        builder.append(this.readModelStyleDeclaration());
        builder.append(this.fontStyleDeclaration());
        builder.append(this.directionStyleDeclaration());
        builder.append(this.acyclerStyleDeclaration());
        builder.append(this.rankerStyleDeclaration());
        builder.append(this.backgroundColorStyleDeclaration());
        builder.append(System.lineSeparator());
        this.domainMapper.getDomainCommands().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getApplicationServices().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getDomainServices().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getDomainEvents().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getAggregateFrames().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getDomainRelationshipMapper().mapAllAggregateFrameRelationships().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getRepositories().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getReadModels().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getQueryHandlers().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getOutboundServices().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getUnspecifiedServiceKinds().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getDomainRelationshipMapper().mapAllDomainCommandRelationships().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getDomainRelationshipMapper().mapAllDomainEventRelationships().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getDomainRelationshipMapper().mapAllServiceKindRelationships().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getDomainRelationshipMapper().mapAllAggregateRepositoryRelationships().forEach(f -> builder.append(f.getDiagramText()));
        this.domainMapper.getDomainRelationshipMapper().mapAllQueryHandlerReadModelRelationships().forEach(f -> builder.append(f.getDiagramText()));
        return builder.toString();
    }

    private String aggregateFrameStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getAggregateFrameStyle() != null) {
            return this.completeStyleDeclaration(this.diagramConfig.getStyleSettings().getAggregateFrameStyle(), AGGREGATE_FRAME_STYLE_TAG);
        }
        return "";
    }

    private String aggregateRootStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getAggregateRootStyle() != null) {
            return this.completeStyleDeclaration(this.diagramConfig.getStyleSettings().getAggregateRootStyle(), AGGREGATE_ROOT_STYLE_TAG);
        }
        return "";
    }

    private String entityStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getEntityStyle() != null) {
            return this.completeStyleDeclaration(this.diagramConfig.getStyleSettings().getEntityStyle(), ENTITY_STYLE_TAG);
        }
        return "";
    }

    private String valueObjectStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getValueObjectStyle() != null) {
            return this.completeStyleDeclaration(this.diagramConfig.getStyleSettings().getValueObjectStyle(), VALUE_OBJECT_STYLE_TAG);
        }
        return "";
    }

    private String enumStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getEnumStyle() != null) {
            return this.completeStyleDeclaration(this.diagramConfig.getStyleSettings().getEnumStyle(), ENUM_STYLE_TAG);
        }
        return "";
    }

    private String identityStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getIdentityStyle() != null) {
            return this.completeStyleDeclaration(this.diagramConfig.getStyleSettings().getIdentityStyle(), IDENTITY_STYLE_TAG);
        }
        return "";
    }

    private String domainCommandStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getDomainCommandStyle() != null) {
            return this.completeStyleDeclaration(this.diagramConfig.getStyleSettings().getDomainCommandStyle(), DOMAIN_COMMAND_STYLE_TAG);
        }
        return "";
    }

    private String domainEventStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getDomainEventStyle() != null) {
            return this.completeStyleDeclaration(this.diagramConfig.getStyleSettings().getDomainEventStyle(), DOMAIN_EVENT_STYLE_TAG);
        }
        return "";
    }

    private String applicationServiceStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getApplicationServiceStyle() != null) {
            return this.completeStyleDeclaration(this.diagramConfig.getStyleSettings().getApplicationServiceStyle(), APPLICATION_SERVICE_STYLE_TAG);
        }
        return "";
    }

    private String domainServiceStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getDomainServiceStyle() != null) {
            return this.styleDeclaration(this.diagramConfig.getStyleSettings().getDomainServiceStyle(), DOMAIN_SERVICE_STYLE_TAG);
        }
        return "";
    }

    private String repositoryStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getRepositoryStyle() != null) {
            return this.completeStyleDeclaration(this.diagramConfig.getStyleSettings().getRepositoryStyle(), REPOSITORY_STYLE_TAG);
        }
        return "";
    }

    private String outboundServiceStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getOutboundServiceStyle() != null) {
            return this.completeStyleDeclaration(this.diagramConfig.getStyleSettings().getOutboundServiceStyle(), OUTBOUND_SERVICE_STYLE_TAG);
        }
        return "";
    }

    private String queryHandlerStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getQueryHandlerStyle() != null) {
            return this.completeStyleDeclaration(this.diagramConfig.getStyleSettings().getQueryHandlerStyle(), QUERY_HANDLER_STYLE_TAG);
        }
        return "";
    }

    private String unspecifiedServiceKindStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getUnspecifiedServiceKindStyle() != null) {
            return this.completeStyleDeclaration(this.diagramConfig.getStyleSettings().getUnspecifiedServiceKindStyle(), SERVICE_KIND_STYLE_TAG);
        }
        return "";
    }

    private String readModelStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getReadModelStyle() != null) {
            return this.completeStyleDeclaration(this.diagramConfig.getStyleSettings().getReadModelStyle(), READ_MODEL_STYLE_TAG);
        }
        return "";
    }

    private String completeStyleDeclaration(String declaration, String tagName) {
        return this.styleDeclaration(declaration, tagName) + this.removedStyleDeclaration(declaration, tagName) + this.addedStyleDeclaration(declaration, tagName);
    }

    private String styleDeclaration(String declaration, String tagName) {
        return "#." + tagName + ":" + declaration + System.lineSeparator();
    }

    private String removedStyleDeclaration(String declaration, String tagName) {
        return "#." + tagName + "_R:" + declaration + ";stroke=#FF0000" + System.lineSeparator();
    }

    private String addedStyleDeclaration(String declaration, String tagName) {
        return "#." + tagName + "_N:" + declaration + ";stroke=#108738" + System.lineSeparator();
    }

    private String fontStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getFont() != null) {
            return "#font:" + this.diagramConfig.getStyleSettings().getFont() + System.lineSeparator();
        }
        return "";
    }

    private String directionStyleDeclaration() {
        if (this.diagramConfig.getLayoutSettings().getDirection() != null) {
            return "#direction:" + this.diagramConfig.getLayoutSettings().getDirection() + System.lineSeparator();
        }
        return "";
    }

    private String acyclerStyleDeclaration() {
        if (this.diagramConfig.getLayoutSettings().getAcycler() != null) {
            return "#acycler: " + this.diagramConfig.getLayoutSettings().getAcycler() + System.lineSeparator();
        }
        return "";
    }

    private String rankerStyleDeclaration() {
        if (this.diagramConfig.getLayoutSettings().getRanker() != null) {
            return "#ranker: " + this.diagramConfig.getLayoutSettings().getRanker() + System.lineSeparator();
        }
        return "";
    }

    private String backgroundColorStyleDeclaration() {
        if (this.diagramConfig.getStyleSettings().getBackgroundColor() != null) {
            return "#background: " + this.diagramConfig.getStyleSettings().getBackgroundColor() + System.lineSeparator();
        }
        return "";
    }
}

