/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.domain.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class DiagramTrimSettings {
    private final List<String> classesBlacklist;
    private final List<String> explicitlyIncludedPackageNames;
    private final List<String> includeConnectedTo;
    private final List<String> includeConnectedToIngoing;
    private final List<String> includeConnectedToOutgoing;
    private final List<String> excludeConnectedToIngoing;
    private final List<String> excludeConnectedToOutgoing;

    public List<String> getClassesBlacklist() {
        return this.classesBlacklist;
    }

    public List<String> getIncludeConnectedTo() {
        return this.includeConnectedTo;
    }

    public List<String> getIncludeConnectedToIngoing() {
        return this.includeConnectedToIngoing;
    }

    public List<String> getIncludeConnectedToOutgoing() {
        return this.includeConnectedToOutgoing;
    }

    public List<String> getExcludeConnectedToIngoing() {
        return this.excludeConnectedToIngoing;
    }

    public List<String> getExcludeConnectedToOutgoing() {
        return this.excludeConnectedToOutgoing;
    }

    public List<String> getExplicitlyIncludedPackageNames() {
        return this.explicitlyIncludedPackageNames;
    }

    public boolean hasIncludedConnectedTypeSettings() {
        return !this.getIncludeConnectedToIngoing().isEmpty() || !this.getIncludeConnectedToOutgoing().isEmpty() || !this.getIncludeConnectedTo().isEmpty();
    }

    public boolean hasExcludedConnectedTypeSettings() {
        return !this.getExcludeConnectedToIngoing().isEmpty() || !this.getExcludeConnectedToOutgoing().isEmpty();
    }

    private DiagramTrimSettings(List<String> classesBlacklist, List<String> explicitlyIncludedPackageNames, List<String> includeConnectedTo, List<String> includeConnectedToIngoing, List<String> includeConnectedToOutgoing, List<String> excludeConnectedToIngoing, List<String> excludeConnectedToOutgoing) {
        this.classesBlacklist = classesBlacklist;
        this.explicitlyIncludedPackageNames = explicitlyIncludedPackageNames;
        this.includeConnectedTo = includeConnectedTo;
        this.includeConnectedToIngoing = includeConnectedToIngoing;
        this.includeConnectedToOutgoing = includeConnectedToOutgoing;
        this.excludeConnectedToIngoing = excludeConnectedToIngoing;
        this.excludeConnectedToOutgoing = excludeConnectedToOutgoing;
    }

    public static DiagramTrimSettingsBuilder builder() {
        return new DiagramTrimSettingsBuilder();
    }

    @SafeVarargs
    private static void checkNoOverlap(Collection<String> ... collections) {
        HashSet<String> seen = new HashSet<String>();
        for (Collection<String> collection : collections) {
            if (collection == null) continue;
            for (String element : collection) {
                if (seen.add(element)) continue;
                throw new IllegalArgumentException("The same class found was found across different include / exclude trim settings: " + element);
            }
        }
    }

    public static class DiagramTrimSettingsBuilder {
        private List<String> classesBlacklist$value;
        private List<String> explicitlyIncludedPackageNames$value;
        private List<String> includeConnectedTo$value;
        private List<String> includeConnectedToIngoing$value;
        private List<String> includeConnectedToOutgoing$value;
        private List<String> excludeConnectedToIngoing$value;
        private List<String> excludeConnectedToOutgoing$value;

        public DiagramTrimSettingsBuilder withClassesBlacklist(List<String> classesBlacklist) {
            this.classesBlacklist$value = classesBlacklist;
            return this;
        }

        public DiagramTrimSettingsBuilder withExplicitlyIncludedPackageNames(List<String> explicitlyIncludedPackageNames) {
            this.explicitlyIncludedPackageNames$value = explicitlyIncludedPackageNames;
            return this;
        }

        public DiagramTrimSettingsBuilder withIncludeConnectedTo(List<String> includeConnectedTo) {
            this.includeConnectedTo$value = includeConnectedTo;
            return this;
        }

        public DiagramTrimSettingsBuilder withIncludeConnectedToIngoing(List<String> includeConnectedToIngoing) {
            this.includeConnectedToIngoing$value = includeConnectedToIngoing;
            return this;
        }

        public DiagramTrimSettingsBuilder withIncludeConnectedToOutgoing(List<String> includeConnectedToOutgoing) {
            this.includeConnectedToOutgoing$value = includeConnectedToOutgoing;
            return this;
        }

        public DiagramTrimSettingsBuilder withExcludeConnectedToIngoing(List<String> excludeConnectedToIngoing) {
            this.excludeConnectedToIngoing$value = excludeConnectedToIngoing;
            return this;
        }

        public DiagramTrimSettingsBuilder withExcludeConnectedToOutgoing(List<String> excludeConnectedToOutgoing) {
            this.excludeConnectedToOutgoing$value = excludeConnectedToOutgoing;
            return this;
        }

        public DiagramTrimSettings build() {
            DiagramTrimSettings.checkNoOverlap(this.includeConnectedTo$value, this.includeConnectedToIngoing$value, this.includeConnectedToOutgoing$value, this.excludeConnectedToIngoing$value, this.excludeConnectedToOutgoing$value);
            return new DiagramTrimSettings(this.classesBlacklist$value == null ? Collections.emptyList() : this.classesBlacklist$value, this.explicitlyIncludedPackageNames$value == null ? Collections.emptyList() : this.explicitlyIncludedPackageNames$value, this.includeConnectedTo$value == null ? Collections.emptyList() : this.includeConnectedTo$value, this.includeConnectedToIngoing$value == null ? Collections.emptyList() : this.includeConnectedToIngoing$value, this.includeConnectedToOutgoing$value == null ? Collections.emptyList() : this.includeConnectedToOutgoing$value, this.excludeConnectedToIngoing$value == null ? Collections.emptyList() : this.excludeConnectedToIngoing$value, this.excludeConnectedToOutgoing$value == null ? Collections.emptyList() : this.excludeConnectedToOutgoing$value);
        }
    }
}

