/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.domain.config;

import io.domainlifecycles.diagram.DiagramConfig;
import io.domainlifecycles.diagram.domain.config.DiagramTrimSettings;
import io.domainlifecycles.diagram.domain.config.GeneralVisualSettings;
import io.domainlifecycles.diagram.domain.config.LayoutSettings;
import io.domainlifecycles.diagram.domain.config.StyleSettings;
import java.util.Objects;

public class DomainDiagramConfig
implements DiagramConfig {
    private GeneralVisualSettings generalVisualSettings = GeneralVisualSettings.builder().build();
    private LayoutSettings layoutSettings = LayoutSettings.builder().build();
    private StyleSettings styleSettings = StyleSettings.builder().build();
    private DiagramTrimSettings diagramTrimSettings = DiagramTrimSettings.builder().build();

    public GeneralVisualSettings getGeneralVisualSettings() {
        return this.generalVisualSettings;
    }

    public LayoutSettings getLayoutSettings() {
        return this.layoutSettings;
    }

    public StyleSettings getStyleSettings() {
        return this.styleSettings;
    }

    public DiagramTrimSettings getDiagramTrimSettings() {
        return this.diagramTrimSettings;
    }

    public void setGeneralVisualSettings(GeneralVisualSettings generalVisualSettings) {
        this.generalVisualSettings = Objects.requireNonNull(generalVisualSettings, "GeneralVisualSettings must not be null");
    }

    public void setLayoutSettings(LayoutSettings layoutSettings) {
        this.layoutSettings = Objects.requireNonNull(layoutSettings, "LayoutSettings must not be null");
    }

    public void setStyleSettings(StyleSettings styleSettings) {
        this.styleSettings = Objects.requireNonNull(styleSettings, "StyleSettings must not be null");
    }

    public void setDiagramTrimSettings(DiagramTrimSettings diagramTrimSettings) {
        this.diagramTrimSettings = Objects.requireNonNull(diagramTrimSettings, "DiagramTrimSettings must not be null");
    }

    public static DomainDiagramConfigBuilder builder() {
        return new DomainDiagramConfigBuilder();
    }

    public static class DomainDiagramConfigBuilder {
        private GeneralVisualSettings generalVisualSettings = GeneralVisualSettings.builder().build();
        private LayoutSettings layoutSettings = LayoutSettings.builder().build();
        private StyleSettings styleSettings = StyleSettings.builder().build();
        private DiagramTrimSettings diagramTrimSettings = DiagramTrimSettings.builder().build();

        public DomainDiagramConfigBuilder withGeneralVisualSettings(GeneralVisualSettings generalVisualSettings) {
            this.generalVisualSettings = Objects.requireNonNull(generalVisualSettings, "GeneralVisualSettings must not be null");
            return this;
        }

        public DomainDiagramConfigBuilder withLayoutSettings(LayoutSettings layoutSettings) {
            this.layoutSettings = Objects.requireNonNull(layoutSettings, "LayoutSettings must not be null");
            return this;
        }

        public DomainDiagramConfigBuilder withStyleSettings(StyleSettings styleSettings) {
            this.styleSettings = Objects.requireNonNull(styleSettings, "StyleSettings must not be null");
            return this;
        }

        public DomainDiagramConfigBuilder withDiagramTrimSettings(DiagramTrimSettings diagramTrimSettings) {
            this.diagramTrimSettings = Objects.requireNonNull(diagramTrimSettings, "DiagramTrimSettings must not be null");
            return this;
        }

        public DomainDiagramConfig build() {
            DomainDiagramConfig config = new DomainDiagramConfig();
            config.setGeneralVisualSettings(this.generalVisualSettings);
            config.setLayoutSettings(this.layoutSettings);
            config.setStyleSettings(this.styleSettings);
            config.setDiagramTrimSettings(this.diagramTrimSettings);
            return config;
        }
    }
}

