/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.domain.config;

public class LayoutSettings {
    private static final String DEFAULT_DIRECTION = "down";
    private static final String DEFAULT_RANKER = "longest-path";
    private static final String DEFAULT_ACYCLER = "greedy";
    private final String direction;
    private final String ranker;
    private final String acycler;

    private LayoutSettings(String direction, String ranker, String acycler) {
        this.direction = direction;
        this.ranker = ranker;
        this.acycler = acycler;
    }

    public String getDirection() {
        return this.direction;
    }

    public String getRanker() {
        return this.ranker;
    }

    public String getAcycler() {
        return this.acycler;
    }

    public static LayoutSettingsBuilder builder() {
        return new LayoutSettingsBuilder();
    }

    public static class LayoutSettingsBuilder {
        private String direction$value;
        private String ranker$value;
        private String acycler$value;

        LayoutSettingsBuilder() {
        }

        public LayoutSettingsBuilder withDirection(String direction) {
            this.direction$value = direction;
            return this;
        }

        public LayoutSettingsBuilder withRanker(String ranker) {
            this.ranker$value = ranker;
            return this;
        }

        public LayoutSettingsBuilder withAcycler(String acycler) {
            this.acycler$value = acycler;
            return this;
        }

        public LayoutSettings build() {
            return new LayoutSettings(this.direction$value == null ? LayoutSettings.DEFAULT_DIRECTION : this.direction$value, this.ranker$value == null ? LayoutSettings.DEFAULT_RANKER : this.ranker$value, this.acycler$value == null ? LayoutSettings.DEFAULT_ACYCLER : this.acycler$value);
        }
    }
}

