/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.domain.mapper;

import io.domainlifecycles.diagram.domain.config.DiagramTrimSettings;
import io.domainlifecycles.diagram.domain.config.GeneralVisualSettings;
import io.domainlifecycles.mirror.api.AggregateRootMirror;
import io.domainlifecycles.mirror.api.DomainCommandMirror;
import io.domainlifecycles.mirror.api.DomainEventMirror;
import io.domainlifecycles.mirror.api.DomainMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.QueryHandlerMirror;
import io.domainlifecycles.mirror.api.ReadModelMirror;
import io.domainlifecycles.mirror.api.RepositoryMirror;
import io.domainlifecycles.mirror.api.ServiceKindMirror;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class DiagramSettingsFilter {
    private final DiagramTrimSettings trimSettings;
    private final GeneralVisualSettings generalVisualSettings;
    private final Set<DomainTypeMirror> includedDomainTypes;
    private final DomainMirror domainMirror;

    public DiagramSettingsFilter(DomainMirror domainMirror, DiagramTrimSettings diagramTrimSettings, GeneralVisualSettings generalVisualSettings) {
        this.trimSettings = Objects.requireNonNull(diagramTrimSettings, "TrimSettings must be provided!");
        this.domainMirror = Objects.requireNonNull(domainMirror, "A DomainMirror must be provided!");
        this.generalVisualSettings = Objects.requireNonNull(generalVisualSettings, "GeneralVisualSettings must be provided!");
        this.includedDomainTypes = new HashSet<DomainTypeMirror>();
        this.includedDomainTypes.addAll(this.calculateConnectedIngoing(diagramTrimSettings.getIncludeConnectedToIngoing()));
        this.includedDomainTypes.addAll(this.calculateConnectedOutgoing(diagramTrimSettings.getIncludeConnectedToOutgoing()));
        this.includedDomainTypes.addAll(this.calculateConnected(diagramTrimSettings.getIncludeConnectedTo()));
        if (this.trimSettings.getIncludeConnectedTo().isEmpty() && this.trimSettings.getIncludeConnectedToIngoing().isEmpty() && this.trimSettings.getIncludeConnectedToOutgoing().isEmpty()) {
            this.includedDomainTypes.addAll(domainMirror.getAllDomainTypeMirrors());
        }
        this.includedDomainTypes.removeAll(this.calculateConnectedIngoing(diagramTrimSettings.getExcludeConnectedToIngoing()));
        this.includedDomainTypes.removeAll(this.calculateConnectedOutgoing(diagramTrimSettings.getExcludeConnectedToOutgoing()));
    }

    private Set<DomainTypeMirror> calculateConnected(List<String> typeNames) {
        HashSet<DomainTypeMirror> connectedTypes = new HashSet<DomainTypeMirror>(this.getTypeMirrors(typeNames));
        int size = 0;
        while (connectedTypes.size() != size) {
            size = connectedTypes.size();
            connectedTypes.addAll(this.getOutgoingTypeMirrors(connectedTypes));
            connectedTypes.addAll(this.getIngoingTypeMirrors(connectedTypes));
        }
        return connectedTypes;
    }

    private Set<DomainTypeMirror> calculateConnectedOutgoing(List<String> typeNames) {
        HashSet<DomainTypeMirror> connectedTypes = new HashSet<DomainTypeMirror>(this.getTypeMirrors(typeNames));
        int size = 0;
        while (connectedTypes.size() != size) {
            size = connectedTypes.size();
            connectedTypes.addAll(this.getOutgoingTypeMirrors(connectedTypes));
        }
        return connectedTypes;
    }

    private Set<DomainTypeMirror> calculateConnectedIngoing(List<String> typeNames) {
        HashSet<DomainTypeMirror> connectedTypes = new HashSet<DomainTypeMirror>(this.getTypeMirrors(typeNames));
        int size = 0;
        while (connectedTypes.size() != size) {
            size = connectedTypes.size();
            connectedTypes.addAll(this.getIngoingTypeMirrors(connectedTypes));
        }
        return connectedTypes;
    }

    private List<DomainTypeMirror> getTypeMirrors(List<String> seedTypeNames) {
        ArrayList<DomainTypeMirror> seedTypes = new ArrayList<DomainTypeMirror>();
        seedTypes.addAll(this.domainMirror.getAllServiceKindMirrors().stream().filter((? super T s) -> seedTypeNames.stream().anyMatch(t -> s.isSubClassOf(t) || s.implementsInterface(t))).toList());
        seedTypes.addAll(this.domainMirror.getAllAggregateRootMirrors().stream().filter((? super T s) -> seedTypeNames.stream().anyMatch(t -> s.isSubClassOf(t) || s.implementsInterface(t))).toList());
        seedTypes.addAll(this.domainMirror.getAllDomainEventMirrors().stream().filter((? super T s) -> seedTypeNames.stream().anyMatch(t -> s.isSubClassOf(t) || s.implementsInterface(t))).toList());
        seedTypes.addAll(this.domainMirror.getAllDomainCommandMirrors().stream().filter((? super T s) -> seedTypeNames.stream().anyMatch(t -> s.isSubClassOf(t) || s.implementsInterface(t))).toList());
        seedTypes.addAll(this.domainMirror.getAllReadModelMirrors().stream().filter((? super T s) -> seedTypeNames.stream().anyMatch(t -> s.isSubClassOf(t) || s.implementsInterface(t))).toList());
        return seedTypes;
    }

    private List<DomainTypeMirror> getIngoingTypeMirrors(Set<DomainTypeMirror> startingTypeMirrors) {
        ArrayList<DomainTypeMirror> ingoing = new ArrayList<DomainTypeMirror>(startingTypeMirrors);
        startingTypeMirrors.forEach(dtm -> {
            switch (dtm.getDomainType()) {
                case DOMAIN_EVENT: {
                    DomainEventMirror domainEventMirror = (DomainEventMirror)dtm;
                    ingoing.addAll(domainEventMirror.getPublishingAggregates());
                    ingoing.addAll(this.addConcreteServiceKinds(domainEventMirror.getPublishingServiceKinds()));
                    break;
                }
                case DOMAIN_SERVICE: 
                case QUERY_HANDLER: 
                case REPOSITORY: 
                case APPLICATION_SERVICE: 
                case OUTBOUND_SERVICE: 
                case SERVICE_KIND: {
                    ServiceKindMirror serviceKindMirror = (ServiceKindMirror)dtm;
                    ingoing.addAll(this.addConcreteServiceKinds(this.domainMirror.getAllServiceKindMirrors().stream().filter((? super T sk) -> sk.getReferencedServiceKinds().contains(serviceKindMirror)).toList()));
                    ingoing.addAll(serviceKindMirror.listenedDomainEvents());
                    ingoing.addAll(serviceKindMirror.processedDomainCommands());
                    break;
                }
                case READ_MODEL: {
                    ReadModelMirror readModelMirror = (ReadModelMirror)dtm;
                    ingoing.addAll(this.addConcreteServiceKinds(this.domainMirror.getAllQueryHandlerMirrors().stream().filter((? super T qh) -> qh.getProvidedReadModel().stream().anyMatch(readModelMirror::equals)).toList()));
                    break;
                }
                case AGGREGATE_ROOT: {
                    AggregateRootMirror aggregateRootMirror = (AggregateRootMirror)dtm;
                    ingoing.addAll(aggregateRootMirror.listenedDomainEvents());
                    ingoing.addAll(aggregateRootMirror.processedDomainCommands());
                    ingoing.addAll(this.addConcreteServiceKinds(this.domainMirror.getAllRepositoryMirrors().stream().filter((? super T qh) -> qh.getManagedAggregate().stream().anyMatch(aggregateRootMirror::equals)).toList()));
                }
            }
        });
        return ingoing;
    }

    private List<DomainTypeMirror> getOutgoingTypeMirrors(Set<DomainTypeMirror> startingTypeMirrors) {
        ArrayList<DomainTypeMirror> outgoing = new ArrayList<DomainTypeMirror>(startingTypeMirrors);
        startingTypeMirrors.forEach(dtm -> {
            switch (dtm.getDomainType()) {
                case DOMAIN_COMMAND: {
                    DomainCommandMirror domainCommandMirror = (DomainCommandMirror)dtm;
                    outgoing.addAll(domainCommandMirror.getProcessingServiceKinds());
                    break;
                }
                case DOMAIN_EVENT: {
                    DomainEventMirror domainEventMirror = (DomainEventMirror)dtm;
                    outgoing.addAll(domainEventMirror.getListeningAggregates());
                    outgoing.addAll(this.addConcreteServiceKinds(domainEventMirror.getListeningServiceKinds()));
                    break;
                }
                case DOMAIN_SERVICE: 
                case QUERY_HANDLER: 
                case REPOSITORY: 
                case APPLICATION_SERVICE: 
                case OUTBOUND_SERVICE: 
                case SERVICE_KIND: {
                    RepositoryMirror rep;
                    ServiceKindMirror serviceKindMirror = (ServiceKindMirror)dtm;
                    List ref = serviceKindMirror.getReferencedServiceKinds();
                    outgoing.addAll(this.addConcreteServiceKinds(ref));
                    outgoing.addAll(serviceKindMirror.publishedDomainEvents());
                    if (dtm.getDomainType().equals((Object)DomainType.REPOSITORY)) {
                        rep = (RepositoryMirror)dtm;
                        outgoing.addAll(rep.getManagedAggregate().stream().toList());
                    }
                    if (!dtm.getDomainType().equals((Object)DomainType.QUERY_HANDLER)) break;
                    rep = (QueryHandlerMirror)dtm;
                    outgoing.addAll(rep.getProvidedReadModel().stream().toList());
                    break;
                }
                case AGGREGATE_ROOT: {
                    AggregateRootMirror aggregateRootMirror = (AggregateRootMirror)dtm;
                    outgoing.addAll(aggregateRootMirror.publishedDomainEvents());
                }
            }
        });
        return outgoing;
    }

    private List<ServiceKindMirror> addConcreteServiceKinds(List<? extends ServiceKindMirror> ref) {
        ArrayList<ServiceKindMirror> includedServiceKinds = new ArrayList<ServiceKindMirror>(ref);
        ref.forEach(sk -> this.domainMirror.getAllServiceKindMirrors().stream().filter((? super T concrete) -> concrete.implementsInterface(sk.getTypeName())).forEach(includedServiceKinds::add));
        return includedServiceKinds;
    }

    public boolean filter(DomainTypeMirror dtm) {
        boolean contained;
        boolean bl = contained = !dtm.getTypeName().startsWith("io.domainlifecycles") && this.isIncludedByGeneralVisualSettings(dtm);
        if (!contained) {
            return false;
        }
        if (this.trimSettings.hasIncludedConnectedTypeSettings() || this.trimSettings.hasExcludedConnectedTypeSettings()) {
            contained = this.includedDomainTypes.contains(dtm);
        }
        if (!this.trimSettings.getExplicitlyIncludedPackageNames().isEmpty()) {
            contained = contained && this.trimSettings.getExplicitlyIncludedPackageNames().stream().anyMatch(p -> dtm.getTypeName().startsWith((String)p));
        }
        contained = contained && !this.trimSettings.getClassesBlacklist().contains(dtm.getTypeName()) && dtm.getAllInterfaceTypeNames().stream().noneMatch(it -> this.trimSettings.getClassesBlacklist().contains(it));
        return contained;
    }

    private boolean isIncludedByGeneralVisualSettings(DomainTypeMirror dtm) {
        boolean included;
        boolean bl = included = !dtm.isAbstract() || this.generalVisualSettings.isShowAllAbstractTypes();
        if (dtm.isAbstract() && dtm.getDomainType().equals((Object)DomainType.AGGREGATE_ROOT)) {
            included = included || this.generalVisualSettings.isShowAllAbstractTypes() || this.generalVisualSettings.isShowAbstractTypesInAggregates();
        }
        switch (dtm.getDomainType()) {
            case DOMAIN_EVENT: {
                included = included && this.generalVisualSettings.isShowDomainEvents();
                break;
            }
            case DOMAIN_SERVICE: {
                included = included && this.generalVisualSettings.isShowDomainServices();
                break;
            }
            case AGGREGATE_ROOT: 
            case ENTITY: {
                included = included && this.generalVisualSettings.isShowAggregates();
                break;
            }
            case READ_MODEL: {
                included = included && this.generalVisualSettings.isShowReadModels();
                break;
            }
            case QUERY_HANDLER: {
                included = included && this.generalVisualSettings.isShowQueryHandlers();
                break;
            }
            case REPOSITORY: {
                included = included && this.generalVisualSettings.isShowRepositories() && !dtm.getTypeName().equals("io.domainlifecycles.jooq.imp.JooqAggregateRepository");
                break;
            }
            case APPLICATION_SERVICE: {
                included = included && this.generalVisualSettings.isShowApplicationServices();
                break;
            }
            case OUTBOUND_SERVICE: {
                included = included && this.generalVisualSettings.isShowOutboundServices();
                break;
            }
            case DOMAIN_COMMAND: {
                included = included && this.generalVisualSettings.isShowDomainCommands();
                break;
            }
            case SERVICE_KIND: {
                included = included && this.generalVisualSettings.isShowUnspecifiedServiceKinds();
            }
        }
        return included;
    }
}

