/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.domain.mapper;

import io.domainlifecycles.diagram.domain.config.DomainDiagramConfig;
import io.domainlifecycles.diagram.domain.mapper.DomainMapperUtils;
import io.domainlifecycles.diagram.nomnoml.NomnomlClass;
import io.domainlifecycles.diagram.nomnoml.NomnomlField;
import io.domainlifecycles.diagram.nomnoml.NomnomlMethod;
import io.domainlifecycles.diagram.nomnoml.NomnomlParameter;
import io.domainlifecycles.diagram.nomnoml.NomnomlStereotype;
import io.domainlifecycles.diagram.nomnoml.NomnomlType;
import io.domainlifecycles.domain.types.Identity;
import io.domainlifecycles.mirror.api.AccessLevel;
import io.domainlifecycles.mirror.api.AggregateRootMirror;
import io.domainlifecycles.mirror.api.ApplicationServiceMirror;
import io.domainlifecycles.mirror.api.AssertedContainableTypeMirror;
import io.domainlifecycles.mirror.api.AssertionMirror;
import io.domainlifecycles.mirror.api.DomainCommandMirror;
import io.domainlifecycles.mirror.api.DomainEventMirror;
import io.domainlifecycles.mirror.api.DomainObjectMirror;
import io.domainlifecycles.mirror.api.DomainServiceMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.EntityMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.MethodMirror;
import io.domainlifecycles.mirror.api.OutboundServiceMirror;
import io.domainlifecycles.mirror.api.ParamMirror;
import io.domainlifecycles.mirror.api.QueryHandlerMirror;
import io.domainlifecycles.mirror.api.ReadModelMirror;
import io.domainlifecycles.mirror.api.RepositoryMirror;
import io.domainlifecycles.mirror.api.ResolvedGenericTypeMirror;
import io.domainlifecycles.mirror.api.ServiceKindMirror;
import io.domainlifecycles.mirror.api.ValueObjectMirror;
import io.domainlifecycles.mirror.model.AssertionType;
import io.domainlifecycles.mirror.visitor.ContextDomainObjectVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DomainClassMapper {
    private final DomainDiagramConfig domainDiagramConfig;

    public DomainClassMapper(DomainDiagramConfig domainDiagramConfig) {
        this.domainDiagramConfig = domainDiagramConfig;
    }

    public NomnomlClass mapDomainEventClass(DomainEventMirror domainEventMirror) {
        return this.mapToNomnomlClass((DomainTypeMirror)domainEventMirror, this.domainDiagramConfig.getGeneralVisualSettings().isShowDomainEventFields() && this.domainDiagramConfig.getGeneralVisualSettings().isShowFields(), this.domainDiagramConfig.getGeneralVisualSettings().isShowDomainEventMethods() && this.domainDiagramConfig.getGeneralVisualSettings().isShowMethods());
    }

    public NomnomlClass mapDomainCommandClass(DomainCommandMirror domainCommandMirror) {
        return this.mapToNomnomlClass((DomainTypeMirror)domainCommandMirror, this.domainDiagramConfig.getGeneralVisualSettings().isShowDomainCommandFields() && this.domainDiagramConfig.getGeneralVisualSettings().isShowFields(), this.domainDiagramConfig.getGeneralVisualSettings().isShowDomainCommandMethods() && this.domainDiagramConfig.getGeneralVisualSettings().isShowMethods());
    }

    public NomnomlClass mapDomainServiceClass(DomainServiceMirror domainServiceMirror) {
        return this.mapToNomnomlClass((DomainTypeMirror)domainServiceMirror, this.domainDiagramConfig.getGeneralVisualSettings().isShowDomainServiceFields() && this.domainDiagramConfig.getGeneralVisualSettings().isShowFields(), this.domainDiagramConfig.getGeneralVisualSettings().isShowDomainServiceMethods() && this.domainDiagramConfig.getGeneralVisualSettings().isShowMethods());
    }

    public NomnomlClass mapApplicationServiceClass(ApplicationServiceMirror applicationServiceMirror) {
        return this.mapToNomnomlClass((DomainTypeMirror)applicationServiceMirror, this.domainDiagramConfig.getGeneralVisualSettings().isShowDomainServiceFields() && this.domainDiagramConfig.getGeneralVisualSettings().isShowFields(), this.domainDiagramConfig.getGeneralVisualSettings().isShowDomainServiceMethods() && this.domainDiagramConfig.getGeneralVisualSettings().isShowMethods());
    }

    public NomnomlClass mapRepositoryClass(RepositoryMirror repositoryMirror) {
        return this.mapToNomnomlClass((DomainTypeMirror)repositoryMirror, this.domainDiagramConfig.getGeneralVisualSettings().isShowRepositoryFields() && this.domainDiagramConfig.getGeneralVisualSettings().isShowFields(), this.domainDiagramConfig.getGeneralVisualSettings().isShowRepositoryMethods() && this.domainDiagramConfig.getGeneralVisualSettings().isShowMethods());
    }

    public NomnomlClass mapReadModelClass(ReadModelMirror readModelMirror) {
        return this.mapToNomnomlClass((DomainTypeMirror)readModelMirror, this.domainDiagramConfig.getGeneralVisualSettings().isShowReadModelFields() && this.domainDiagramConfig.getGeneralVisualSettings().isShowFields(), this.domainDiagramConfig.getGeneralVisualSettings().isShowReadModelMethods() && this.domainDiagramConfig.getGeneralVisualSettings().isShowMethods());
    }

    public NomnomlClass mapQueryHandlerClass(QueryHandlerMirror queryHandlerMirror) {
        return this.mapToNomnomlClass((DomainTypeMirror)queryHandlerMirror, this.domainDiagramConfig.getGeneralVisualSettings().isShowQueryHandlerFields() && this.domainDiagramConfig.getGeneralVisualSettings().isShowFields(), this.domainDiagramConfig.getGeneralVisualSettings().isShowQueryHandlerMethods() && this.domainDiagramConfig.getGeneralVisualSettings().isShowMethods());
    }

    public NomnomlClass mapOutboundServiceClass(OutboundServiceMirror outboundServiceMirror) {
        return this.mapToNomnomlClass((DomainTypeMirror)outboundServiceMirror, this.domainDiagramConfig.getGeneralVisualSettings().isShowOutboundServiceFields() && this.domainDiagramConfig.getGeneralVisualSettings().isShowFields(), this.domainDiagramConfig.getGeneralVisualSettings().isShowOutboundServiceMethods() && this.domainDiagramConfig.getGeneralVisualSettings().isShowMethods());
    }

    public NomnomlClass mapUnspecifiedServiceKindClass(ServiceKindMirror serviceKindMirror) {
        return this.mapToNomnomlClass((DomainTypeMirror)serviceKindMirror, this.domainDiagramConfig.getGeneralVisualSettings().isShowUnspecifiedServiceKindFields() && this.domainDiagramConfig.getGeneralVisualSettings().isShowFields(), this.domainDiagramConfig.getGeneralVisualSettings().isShowUnspecifiedServiceKindMethods() && this.domainDiagramConfig.getGeneralVisualSettings().isShowMethods());
    }

    public List<NomnomlClass> mapAllAggregateClasses(AggregateRootMirror aggregateRootMirror) {
        final ArrayList<NomnomlClass> aggregateClasses = new ArrayList<NomnomlClass>();
        ContextDomainObjectVisitor visitor = new ContextDomainObjectVisitor((DomainObjectMirror)aggregateRootMirror){

            public void visitEnterAnyDomainType(DomainTypeMirror domainTypeMirror) {
                if (List.of(DomainType.AGGREGATE_ROOT, DomainType.ENTITY, DomainType.VALUE_OBJECT).contains(domainTypeMirror.getDomainType()) && !DomainClassMapper.this.domainDiagramConfig.getDiagramTrimSettings().getClassesBlacklist().contains(domainTypeMirror.getTypeName())) {
                    if (DomainType.VALUE_OBJECT.equals((Object)domainTypeMirror.getDomainType())) {
                        ValueObjectMirror voMirror = (ValueObjectMirror)domainTypeMirror;
                        if (!voMirror.isSingledValued()) {
                            aggregateClasses.add(DomainClassMapper.this.mapToNomnomlClass(domainTypeMirror, DomainClassMapper.this.domainDiagramConfig.getGeneralVisualSettings().isShowAggregateFields() && DomainClassMapper.this.domainDiagramConfig.getGeneralVisualSettings().isShowFields(), DomainClassMapper.this.domainDiagramConfig.getGeneralVisualSettings().isShowAggregateMethods() && DomainClassMapper.this.domainDiagramConfig.getGeneralVisualSettings().isShowMethods()));
                        }
                    } else {
                        aggregateClasses.add(DomainClassMapper.this.mapToNomnomlClass(domainTypeMirror, DomainClassMapper.this.domainDiagramConfig.getGeneralVisualSettings().isShowAggregateFields() && DomainClassMapper.this.domainDiagramConfig.getGeneralVisualSettings().isShowFields(), DomainClassMapper.this.domainDiagramConfig.getGeneralVisualSettings().isShowAggregateMethods() && DomainClassMapper.this.domainDiagramConfig.getGeneralVisualSettings().isShowMethods()));
                    }
                }
            }
        };
        visitor.start();
        return aggregateClasses;
    }

    private NomnomlClass mapToNomnomlClass(DomainTypeMirror domainTypeMirror, boolean showFields, boolean showMethods) {
        String className = DomainMapperUtils.domainTypeName(domainTypeMirror, this.domainDiagramConfig);
        NomnomlClass.NomnomlClassBuilder nomnomlClassBuilder = NomnomlClass.builder().styleClassifier(DomainMapperUtils.styleClassifier(domainTypeMirror)).stereotypes(List.of(NomnomlStereotype.builder().name(DomainMapperUtils.stereotype(domainTypeMirror, this.domainDiagramConfig)).build())).name(className).comment("!!! " + domainTypeMirror.getTypeName() + " !!!").showFields(showFields).showMethods(showMethods);
        if (showFields) {
            EntityMirror entityMirror;
            String inheritedIdentityName = "";
            if (domainTypeMirror.getDomainType().equals((Object)DomainType.ENTITY) || domainTypeMirror.getDomainType().equals((Object)DomainType.AGGREGATE_ROOT)) {
                EntityMirror entityMirror2 = (EntityMirror)domainTypeMirror;
                inheritedIdentityName = entityMirror2.getIdentityField().isPresent() ? ((FieldMirror)entityMirror2.getIdentityField().get()).getName() : Identity.class.getName();
            }
            String inheritedIdentityNameFinal = inheritedIdentityName;
            ArrayList<NomnomlField> allShownFields = new ArrayList<NomnomlField>();
            List<NomnomlField> basicFields = domainTypeMirror.getAllFields().stream().filter(p -> !p.isIdentityField()).filter(p -> !p.isHidden()).filter(p -> !p.isStatic()).filter(p -> !p.getName().equals(inheritedIdentityNameFinal)).filter(p -> !this.domainDiagramConfig.getGeneralVisualSettings().getFieldBlacklist().contains(p.getName())).filter(p -> DomainMapperUtils.showPropertyInline(p, domainTypeMirror, this.domainDiagramConfig)).filter(p -> {
                if (!this.domainDiagramConfig.getGeneralVisualSettings().isShowInheritedMembersInClasses()) {
                    return p.getDeclaredByTypeName().equals(domainTypeMirror.getTypeName());
                }
                return true;
            }).filter(p -> {
                if (!this.domainDiagramConfig.getGeneralVisualSettings().isShowObjectMembersInClasses()) {
                    return !p.getDeclaredByTypeName().equals(Object.class.getName());
                }
                return true;
            }).sorted(new PropertyComparator()).map(this::mapToNomnomlField).distinct().toList();
            if ((DomainType.ENTITY.equals((Object)domainTypeMirror.getDomainType()) || DomainType.AGGREGATE_ROOT.equals((Object)domainTypeMirror.getDomainType())) && (entityMirror = (EntityMirror)domainTypeMirror).getIdentityField().isPresent()) {
                allShownFields.add(this.mapToNomnomlField((FieldMirror)entityMirror.getIdentityField().get()));
            }
            allShownFields.addAll(basicFields);
            nomnomlClassBuilder.fields(allShownFields);
        } else {
            nomnomlClassBuilder.fields(Collections.emptyList());
        }
        if (showMethods) {
            nomnomlClassBuilder.methods(domainTypeMirror.getMethods().stream().filter(m -> !this.domainDiagramConfig.getGeneralVisualSettings().isShowOnlyPublicMethods() || m.getAccessLevel().equals((Object)AccessLevel.PUBLIC)).filter(m -> !m.isOverridden()).filter(m -> !this.domainDiagramConfig.getGeneralVisualSettings().getMethodBlacklist().contains(m.getName())).filter(m -> {
                if (!this.domainDiagramConfig.getGeneralVisualSettings().isShowInheritedMembersInClasses()) {
                    return m.getDeclaredByTypeName().equals(domainTypeMirror.getTypeName());
                }
                return true;
            }).filter(m -> {
                if (!this.domainDiagramConfig.getGeneralVisualSettings().isShowObjectMembersInClasses()) {
                    return !m.getDeclaredByTypeName().equals(Object.class.getName());
                }
                return true;
            }).filter(m -> !m.isGetter() && !m.isSetter()).sorted(new MethodComparator()).map(this::mapToNomnomlMethod).distinct().collect(Collectors.toList()));
        } else {
            nomnomlClassBuilder.methods(Collections.emptyList());
        }
        return nomnomlClassBuilder.build();
    }

    private NomnomlType mapToNomnomlType(AssertedContainableTypeMirror assertedContainableTypeMirror) {
        Optional<String> containerTypeName;
        Object typeName;
        if (assertedContainableTypeMirror.getResolvedGenericType() == null || assertedContainableTypeMirror.getResolvedGenericType().genericTypes() == null || assertedContainableTypeMirror.getResolvedGenericType().genericTypes().isEmpty()) {
            typeName = DomainMapperUtils.mapTypeName(assertedContainableTypeMirror.getTypeName(), this.domainDiagramConfig);
            if (assertedContainableTypeMirror.isArray()) {
                typeName = (String)typeName + "[]";
            }
            containerTypeName = assertedContainableTypeMirror.getContainerTypeName().map(cn -> DomainMapperUtils.mapTypeName(cn, this.domainDiagramConfig));
        } else {
            ResolvedGenericTypeMirror genericType = assertedContainableTypeMirror.getResolvedGenericType();
            if (assertedContainableTypeMirror.hasContainer()) {
                typeName = DomainMapperUtils.mapTypeName(((ResolvedGenericTypeMirror)genericType.genericTypes().get(0)).typeName(), this.domainDiagramConfig);
                if (genericType.isArray()) {
                    typeName = (String)typeName + "[]";
                }
                containerTypeName = assertedContainableTypeMirror.getContainerTypeName().map(cn -> DomainMapperUtils.mapTypeName(cn, this.domainDiagramConfig));
            } else if (genericType.isArray()) {
                typeName = DomainMapperUtils.mapTypeName(genericType.typeName() + "[]", this.domainDiagramConfig);
                containerTypeName = Optional.empty();
            } else if (genericType.genericTypes().isEmpty()) {
                typeName = DomainMapperUtils.mapTypeName(genericType.typeName(), this.domainDiagramConfig);
                containerTypeName = Optional.empty();
            } else {
                containerTypeName = Optional.of(DomainMapperUtils.mapTypeName(genericType.typeName(), this.domainDiagramConfig));
                typeName = genericType.genericTypes().stream().map(tn -> tn.typeName() + (tn.isArray() ? "[]" : "")).map(tn -> DomainMapperUtils.mapTypeName(tn, this.domainDiagramConfig)).collect(Collectors.joining(", "));
            }
        }
        return NomnomlType.builder().typeName((String)typeName).typeAssertions(this.assertionList(assertedContainableTypeMirror.getAssertions())).containerTypeAssertions(this.assertionList(assertedContainableTypeMirror.getContainerAssertions())).containerTypeName(containerTypeName).build();
    }

    private NomnomlField mapToNomnomlField(FieldMirror fieldMirror) {
        return NomnomlField.builder().name(fieldMirror.getName()).typePrefix(this.fieldStereoType(fieldMirror)).required(fieldMirror.isIdentityField() || this.isTypeRequired(fieldMirror.getType())).type(this.mapToNomnomlType(fieldMirror.getType())).visibility(this.fieldVisibility(fieldMirror)).build();
    }

    private Optional<String> fieldStereoType(FieldMirror fieldMirror) {
        Optional<String> typePrefix = Optional.empty();
        if (this.domainDiagramConfig.getGeneralVisualSettings().isFieldStereotypes()) {
            if (fieldMirror.isIdentityField()) {
                return Optional.of("<ID>");
            }
            if (fieldMirror.getType().getDomainType().equals((Object)DomainType.ENUM)) {
                return Optional.of("<ENUM>");
            }
            if (fieldMirror.getType().getDomainType().equals((Object)DomainType.VALUE_OBJECT)) {
                return Optional.of("<VO>");
            }
            if (fieldMirror.getType().getDomainType().equals((Object)DomainType.ENTITY)) {
                return Optional.of("<ENTITY>");
            }
            if (fieldMirror.getType().getDomainType().equals((Object)DomainType.AGGREGATE_ROOT)) {
                return Optional.of("<AR>");
            }
            if (fieldMirror.getType().getDomainType().equals((Object)DomainType.IDENTITY)) {
                return Optional.of("<IDREF>");
            }
        }
        return typePrefix;
    }

    private boolean isTypeRequired(AssertedContainableTypeMirror assertedContainableTypeMirror) {
        if (!assertedContainableTypeMirror.hasContainer()) {
            return assertedContainableTypeMirror.getAssertions().stream().anyMatch(a -> AssertionType.isNotNull.equals((Object)a.getAssertionType()) || AssertionType.isNotEmpty.equals((Object)a.getAssertionType()));
        }
        if (!assertedContainableTypeMirror.hasOptionalContainer()) {
            return assertedContainableTypeMirror.getAssertions().stream().anyMatch(a -> AssertionType.isNotNull.equals((Object)a.getAssertionType()));
        }
        return false;
    }

    private String fieldVisibility(FieldMirror propertyMirror) {
        Object visibility = "";
        visibility = propertyMirror.isPublicReadable() ? (String)visibility + "+" : (String)visibility + "-";
        visibility = propertyMirror.isPublicWriteable() ? (String)visibility + "+" : (String)visibility + "-";
        return visibility;
    }

    private NomnomlMethod mapToNomnomlMethod(MethodMirror methodMirror) {
        return NomnomlMethod.builder().name(methodMirror.getName()).returnType(this.mapToNomnomlType(methodMirror.getReturnType())).visibility(this.methodVisibility(methodMirror)).parameters(methodMirror.getParameters().stream().map(this::mapToNomnomlParameter).collect(Collectors.toList())).build();
    }

    private NomnomlParameter mapToNomnomlParameter(ParamMirror paramMirror) {
        return NomnomlParameter.builder().required(this.isTypeRequired(paramMirror.getType())).type(this.mapToNomnomlType(paramMirror.getType())).build();
    }

    private String methodVisibility(MethodMirror methodMirror) {
        if (AccessLevel.PUBLIC.equals((Object)methodMirror.getAccessLevel())) {
            return "+";
        }
        return "-";
    }

    private List<String> assertionList(List<AssertionMirror> assertionMirrors) {
        if (assertionMirrors != null && this.domainDiagramConfig.getGeneralVisualSettings().isShowAssertions()) {
            return assertionMirrors.stream().sorted(new AssertionComparator()).map(this::assertionStringAfterType).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String assertionStringAfterType(AssertionMirror assertionMirror) {
        return switch (assertionMirror.getAssertionType()) {
            case AssertionType.regEx -> "regEx{" + assertionMirror.getParam1() + "}";
            case AssertionType.hasLength, AssertionType.hasSize -> "\\[" + assertionMirror.getParam1() + "," + assertionMirror.getParam2() + "\\]";
            case AssertionType.hasSizeMin, AssertionType.hasLengthMin -> "\\[" + assertionMirror.getParam1() + ",*\\]";
            case AssertionType.hasSizeMax, AssertionType.hasLengthMax -> "\\[0," + assertionMirror.getParam2() + "\\]";
            case AssertionType.hasMaxDigits -> "(" + assertionMirror.getParam1() + "," + assertionMirror.getParam2() + ")";
            case AssertionType.hasMaxDigitsFraction -> "(*," + assertionMirror.getParam2() + ")";
            case AssertionType.hasMaxDigitsInteger -> "(" + assertionMirror.getParam1() + ",*)";
            case AssertionType.isAfter -> "{after(>):" + assertionMirror.getParam1() + "}";
            case AssertionType.isBefore -> "{before(<):" + assertionMirror.getParam1() + "}";
            case AssertionType.isAfterOrEqualTo -> "{after(>=):" + assertionMirror.getParam1() + "}";
            case AssertionType.isBeforeOrEqualTo -> "{before(<=):" + assertionMirror.getParam1() + "}";
            case AssertionType.isFutureOrPresent -> "{futureOrPresent}";
            case AssertionType.isFuture -> "{future}";
            case AssertionType.isPastOrPresent -> "{pastOrPresent}";
            case AssertionType.isPast -> "{past}";
            case AssertionType.equals -> "{=" + assertionMirror.getParam1() + "}";
            case AssertionType.notEquals -> "{<>" + assertionMirror.getParam1() + "}";
            case AssertionType.isFalse -> "{false}";
            case AssertionType.isTrue -> "{true}";
            case AssertionType.isNegative -> "{<0}";
            case AssertionType.isNegativeOrZero -> "{<=0}";
            case AssertionType.isPositive -> "{>0}";
            case AssertionType.isPositiveOrZero -> "{>=0}";
            case AssertionType.isGreaterThan -> "{>" + assertionMirror.getParam1() + "}";
            case AssertionType.isGreaterOrEqual, AssertionType.isGreaterOrEqualNonDecimal -> "{>=" + assertionMirror.getParam1() + "}";
            case AssertionType.isLessThan -> "{<" + assertionMirror.getParam2() + "}";
            case AssertionType.isLessOrEqual, AssertionType.isLessOrEqualNonDecimal -> "{<=" + assertionMirror.getParam2() + "}";
            case AssertionType.isValidEmail -> "{EMAIL}";
            case AssertionType.isInRange -> "{" + assertionMirror.getParam1() + "<x<" + assertionMirror.getParam2() + "}";
            case AssertionType.isNotBlank -> "{notBlank}";
            case AssertionType.isNotEmpty -> "{notEmpty}";
            case AssertionType.isNotEmptyIterable -> "\\[1,*\\]";
            case AssertionType.isNull -> "{null}";
            case AssertionType.isOneOf -> "{oneOf:" + assertionMirror.getParam1() + "}";
            default -> "";
        };
    }

    private static class PropertyComparator
    implements Comparator<FieldMirror> {
        private PropertyComparator() {
        }

        @Override
        public int compare(FieldMirror o1, FieldMirror o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static class MethodComparator
    implements Comparator<MethodMirror> {
        private MethodComparator() {
        }

        @Override
        public int compare(MethodMirror o1, MethodMirror o2) {
            int result = o1.getName().compareTo(o2.getName());
            if (result == 0) {
                Integer size2;
                Integer size1 = o1.getParameters().size();
                result = size1.compareTo(size2 = Integer.valueOf(o2.getParameters().size()));
                if (result == 0 && size1 > 0) {
                    List<String> parameterTypes1 = o1.getParameters().stream().map(p -> p.getType().getTypeName()).toList();
                    List<String> parameterTypes2 = o2.getParameters().stream().map(p -> p.getType().getTypeName()).toList();
                    Iterator it1 = parameterTypes1.iterator();
                    Iterator it2 = parameterTypes2.iterator();
                    while (it1.hasNext() && it2.hasNext()) {
                        result = ((String)it1.next()).compareTo((String)it2.next());
                        if (result == 0) continue;
                        return result;
                    }
                }
                if (result == 0) {
                    result = o1.getAccessLevel().compareTo((Enum)o2.getAccessLevel());
                }
            }
            return result;
        }
    }

    private static class AssertionComparator
    implements Comparator<AssertionMirror> {
        private AssertionComparator() {
        }

        @Override
        public int compare(AssertionMirror o1, AssertionMirror o2) {
            return this.assertionOrderIndex(o1) - this.assertionOrderIndex(o2);
        }

        private int assertionOrderIndex(AssertionMirror assertionMirror) {
            return switch (assertionMirror.getAssertionType()) {
                case AssertionType.regEx -> 1;
                case AssertionType.hasLength -> 0;
                case AssertionType.hasSize -> 4;
                case AssertionType.hasSizeMin -> 2;
                case AssertionType.hasSizeMax -> 3;
                case AssertionType.hasMaxDigits -> 7;
                case AssertionType.hasMaxDigitsFraction -> 6;
                case AssertionType.hasMaxDigitsInteger -> 5;
                case AssertionType.isAfter -> 12;
                case AssertionType.isBefore -> 14;
                case AssertionType.isAfterOrEqualTo -> 13;
                case AssertionType.isBeforeOrEqualTo -> 15;
                case AssertionType.isFutureOrPresent -> 9;
                case AssertionType.isFuture -> 8;
                case AssertionType.isPastOrPresent -> 10;
                case AssertionType.isPast -> 11;
                case AssertionType.equals -> 16;
                case AssertionType.notEquals -> 17;
                case AssertionType.isFalse -> 18;
                case AssertionType.isTrue -> 19;
                case AssertionType.hasLengthMax -> -4;
                case AssertionType.hasLengthMin -> -5;
                case AssertionType.isNegative -> 20;
                case AssertionType.isNegativeOrZero -> 21;
                case AssertionType.isPositive -> 22;
                case AssertionType.isPositiveOrZero -> 23;
                case AssertionType.isGreaterThan -> 24;
                case AssertionType.isGreaterOrEqual -> 25;
                case AssertionType.isLessThan -> 26;
                case AssertionType.isLessOrEqual -> 27;
                case AssertionType.isGreaterOrEqualNonDecimal -> 28;
                case AssertionType.isLessOrEqualNonDecimal -> 29;
                case AssertionType.isValidEmail -> 30;
                case AssertionType.isInRange -> 31;
                case AssertionType.isNotBlank -> 32;
                case AssertionType.isNotEmpty -> 33;
                case AssertionType.isNotEmptyIterable -> 34;
                case AssertionType.isNull -> 35;
                case AssertionType.isOneOf -> 36;
                default -> 99;
            };
        }
    }
}

