/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.domain.mapper;

import io.domainlifecycles.diagram.DiagramElement;
import io.domainlifecycles.diagram.domain.config.DomainDiagramConfig;
import io.domainlifecycles.diagram.domain.mapper.DomainClassMapper;
import io.domainlifecycles.diagram.domain.mapper.DomainMapperUtils;
import io.domainlifecycles.diagram.domain.mapper.DomainRelationshipMapper;
import io.domainlifecycles.diagram.domain.mapper.FilteredDomainClasses;
import io.domainlifecycles.diagram.nomnoml.NomnomlClass;
import io.domainlifecycles.diagram.nomnoml.NomnomlFrame;
import io.domainlifecycles.diagram.nomnoml.NomnomlRelationship;
import io.domainlifecycles.mirror.api.AggregateRootMirror;
import io.domainlifecycles.mirror.api.DomainMirror;
import java.util.ArrayList;
import java.util.List;

public class DomainMapper {
    private final DomainDiagramConfig domainDiagramConfig;
    private final DomainClassMapper domainClassMapper;
    private final DomainRelationshipMapper domainRelationshipMapper;
    private final FilteredDomainClasses filteredDomainClasses;

    public DomainMapper(DomainDiagramConfig domainDiagramConfig, DomainMirror domainMirror) {
        this.domainDiagramConfig = domainDiagramConfig;
        this.filteredDomainClasses = new FilteredDomainClasses(domainDiagramConfig.getDiagramTrimSettings(), domainDiagramConfig.getGeneralVisualSettings(), domainMirror);
        this.domainClassMapper = new DomainClassMapper(domainDiagramConfig);
        this.domainRelationshipMapper = new DomainRelationshipMapper(domainDiagramConfig, domainMirror, this.filteredDomainClasses);
    }

    public List<NomnomlClass> getApplicationServices() {
        return this.filteredDomainClasses.getApplicationServices().stream().map(this.domainClassMapper::mapApplicationServiceClass).toList();
    }

    public List<NomnomlClass> getDomainCommands() {
        return this.filteredDomainClasses.getDomainCommands().stream().map(this.domainClassMapper::mapDomainCommandClass).toList();
    }

    public List<NomnomlClass> getDomainEvents() {
        return this.filteredDomainClasses.getDomainEvents().stream().map(this.domainClassMapper::mapDomainEventClass).toList();
    }

    public List<NomnomlClass> getDomainServices() {
        return this.filteredDomainClasses.getDomainServices().stream().map(this.domainClassMapper::mapDomainServiceClass).toList();
    }

    public List<NomnomlClass> getRepositories() {
        return this.filteredDomainClasses.getRepositories().stream().map(this.domainClassMapper::mapRepositoryClass).toList();
    }

    public List<NomnomlClass> getReadModels() {
        return this.filteredDomainClasses.getReadModels().stream().map(this.domainClassMapper::mapReadModelClass).toList();
    }

    public List<NomnomlClass> getQueryHandlers() {
        return this.filteredDomainClasses.getQueryHandlers().stream().map(this.domainClassMapper::mapQueryHandlerClass).toList();
    }

    public List<NomnomlClass> getOutboundServices() {
        return this.filteredDomainClasses.getOutboundServices().stream().map(this.domainClassMapper::mapOutboundServiceClass).toList();
    }

    public List<NomnomlClass> getUnspecifiedServiceKinds() {
        return this.filteredDomainClasses.getUnspecifiedServiceKinds().stream().map(this.domainClassMapper::mapUnspecifiedServiceKindClass).toList();
    }

    public List<NomnomlFrame> getAggregateFrames() {
        return this.filteredDomainClasses.getAggregateRoots().stream().map(this::getAggregateFrame).toList();
    }

    private NomnomlFrame getAggregateFrame(AggregateRootMirror aggregateRootMirror) {
        List<NomnomlClass> aggregateClasses = this.domainClassMapper.mapAllAggregateClasses(aggregateRootMirror);
        List<NomnomlRelationship> aggregateRelationShips = this.domainRelationshipMapper.mapAllAggregateRelationships(aggregateRootMirror);
        ArrayList<DiagramElement> allElements = new ArrayList<DiagramElement>(aggregateClasses);
        allElements.addAll(aggregateRelationShips);
        return NomnomlFrame.builder().name(DomainMapperUtils.mapTypeName(aggregateRootMirror.getTypeName(), this.domainDiagramConfig)).comment("!!! {Frame} " + aggregateRootMirror.getTypeName() + " !!!").type("<<Aggregate>>").styleClassifier("AF").innerElements(allElements).build();
    }

    public DomainRelationshipMapper getDomainRelationshipMapper() {
        return this.domainRelationshipMapper;
    }
}

