/*
 * Decompiled with CFR 0.152.
 */
package io.domainlifecycles.diagram.domain.mapper;

import io.domainlifecycles.diagram.domain.config.DomainDiagramConfig;
import io.domainlifecycles.mirror.api.ApplicationServiceMirror;
import io.domainlifecycles.mirror.api.DomainServiceMirror;
import io.domainlifecycles.mirror.api.DomainType;
import io.domainlifecycles.mirror.api.DomainTypeMirror;
import io.domainlifecycles.mirror.api.EntityReferenceMirror;
import io.domainlifecycles.mirror.api.FieldMirror;
import io.domainlifecycles.mirror.api.OutboundServiceMirror;
import io.domainlifecycles.mirror.api.QueryHandlerMirror;
import io.domainlifecycles.mirror.api.RepositoryMirror;
import io.domainlifecycles.mirror.api.ValueObjectMirror;
import io.domainlifecycles.mirror.api.ValueReferenceMirror;

public class DomainMapperUtils {
    public static String domainTypeName(DomainTypeMirror domainTypeMirror, DomainDiagramConfig domainDiagramConfig) {
        String name = DomainMapperUtils.mapTypeName(domainTypeMirror.getTypeName(), domainDiagramConfig);
        if (domainDiagramConfig.getGeneralVisualSettings().isUseAbstractTypeNameForConcreteServiceKinds()) {
            QueryHandlerMirror queryHandlerMirror;
            if (domainTypeMirror.getDomainType().equals((Object)DomainType.REPOSITORY)) {
                RepositoryMirror repositoryMirror = (RepositoryMirror)domainTypeMirror;
                if (!repositoryMirror.getRepositoryInterfaceTypeNames().isEmpty() && !repositoryMirror.isAbstract()) {
                    name = DomainMapperUtils.mapTypeName((String)repositoryMirror.getRepositoryInterfaceTypeNames().get(0), domainDiagramConfig);
                }
            } else if (domainTypeMirror.getDomainType().equals((Object)DomainType.DOMAIN_SERVICE)) {
                DomainServiceMirror domainServiceMirror = (DomainServiceMirror)domainTypeMirror;
                if (!domainServiceMirror.getDomainServiceInterfaceTypeNames().isEmpty() && !domainServiceMirror.isAbstract()) {
                    name = DomainMapperUtils.mapTypeName((String)domainServiceMirror.getDomainServiceInterfaceTypeNames().get(0), domainDiagramConfig);
                }
            } else if (domainTypeMirror.getDomainType().equals((Object)DomainType.APPLICATION_SERVICE)) {
                ApplicationServiceMirror applicationServiceMirror = (ApplicationServiceMirror)domainTypeMirror;
                if (!applicationServiceMirror.getApplicationServiceInterfaceTypeNames().isEmpty() && !applicationServiceMirror.isAbstract()) {
                    name = DomainMapperUtils.mapTypeName((String)applicationServiceMirror.getApplicationServiceInterfaceTypeNames().get(0), domainDiagramConfig);
                }
            } else if (domainTypeMirror.getDomainType().equals((Object)DomainType.OUTBOUND_SERVICE)) {
                OutboundServiceMirror outboundServiceMirror = (OutboundServiceMirror)domainTypeMirror;
                if (!outboundServiceMirror.getOutboundServiceInterfaceTypeNames().isEmpty() && !outboundServiceMirror.isAbstract()) {
                    name = DomainMapperUtils.mapTypeName((String)outboundServiceMirror.getOutboundServiceInterfaceTypeNames().get(0), domainDiagramConfig);
                }
            } else if (domainTypeMirror.getDomainType().equals((Object)DomainType.QUERY_HANDLER) && !(queryHandlerMirror = (QueryHandlerMirror)domainTypeMirror).getQueryHandlerInterfaceTypeNames().isEmpty() && !queryHandlerMirror.isAbstract()) {
                name = DomainMapperUtils.mapTypeName((String)queryHandlerMirror.getQueryHandlerInterfaceTypeNames().get(0), domainDiagramConfig);
            }
        }
        return name;
    }

    public static String mapTypeName(String fullQualifiedName, DomainDiagramConfig domainDiagramConfig) {
        return domainDiagramConfig.getGeneralVisualSettings().isShowFullQualifiedClassNames() ? fullQualifiedName : DomainMapperUtils.simpleTypeName(fullQualifiedName);
    }

    public static boolean showPropertyInline(FieldMirror propertyMirror, DomainTypeMirror domainTypeMirror, DomainDiagramConfig domainDiagramConfig) {
        if (DomainType.NON_DOMAIN.equals((Object)domainTypeMirror.getDomainType()) || DomainType.DOMAIN_EVENT.equals((Object)domainTypeMirror.getDomainType()) || DomainType.DOMAIN_COMMAND.equals((Object)domainTypeMirror.getDomainType()) || DomainType.READ_MODEL.equals((Object)domainTypeMirror.getDomainType()) || DomainType.QUERY_HANDLER.equals((Object)domainTypeMirror.getDomainType()) || DomainType.DOMAIN_SERVICE.equals((Object)domainTypeMirror.getDomainType()) || DomainType.OUTBOUND_SERVICE.equals((Object)domainTypeMirror.getDomainType()) || DomainType.SERVICE_KIND.equals((Object)domainTypeMirror.getDomainType())) {
            return true;
        }
        if (DomainType.AGGREGATE_ROOT.equals((Object)domainTypeMirror.getDomainType()) || DomainType.ENTITY.equals((Object)domainTypeMirror.getDomainType()) || DomainType.VALUE_OBJECT.equals((Object)domainTypeMirror.getDomainType())) {
            if (propertyMirror instanceof EntityReferenceMirror) {
                EntityReferenceMirror erm = (EntityReferenceMirror)propertyMirror;
                return domainDiagramConfig.getDiagramTrimSettings().getClassesBlacklist().contains(erm.getType().getTypeName());
            }
            if (propertyMirror instanceof ValueReferenceMirror) {
                ValueReferenceMirror valueRef = (ValueReferenceMirror)propertyMirror;
                if (valueRef.getValue().isEnum() || valueRef.getValue().isIdentity()) {
                    return true;
                }
                ValueObjectMirror valueObjectMirror = (ValueObjectMirror)valueRef.getValue();
                return valueObjectMirror.isSingledValued() || domainDiagramConfig.getDiagramTrimSettings().getClassesBlacklist().contains(valueObjectMirror.getTypeName());
            }
            return true;
        }
        return false;
    }

    public static String styleClassifier(DomainTypeMirror domainTypeMirror) {
        if (domainTypeMirror == null) {
            return "";
        }
        return switch (domainTypeMirror.getDomainType()) {
            case DomainType.AGGREGATE_ROOT -> "<AR>";
            case DomainType.ENTITY -> "<E>";
            case DomainType.VALUE_OBJECT -> "<VO>";
            case DomainType.ENUM -> "<V>";
            case DomainType.DOMAIN_SERVICE -> "<DS>";
            case DomainType.REPOSITORY -> "<R>";
            case DomainType.DOMAIN_COMMAND -> "<DC>";
            case DomainType.DOMAIN_EVENT -> "<DE>";
            case DomainType.READ_MODEL -> "<RM>";
            case DomainType.IDENTITY -> "<I>";
            case DomainType.APPLICATION_SERVICE -> "<AS>";
            case DomainType.QUERY_HANDLER -> "<QH>";
            case DomainType.OUTBOUND_SERVICE -> "<OS>";
            case DomainType.SERVICE_KIND -> "<SK>";
            default -> "";
        };
    }

    private static String simpleTypeName(String fullQualifiedTypeName) {
        if (fullQualifiedTypeName.contains(".")) {
            return fullQualifiedTypeName.substring(fullQualifiedTypeName.lastIndexOf(".") + 1);
        }
        return fullQualifiedTypeName;
    }

    public static String stereotype(DomainTypeMirror domainTypeMirror, DomainDiagramConfig domainDiagramConfig) {
        return switch (domainTypeMirror.getDomainType()) {
            case DomainType.AGGREGATE_ROOT -> "AggregateRoot";
            case DomainType.ENTITY -> "Entity";
            case DomainType.VALUE_OBJECT -> "ValueObject";
            case DomainType.ENUM -> "Enum";
            case DomainType.DOMAIN_SERVICE -> "DomainService";
            case DomainType.APPLICATION_SERVICE -> {
                if (domainDiagramConfig.getGeneralVisualSettings().isCallApplicationServiceDriver()) {
                    yield "Driver";
                }
                yield "ApplicationService";
            }
            case DomainType.REPOSITORY -> "Repository";
            case DomainType.DOMAIN_COMMAND -> "DomainCommand";
            case DomainType.DOMAIN_EVENT -> "DomainEvent";
            case DomainType.IDENTITY -> "Identity";
            case DomainType.READ_MODEL -> "ReadModel";
            case DomainType.QUERY_HANDLER -> "QueryHandler";
            case DomainType.OUTBOUND_SERVICE -> "OutboundService";
            case DomainType.SERVICE_KIND -> "ServiceKind";
            default -> "";
        };
    }
}

